
<?php $__env->startSection('content'); ?>
<?php Fun::lang() ?>
<div class="top-header">
    <ol class="breadcrumb">
        <li><a href="#"><?php echo e(__('administrator.Dashboard')); ?></a></li>
        <li><a href="<?php echo e(route('capital-sharing.index')); ?>"><?php echo e(__('administrator.account_receivable')); ?></a></li>
        <li class="active"><?php echo e(__('administrator.account_receivable')); ?></li>
    </ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="title-add">
                    <div class="pull-left">
                        <h3><?php echo e(__('administrator.account_receivable')); ?> </h3>
                    </div>
                    <div class="pull-right">
                        <button class="button_success show_all"><span class="fa fa-eye"></span> SHOW ALL</button>
                        <a href="<?php echo e(route('account-receivable.create')); ?>" class=" button_info"><span class="fa fa-plus"></span> <?php echo e(__('administrator.account_receivable')); ?></a>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div>
                </div>
            </div>
        </div>
    </div>
    <div class="wrapper-table">
        <table id="datatable_account_receivable" width="100%" class="table table-striped table-hover ">
            <thead>
                <tr>

                    <th>#</th>

                    <th><?php echo e(__('administrator.customer_name')); ?></th>
                    <th><?php echo e(__('administrator.customer_phone')); ?></th>
                    <th><?php echo e(__('administrator.invoice')); ?></th>
                    <th><?php echo e(__('administrator.description')); ?></th>
                    <th><?php echo e(__('administrator.date')); ?></th>
                    <th><?php echo e(__('administrator.receivable_amount')); ?></th>
                    <th><?php echo e(__('administrator.receivable_refunds')); ?></th>
                    <th><?php echo e(__('administrator.receivable_remain')); ?></th>
                    <!-- <th>
                        <label class="checkbox-list">
                            <input type="checkbox" id="check_all">
                        </label>
                    </th> -->
                    <th>
                        Action
                    </th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
            <tfoot class="tfoot">
            </tfoot>
        </table>
    </div>
</div>
<div class="modal fade bs-modal-lg" id="show_modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo e(__('administrator.account_receivable')); ?> </h4>
            </div>
            <form role="form" method="POST" action="<?php echo e(route('account_receivable_pay')); ?>">
                <?php echo e(csrf_field()); ?>

                <table id="datatable_account_receivable" width="100%" class="table table-striped table-hover ">
                    <thead>
                        <tr>

                            <th>#</th>

                            <th><?php echo e(__('administrator.customer_name')); ?></th>
                            <th><?php echo e(__('administrator.customer_phone')); ?></th>
                            <th><?php echo e(__('administrator.invoice')); ?></th>

                            <th><?php echo e(__('administrator.description')); ?></th>
                            <th><?php echo e(__('administrator.date')); ?></th>
                            <th><?php echo e(__('administrator.receivable_amount')); ?></th>
                            <th><?php echo e(__('administrator.receivable_refunds')); ?></th>
                            <th><?php echo e(__('administrator.receivable_remain')); ?></th>

                        </tr>
                    </thead>
                    <tbody class="tbody_show">

                    </tbody>
                    <tfoot class="tfoot_show">

                    </tfoot>
                </table>

                <div class="modal-footer">
                    <button type="submit" class="btn bg-olive btn-flat margin">Pay</button>
                    <button type="button" class="button_danger" data-dismiss="modal">Cancel</button>

                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade bs-modal-lg" id="payment_modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>
                <h3 class="modal-title">Do Payment</h3>
            </div>
            <br />

            <form class="form-edit" method="POST" action="<?php echo e(route('account_receivable_pay')); ?>" id="payment">
                <?php echo e(csrf_field()); ?>

                <div class="modal-body">
                    <div class="form-group">
                        <label class="control-label" for="title">Invoice Number</label>
                        <input type="hidden" class="form-control" id="id" name="receivable_id">
                        <input type="text" class="form-control" id="invoice" name="invoice" required readonly>
                    </div>
                    <div class="form-group">
                        <label for=""><?php echo e(__('administrator.receivable_remain')); ?></label>
                        <input type="text" class="form-control" name="receivable_pay" id="receivable_pay" readonly>
                    </div>
                    <div class="form-group">
                        <label for="" class="required"><?php echo e(__('administrator.amount')); ?></label>
                        <input type="text" class="form-control" id="remain_amount" name="remain_amount" required autocomplete="off">
                        <input type="hidden" name="pay_step" value="1">
                    </div>
                    <div class="form-group" id="next_payment">
                        <label class="required"><?php echo e(__('administrator.next_payment')); ?></label>
                        <input type="text" class="form-control date_picker next-payment" name="date">
                    </div>
                    <div class="form-group">
                        <label class="required"><?php echo e(__('administrator.date')); ?></label>
                        <input type="text" class="form-control date_picker" name="receivable_date" value="<?php echo e(date('d-m-Y')); ?>">
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="button_danger"><i class="fa fa-close"></i> No</button>
                    <button type="submit" class="btn bg-olive btn-flat margin deleteRecord" data-toggle="modal"><i class="fa fa-save"></i> OK</button>
                </div>
            </form>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        $('.main-spinner').show();
        var index = $('#datatable_account_receivable').DataTable({
            "pagingType": "full_numbers",
            language: {
                paginate: {
                    first: '<i class="fa-gradient fa fa-fast-backward"></i>',
                    last: '<i class="fa-gradient fa fa-fast-forward"></i>',
                    next: '<i class="fa-gradient fa fa-forward"></i>',
                    previous: '<i class="fa-gradient fa fa-backward"></i>'
                }
            },
            lengthMenu: tbLength,
            "ordering": false,
            ajax: "<?php echo e(route('datatable.receivable-alert')); ?>",
            columns: [{
                    data: 'DT_RowIndex'
                },
                {
                    data: 'customer_name'
                },
                {
                    data: 'customer_phone'
                },
                {
                    data: 'receivable_invoice'
                },
                {
                    data: 'description'
                },
                {
                    data: 'receivable_date'
                },
                {
                    data: 'receivable_amount'
                },
                {
                    data: 'receivable_refunds'
                },
                {
                    data: 'remain_amount'
                },
                {
                    data: 'action'
                }
            ],
            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });
        index.on('order.dt search.dt', function() {
            index.column(0, {
                search: 'applied',
                order: 'applied'
            }).nodes().each(function(cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();
        $.fn.dataTable.ext.errMode = 'throw';
    });
    $(document).on('change', '#check_all', function() {
        if ($('#check_all').prop('checked') == true) {
            $('.checkbox').each(function(){
                $(this).prop('checked',true);
            });
        } else {
            $('.checkbox').each(function(){
                $(this).prop('checked',false);
            });
        }
    });
    $(document).on('click','.btn-payment',function(){
        var id      = $(this).data('id');
        var amount  = $(this).data('remain');
        var invoice = $(this).data('invoice');
        $('#id').val(id);
        $('#receivable_pay').val(amount);
        $('#invoice').val(invoice);
        $('#payment_modal').modal('show');
    });
    $(document).on('keyup','#remain_amount',function(){
        var amount = $(this).val();
        var remain = $('#receivable_pay').val();
        amount = parseFloat(amount);
        remain = parseFloat(remain);
        if(amount==remain){
            var div = $('#next_payment').is(':visible');
            if(div){
                $('#next_payment').toggle('hide');
            }
        }
        else{
            if(amount>remain){
                $.confirm({
                    title: 'Over Ammount!',
                    content: 'Payment Greater than Owed Amount , Please Check Remain Amount Again!',
                    type: 'red',
                    typeAnimated: true,
                    buttons: {
                        tryAgain: {
                            text: 'Try again',
                            btnClass: 'btn-red',
                            action: function (){
                            }
                        },
                    }
                });
            }
            else{
                var div = $('#next_payment').is(':hidden');
                if(div){
                    $('#next_payment').toggle('show');
                }
            }
        }
    });
    $(document).on('submit','#payment',function(){
        var remain = $('#receivable_pay').val();
        var amount = $('#remain_amount').val();
        amount = parseFloat(amount);
        remain = parseFloat(remain);
        if(amount<remain){
            if($('.next-payment').val().length<=0){
                $.confirm({
                    title: 'No Date Selected!',
                    content: 'Please Select next Payment Before Saving!',
                    type: 'red',
                    typeAnimated: true,
                    buttons: {
                        tryAgain: {
                            text: 'Try again',
                            btnClass: 'btn-red',
                            action: function (){
                            }
                        },
                    }
                });
                return false;
            }
        }
        else{
            if(amount>remain){
                $.confirm({
                    title: 'Over Amount!',
                    content: 'Payment is greater than remain amount!',
                    type: 'red',
                    typeAnimated: true,
                    buttons: {
                        tryAgain: {
                            text: 'Try again',
                            btnClass: 'btn-red',
                            action: function () {
                            }
                        },
                    }
                });
                return false;
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/customer-payment/alert.blade.php ENDPATH**/ ?>