
<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>

    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <div class="row">
                    <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                        <h3><?php echo e(__('administrator.sale_request_payment')); ?></h3>
                    </div>
                </div>
                <div class="container-fluid" style="background: white; padding:10px">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.request_by')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::select('user_id',$seller,null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.customer')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::select('customer_id',$customer,null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.status')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::select('status', getPaymentStatus() ,null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.from_date')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::text('from_date', null, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','autocomplete' => 'off','required')); ?>

                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.to_date')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::text('to_date', null, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','autocomplete' => 'off','required')); ?>

                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                <div class="col-sm-12">
                                    <button type="submit" id="search"
                                            class="button_info pull-right"><?php echo e(__('administrator.search')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="data_table" class="table table-hover" width="100%">
                            <thead>
                            <tr>
                                <th width="5%">#</th>
                                <th><?php echo e(__('administrator.date')); ?></th>
                                <th><?php echo e(__('administrator.invoice')); ?></th>
                                <th><?php echo e(__('administrator.request_by')); ?></th>
                                <th><?php echo e(__('administrator.customer')); ?></th>
                                <th><?php echo e(__('administrator.contact')); ?></th>
                                <th><?php echo e(__('administrator.amount')); ?></th>
                                <th><?php echo e(__('administrator.refund')); ?></th>
                                <th><?php echo e(__('administrator.remain_amount')); ?></th>
                                <th><?php echo e(__('administrator.status')); ?></th>
                                <th width="10%"><?php echo e(__('administrator.action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            getTable();
        });
        $(document).on('click', '#search', function () {
            getTable();
        });
        $(document).ready(function () {
            $(document).on('keyup', '.amount', function () {
                let remain = parseFloat($('.remain').data('pp').replace(/\,/g, ''));
                if (parseFloat($(this).val()) > remain) {
                    $(this).val(remain);
                }
            });
            $('#data_table tbody').on('click', '.btn_add_payment', function () {
                $id = $(this).data('id');
                $url = '<?php echo e(route("get-payment-sale-request",':id')); ?>';
                $url = $url.replace(':id', $id);
                $.confirm({
                    title: '<?php echo e(__('administrator.add_payment')); ?>',
                    columnClass: 'col-md-8 col-md-offset-2',
                    closeIcon: true,
                    content: function () {
                        let self = this;
                        return $.ajax({
                            url: $url,
                            dataType: 'html',
                            method: 'get',
                            data: {
                                "_token": "<?php echo e(csrf_token()); ?>",
                            },
                        }).done(function (response) {
                            self.setContent(response);
                        }).fail(function () {
                            $.alert('Something wrong !<br><b class="text-danger">Please Reload</b>');
                        });
                    },
                    buttons: {
                        cancel: {
                            text: '<?php echo e(__('administrator.cancel')); ?>',
                            btnClass: 'button_warning cancel_btn',
                            keys: ['escape'],
                        },
                        submit: {
                            text: '<?php echo e(__('administrator.submit')); ?>',
                            btnClass: 'btn bg-olive btn-flat margin submit_btn',
                            keys: ['enter'],
                            action: function () {
                                let self = this;
                                self.buttons.submit.disable();
                                let form = $('#form_submit').serialize();
                                $.ajax({
                                    url: '<?php echo e(route('add-payment-sale-request')); ?>',
                                    dataType: 'json',
                                    method: 'post',
                                    data: form,
                                    success: function (data) {
                                        if (data.status === "alert") {
                                            $.alert({
                                                title: 'Add payment successful',
                                                content: '',
                                                icon: 'fa fa-check',
                                                theme: 'modern',
                                                autoClose: 'okreload|100',
                                                buttons: {
                                                    okreload: {
                                                        btnClass: 'button_info',
                                                        text: 'OK',
                                                        action: function () {
                                                            getTable();
                                                            $(document).find('.cancel_btn').trigger('click');
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    },
                                    error(xhr) {
                                        alertErrorFormController(xhr, self);
                                    }
                                });
                                return false;
                            },
                        },
                    }
                });
            });
        });

        function getTable() {
            let user_id = $('select[name="user_id"]').val();
            let customer_id = $('select[name="customer_id"]').val();
            let status = $('select[name="status"]').val();
            let start_date = $('input[name="from_date"]').val();
            let end_date = $('input[name="to_date"]').val();
            $('#data_table').DataTable().destroy();
            $('#data_table').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                    },
                },
                ordering: false,
                processing: false,
                serverSide: true,
                lengthMenu: tbLength,
                ajax: {
                    url: "<?php echo e(route('get-payments-sale-request-table')); ?>",
                    data: {
                        user_id: user_id,
                        customer_id: customer_id,
                        status: status,
                        start_date: start_date,
                        end_date: end_date,
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'payment_date'},
                        {data: 'invoice_number', 'name': 'nso007_sales.invoice_number'},
                        {data: 'user_id', 'searchable': false},
                        {data: 'customer_name', 'searchable': false},
                        {data: 'customer_phone', 'searchable': false},
                        {data: 'payment_amount'},
                        {data: 'paid_amount'},
                        {data: 'remain', 'searchable': false},
                        {data: 'payment_status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                }

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/payment/sale-request/index.blade.php ENDPATH**/ ?>