
<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<style>
    .padding-5{
        padding: 5px !important;
    }
    .fa-pencil{
        cursor: pointer !important;
    }
    .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content{
        overflow: hidden;
    }
    .ui-timepicker-container{
        z-index: 99999999 !important;
    }
</style>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3><?php echo e(__('administrator.lead_source')); ?></h3>
                        </div>
                        <div class="pull-right">
                                <a class="btn bg-olive btn-flat margin"><span class="fa fa-plus"></span> <?php echo e(__('administrator.new_record')); ?></a>

                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th width="5%">N°</th>
                        <th><?php echo e(__('administrator.type')); ?></th>
                        <th><?php echo e(__('administrator.lead_source')); ?></th>
                        <th><?php echo e(__('administrator.note')); ?></th>
                        <th width="15%"><?php echo e(__('administrator.action')); ?></th>
                    </tr>

                </thead>
                <tbody>

                </tbody>

            </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    $(document).ready(function() {
       getTable();
    });


    $(document).on('click', '.page-item', function() {
        page = $('.page-item.active .page-link').text();

       getTable();

    });

    function getTable() {
        $('#data_table').DataTable().destroy();
        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                },
            },
            serverSide: true,
            ordering: false,
            searching: false,
            pageLength: record,
            lengthMenu: tbLength,
            ajax: {
                url:"<?php echo e(route('lead-source.index')); ?>",
                data:{
                    record,
                    page
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'type'},
                    {data: 'source_name'},
                    {data: 'note'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {
                $('select[name="data_table_length"]').val(json.records);
                $('.dataTables_paginate').empty();
                $('#data_table_paginate').twbsPagination('destroy');
                $('#data_table_paginate').twbsPagination({
                    totalPages: json.totalPage,
                    visiblePages: 5,
                    startPage: parseInt(json.activePage),
                    next: 'Next',
                    prev: 'Prev',
                    onPageClick: function (event, pageD) {
                    }
                });
            }
        });
    }
// end

// create lead source
$('.btn.bg-olive.btn-flat').on('click', function () {
    getHtmlForm('<?php echo e(route('lead-source.create')); ?>', '<?php echo e(__('administrator.create').' '.__('administrator.lead_source')); ?>');
});
// end

// edit lead source
$('#data_table').on('click','.fa.fa-pencil.btn.btn-sm.btn-warning',function () {
    getHtmlForm($(this).data('href'), '<?php echo e(__('administrator.edit').' '.__('administrator.lead_source')); ?>');
});

// delete Lead source
    $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function(){
        var url = $(this).data('url');
        $.confirm({
            icon: 'flaticon-danger',
            title: '<?php echo e(__('administrator.confirm')); ?>!',
            content:  '<?php echo e(__('administrator.are_you_sure')); ?>!',
            type: 'red',
            typeAnimated: true,
            closeIcon: true,
            closeIconClass: 'flaticon-close',
            buttons: {
                '<?php echo e(__('administrator.confirm')); ?>': {
                    btnClass: 'btn-red',
                    action: function () {
                        $.ajax({
                            type: 'DELETE',
                            url: url,
                            data:{
                                '_token': '<?php echo e(csrf_token()); ?>'
                            },
                            dataType:'json',
                            success:function(data){
                                if(data[1] == 401){
                                    showWarningToast(data[0]);
                                }else{
                                    showSuccessToast('Lead Source deleted successfully!');
                                    $('.jconfirm-buttons .btn-default').trigger('click');
                                    $('#data_table').DataTable().destroy();
                                   getTable();
                                }
                            }
                        });
                        return false;
                    }
                },
                <?php echo e(__('administrator.cancel')); ?>: {
                    action: function () {
                    }
                }
            }
        });
    });
// end
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/crm/lead_source/index.blade.php ENDPATH**/ ?>