
<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#"><?php echo e(__('administrator.Dashboard')); ?></a></li>
      <li><a href="<?php echo e(route('capital-sharing.index')); ?>"><?php echo e(__('administrator.account_receivable')); ?></a></li>
      <li class="active"><?php echo e(__('administrator.account_receivable')); ?></li>
    </ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="title-add">
                    <div class="pull-left">
                        <h3><?php echo e(__('administrator.account_receivable')); ?> </h3>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div>
                    <?php echo Form::open(array('route' => 'dt_seach_account_receivable','method'=>'POST')); ?>

                      <div class="col-sm-6">
                      <div class="form-group">
                      <?php echo Form::text('from_date', null, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','autocomplete' => 'off','required')); ?>

                      </div>
                      </div>
                      <div class="col-sm-6">
                      <div class="form-group">
                      <?php echo Form::text('to_date', null, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','autocomplete' => 'off','required')); ?>

                      </div>
                      </div>
                      <div class="col-sm-12">
                      <button class=" button_info pull-right" onclick="searching()" type="button"> <?php echo e(__('administrator.searching')); ?></button>
                      </div>
                        <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>
     <div class="wrapper-table">
        <table id="datatable_account_receivable" width="100%" class="table table-striped table-hover ">
             <thead>
                <tr>
                    
                   <th>#</th>
                   
                    <th><?php echo e(__('administrator.customer_name')); ?></th>
                    <th><?php echo e(__('administrator.customer_phone')); ?></th>
                    <th><?php echo e(__('administrator.invoice')); ?></th>
                    <th><?php echo e(__('administrator.description')); ?></th>
                    <th><?php echo e(__('administrator.date')); ?></th>
                      <th><?php echo e(__('administrator.receivable_amount')); ?></th>
                    <th><?php echo e(__('administrator.receivable_refunds')); ?></th>
                    <th><?php echo e(__('administrator.receivable_remain')); ?></th>
                   
                    
                </tr>
            </thead>
            <tbody class="tbody">
                
            </tbody>
            <tfoot class="tfoot">
                <tr>
                    
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th class="green"></th>
                    <th  class="yellow"></th>
                    <th  class="green"></th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>

    <script type="text/javascript">
        function searching(){

        var from_date = $("input[name=from_date]").val();
        var to_date = $("input[name=to_date]").val();
        var table = '';
        var i = 0;
        var total_amount =0;
        var total_refunds =0;
        var total_remain_amount =0;
        $('.tbody').empty();
        $('.tfoot').empty();
        $.ajax({
          method:'POST',
          dataType:'json',
          url: "<?php echo e(route('dt_seach_account_receivable')); ?>",
          async: false,
          data: {

            _token: '<?php echo e(csrf_token()); ?>',
            from_date: from_date,
            to_date: to_date,
          },
          success: function (response) { 
            $.each(response, function (index, val) {  
                i++;
                str = val.receivable_date;
                st2 = str.split("-");
                yr = st2[0];
                mo = st2[1];
                dy = st2[2];
                var new_date = dy+'-'+mo+'-'+yr;

                table += "<tr class='remove'>" +
                              "<td>" +  i + "</td>" +
                              "<td>" + val.supplier_name + "</td>" +
                              "<td>" + val.supplier_phone + "</td>" +
                              "<td>" + val.receivable_invoice + "</td>" +
                              "<td>" + val.description + "</td>" +
                              "<td>" + new_date + "</td>" +
                              "<td>$ " + parseFloat(val.receivable_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "</td>" +
                              "<td>$ " + parseFloat(val.receivable_refunds).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "</td>" +
                              "<td>$ " + parseFloat(val.remain_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "</td>" +
                            "</tr>";

                            total_amount += parseFloat(val.receivable_amount);
                            total_refunds += parseFloat(val.receivable_refunds);
                            total_remain_amount += parseFloat(val.remain_amount);
            });

            $('.dataTables_filter').hide();
            $('.dataTables_info').hide();
            $('.pagination').hide();
            $('.dataTables_length').hide();
            var tfoot = ` <tr>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th class="green">$ ${parseFloat(total_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                          <th class="green">$ ${parseFloat(total_refunds).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                          <th class="green">$ ${parseFloat(total_remain_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                          </tr>`;
            $('.tbody').append(table);
            $('.tfoot').append(tfoot);

          },

        });
    }



        $(document).ready(function() {
            $('#datatable_account_receivable').DataTable({
                lengthMenu:tbLength,
                ordering: false,
                serverSide: true,
                ajax: "<?php echo e(route('datatable_account_receivable')); ?>",
                columns: [
                    {"data": "DT_RowIndex","searchable": false},
                    
                    {data: 'customer_name','name':'nso007_suppliers.customer_name'},
                    {data: 'customer_phone','name':'nso007_suppliers.customer_phone'},
                    {data: 'receivable_invoice','name':'nso007_account_receivable.receivable_invoice'},
                   
                    {data: 'description','name':'nso007_account_receivable.description'},
                    {data: 'receivable_date',"searchable": false},
                     {data: 'receivable_amount','name':'nso007_account_receivable.receivable_amount'},
                    {data: 'receivable_refunds','name':'nso007_account_receivable.receivable_refunds'},
                    {data: 'remain_amount'},
                     
                ],
                "footerCallback": function ( row, data, start, end, display ) {
                  var api = this.api(), data;
                  var intVal = function ( i ) {
                      return typeof i === 'string' ?
                          i.replace(/[\$,]/g, '')*1 :
                          typeof i === 'number' ?
                              i : 0;
                  };
                  var receivable_amount = api
                      .column( 6 )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );

                    var receivable_refunds = api
                      .column( 7 )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );

                    var receivable_remain = api
                      .column( 8 )
                      .data()
                      .reduce( function (a, b) {
                          return intVal(a) + intVal(b);
                      }, 0 );
                
              
                  var numFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$ ' ).display;
                  $( api.column( 6 ).footer() ).html(numFormat(receivable_amount));
                  $( api.column( 7 ).footer() ).html(numFormat(receivable_refunds));
                  $( api.column( 8 ).footer() ).html(numFormat(receivable_remain));
                },         
            });
            
            $.fn.dataTable.ext.errMode = 'throw';
        });




        
    </script>
<?php $__env->stopSection(); ?>

    


<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/customer-payment/report.blade.php ENDPATH**/ ?>