
<?php $__env->startSection('content'); ?>
    <?php Fun::lang() ?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#"><?php echo e(__('administrator.Dashboard')); ?></a></li>
            <li class="active"><?php echo e(__('administrator.customer_payment')); ?></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div>
                            <b style="font-size: 30px"><?php echo e(__('administrator.customer_payment')); ?></b>
                        </div>
                    </div>
                </div>
            </div>
            <br>&nbsp;
            <br>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <?php echo Form::open(array('route' => 'datatable_account_receivable','method'=>'POST')); ?>

                        <div class="col-sm-3">
                            <div class="form-group col-sm-3">
                                <label for="name"><?php echo e(__('administrator.client')); ?></label>
                            </div>
                            <div class="form-group col-sm-9">
                                <?php echo Form::select('customer_id', $customers, null, ['class' => 'form-control select2','id'=>'customer_id']); ?>

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group col-sm-3">
                                <label for="name"><?php echo e(__('administrator.status')); ?></label>
                            </div>
                            <div class="form-group col-sm-9">
                                <?php echo Form::select('status', [''=>__('administrator.please_select'),'Due'=>__('administrator.owed'),'Paid'=>__('administrator.paid')], null, ['class' => 'form-control select2','id'=>'']); ?>

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group col-sm-3">
                                <label for="name"><?php echo e(__('administrator.date')); ?></label>
                            </div>
                            <div class="form-group  col-sm-9">
                                <?php echo Form::text('date', null, ['class' => 'form-control date_picker input-sm date_search','id'=>'']); ?>

                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="pull-right">
                                <a class="button_danger cursor" onclick="searching()"><span class="fa fa-search"></span> <?php echo e(__('administrator.searching')); ?></a>
                                <a class="button_info show_all cursor"><span class="fa fa-eye"></span> <?php echo e(__('administrator.show_all')); ?></a>
                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="datatable_account_receivable" width="100%" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(__('administrator.customer_name')); ?></th>
                        <th><?php echo e(__('administrator.customer_phone')); ?></th>
                        <th><?php echo e(__('administrator.invoice')); ?></th>
                        <th><?php echo e(__('administrator.date')); ?></th>
                        <th><?php echo e(__('administrator.receivable_amount')); ?></th>
                        <th><?php echo e(__('administrator.receivable_refunds')); ?></th>
                        <th><?php echo e(__('administrator.receivable_remain')); ?></th>
                        <th><?php echo e(__('administrator.status')); ?> <input type="checkbox" id="check_all"></th>
                        <th>
                            <?php echo e(__('administrator.action')); ?>

                        </th>
                    </tr>
                    </thead>
                    <tbody class="tbody">

                    </tbody>
                    <tfoot class="tfoot">
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th class="green"></th>
                        <th class="yellow"></th>
                        <th class="green"></th>
                        <th></th>
                        <th></th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        <div class="modal fade bs-modal-lg" id="show_modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dm">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title"><?php echo e(__('administrator.account_receivable')); ?> </h4>
                    </div>
                    <form role="form" method="POST" action="<?php echo e(route('customer-payment-pay')); ?>">
                        <?php echo e(csrf_field()); ?>

                        <div class="modal-body">
                            <table id="datatable_account_receivable" width="100%" class="table table-striped table-hover ">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo e(__('administrator.customer_name')); ?></th>
                                    <th><?php echo e(__('administrator.customer_phone')); ?></th>
                                    <th><?php echo e(__('administrator.invoice')); ?></th>
                                    <th><?php echo e(__('administrator.description')); ?></th>
                                    <th><?php echo e(__('administrator.date')); ?></th>
                                    <th><?php echo e(__('administrator.receivable_amount')); ?></th>
                                    <th><?php echo e(__('administrator.receivable_refunds')); ?></th>
                                    <th><?php echo e(__('administrator.receivable_remain')); ?></th>
                                </tr>
                                </thead>
                                <tbody class="tbody_show">

                                </tbody>
                                <tfoot class="tfoot_show">

                                </tfoot>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <div class="col-sm-2">
                                        <label for=""><?php echo e(__('administrator.date')); ?></label>
                                    </div>
                                    <div class="col-sm-4">
                                        <input type="text" class="form-control date_picker"
                                               value="<?php echo e(date('d-m-Y')); ?>"
                                               name="payment_date">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn bg-olive btn-flat margin"><?php echo e(__('administrator.pay')); ?></button>
                            <button type="button" class="button_danger" data-dismiss="modal"><?php echo e(__('administrator.cancel')); ?></button>

                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="modal fade bs-modal-lg" id="payment_modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dm">
                <div class="modal-content">
                    <div class="modal-header">
                        <span class="cursor text-red fa fa-close fa-2x pull-right" data-dismiss="modal" aria-hidden="true"></span>
                        <h3 class="modal-title">Are you sure?</h3>
                    </div>
                    <br/>

                    <form class="form-edit" method="POST" action="<?php echo e(route('customer-payment-pay')); ?>"
                          id="payment">
                        <?php echo e(csrf_field()); ?>

                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label" for="title">Invoice Number</label>
                                <input type="hidden" class="form-control" id="id" name="payment_id">
                                <input type="text" class="form-control" name="invoice" required readonly>
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('administrator.remain_amount')); ?></label>
                                <input type="text" class="form-control" name="payment_pay"
                                       id="payment_pay"
                                       readonly>
                            </div>
                            <div class="form-group">
                                <label for="" class="required"><?php echo e(__('administrator.amount')); ?></label>
                                <input type="text" class="form-control number-only" id="remain_amount" name="remain_amount"
                                       required
                                       autocomplete="off">
                                <input type="hidden" name="pay_step" value="1">
                            </div>
                            <div class="form-group" id="next_payment">
                                <label class="required"><?php echo e(__('administrator.next_payment')); ?></label>
                                <input type="text" class="form-control date_picker next-payment" name="date">
                            </div>
                            <div class="form-group">
                                <label class="required"><?php echo e(__('administrator.date')); ?></label>
                                <input type="text" class="form-control date_picker" value="<?php echo e(date('d-m-Y')); ?>"
                                       name="payment_date">
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="button_success deleteRecord" data-toggle="modal"><i
                                        class="fa fa-save"></i> <?php echo e(__('administrator.pay_now')); ?>

                            </button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
        <?php $__env->stopSection(); ?>
        <?php $__env->startSection('script'); ?>

            <script type="text/javascript">
                $('#check_all').hide();
                $(document).on('keyup','#remain_amount',function () {
                    check_amt = parseFloat($('#payment_pay').val());
                    thisval = $(this);
                    if(check_amt<parseFloat(thisval.val())){
                        thisval.val(check_amt);
                    }
                });
                $(document).on('keyup', '#remain_amount', function () {
                    var amount = $(this).val();
                    var remain = $('#payment_pay').val();
                    amount = parseFloat(amount);
                    remain = parseFloat(remain);
                    if (amount == remain) {
                        var div = $('#next_payment').is(':visible');
                        if (div) {
                            $('#next_payment').toggle('hide');
                        }
                    } else {
                        if (amount > remain) {
                            $.confirm({
                                title: 'Over Amount!',
                                content: 'Payment Greater than Owed Amount , Please Check Remain Amount Again!',
                                type: 'red',
                                typeAnimated: true,
                                buttons: {
                                    tryAgain: {
                                        text: 'Try again',
                                        btnClass: 'btn-red',
                                        action: function () {
                                        }
                                    },
                                }
                            });
                        } else {
                            var div = $('#next_payment').is(':hidden');
                            if (div) {
                                $('#next_payment').toggle('show');
                            }
                        }
                    }
                });
                $(document).on('submit', '#payment', function () {
                    var remain = $('#payment_pay').val();
                    var amount = $('#remain_amount').val();
                    amount = parseFloat(amount);
                    remain = parseFloat(remain);
                    if (amount < remain) {
                        if ($('.next-payment').val().length <= 0) {
                            $.confirm({
                                title: 'No Date Selected!',
                                content: 'Please Select next Payment Before Saving!',
                                type: 'red',
                                typeAnimated: true,
                                buttons: {
                                    tryAgain: {
                                        text: 'Try again',
                                        btnClass: 'btn-red',
                                        action: function () {
                                        }
                                    },
                                }
                            });
                            return false;
                        }
                    } else {
                        if (amount > remain) {
                            $.confirm({
                                title: 'Over Amount!',
                                content: 'Payment is greater than remain amount!',
                                type: 'red',
                                typeAnimated: true,
                                buttons: {
                                    tryAgain: {
                                        text: 'Try again',
                                        btnClass: 'btn-red',
                                        action: function () {
                                        }
                                    },
                                }
                            });
                            return false;
                        }
                    }
                });

                function searching() {

                    var customer_id = $("select[name=customer_id]").val();
                    var status = $("select[name=status]").val();
                    var date = $(".date_search").val();
                    var table = '';
                    var i = 0;
                    var total_amount = 0;
                    var total_refunds = 0;
                    var total_remain_amount = 0;
                    $('.tbody').empty();
                    $('.tfoot').empty();
                    var url_show = '<?php echo e(route("account-receivable.show", ":id")); ?>';

                    $.ajax({
                        method: 'post',
                        dataType: 'json',
                        url: "<?php echo e(route('datatable.customer-payment')); ?>",
                        async: false,
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            customer_id: customer_id,
                            status: status,
                            search_date: date,
                        },
                        success: function (response) {
                            $.each(response, function (index, val) {
                                i++;
                                str = val.payment_date;
                                st2 = str.split("-");
                                yr = st2[0];
                                mo = st2[1];
                                dy = st2[2];
                                var new_date = dy + '-' + mo + '-' + yr;
                                route_show = url_show.replace(':id', val.id);
                                var checked_searching = '';
                                var payment_searching = '';
                                if (val.payment_status == 'Paid') {
                                    checked_searching += "<span class='label label-success'><?php echo e(__('administrator.paid')); ?></span>";
                                    payment_searching += "<a href='" + route_show + "' class='button_info'><?php echo e(__('administrator.show')); ?></a>";
                                } else {
                                    if(customer_id!=''){
                                        $('#check_all').show();
                                        checked_searching += "<label class='checkbox-list'>" +
                                            "<span class='row1'>" +
                                            "<div class='col-sm-4'>" +
                                            "<input type='checkbox' class='checkbox' data-id='" + val.id + "'>" +
                                            "</div>" +
                                            "<div class='col-sm-8'>" +
                                            "<span class='label label-danger'><?php echo e(__('administrator.owed')); ?></span>"+
                                            "</div>" +
                                            "</span>" +
                                            "</label></td>";
                                    }
                                    else{
                                        checked_searching +="<span class='label label-danger'><?php echo e(__('administrator.owed')); ?></span>";
                                        $('#check_all').hide();
                                    }
                                    payment_searching += "<a href='" + route_show + "' class='button_info'><?php echo e(__('administrator.show')); ?></a>"+
                                        "<span class='button_warning payment cursor' data-id='" + val.id + "' data-invoice='" + val.payment_invoice + "' data-amount='" + val.remain_amount + "'><?php echo e(__('administrator.payment')); ?>" + "</span>"
                                    ;
                                }
                                table += "<tr class='remove'>" +
                                    "<td>" + i + "</td>" +
                                    "<td>" + val.customer_name + "</td>" +
                                    "<td>" + val.customer_phone + "</td>" +
                                    "<td>" + val.payment_invoice + "</td>" +
                                    "<td>" + new_date + "</td>" +
                                    "<td>$ " + parseFloat(val.payment_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "</td>" +
                                    "<td>$ " + parseFloat(val.payment_refunds).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "</td>" +
                                    "<td>$ " + parseFloat(val.remain_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "</td>" +
                                    "<td>" + checked_searching + "</td>" +
                                    "<td>" + payment_searching + "</td>" +
                                    "</tr>";

                                total_amount += parseFloat(val.payment_amount);
                                total_refunds += parseFloat(val.payment_refunds);
                                total_remain_amount += parseFloat(val.remain_amount);
                            });

                            $('.dataTables_filter').hide();
                            $('.dataTables_info').hide();
                            $('.pagination').hide();
                            $('.dataTables_length').hide();
                            var tfoot = ` <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th class="green">$ ${parseFloat(total_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                            <th class="green">$ ${parseFloat(total_refunds).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                            <th class="green">$ ${parseFloat(total_remain_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</th>
                            <th></th>
                            <th></th>
                            </tr>`;
                            table = table!=''?table:'<tr><td colspan="10" class="text-center">No Data</td></tr>';
                            $('.tbody').append(table);
                            $('.tfoot').append(tfoot);

                        },

                    });
                }

                $(document).on('click', '.payment', function () {
                    var id = $(this).data('id');

                    var remain_amount = $(this).data('amount');
                    var invoice = $(this).data('invoice');
                    $('#id').val(id);
                    $("input[name=payment_id]").val(id);
                    $("input[name=invoice]").val(invoice);
                    $("input[name=payment_pay]").val(remain_amount.toFixed(2));
                    $("input[name=journal_credit]").val(remain_amount);
                    $('#payment_modal').modal('show');
                });

                $(document).ready(function () {
                    $('.main-spinner').show();
                    $('#datatable_account_receivable').DataTable({
                        lengthMenu: tbLength,
                        ordering: false,
                        serverSide: true,
                        ajax: "<?php echo e(route('datatable.customer-payment')); ?>",
                        columns: [{
                            "data": "DT_RowIndex",
                            "searchable": false
                        },

                            {
                                data: 'customer_name',
                                'name': 'nso007_customers.customer_name'
                            },
                            {
                                data: 'customer_phone',
                                'name': 'nso007_customers.customer_phone'
                            },
                            {
                                data: 'payment_invoice',
                                'name': 'nso007_payment.payment_invoice'
                            },

                            {
                                data: 'payment_date',
                                "searchable": false
                            },
                            {
                                data: 'payment_amount',
                                'name': 'nso007_payment.payment_amount'
                            },
                            {
                                data: 'payment_refunds',
                                'name': 'nso007_payment.payment_refunds'
                            },
                            {
                                data: 'remain_amount',
                                "searchable": false
                            },
                            {
                                data: 'check_id'
                            },
                            {
                                data: 'action'
                            },

                        ],
                        "footerCallback": function (row, data, start, end, display) {
                            var api = this.api(),
                                data;
                            var intVal = function (i) {
                                return typeof i === 'string' ?
                                    i.replace(/[\$,]/g, '') * 1 :
                                    typeof i === 'number' ?
                                        i : 0;
                            };
                            var receivable_amount = api
                                .column(5)
                                .data()
                                .reduce(function (a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);

                            var receivable_refunds = api
                                .column(6)
                                .data()
                                .reduce(function (a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);

                            var receivable_remain = api
                                .column(7)
                                .data()
                                .reduce(function (a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);


                            var numFormat = $.fn.dataTable.render.number('\,', '.', 2, '$ ').display;
                            $(api.column(5).footer()).html(numFormat(receivable_amount));
                            $(api.column(6).footer()).html(numFormat(receivable_refunds));
                            $(api.column(7).footer()).html(numFormat(receivable_remain));
                        },
                    });

                    $.fn.dataTable.ext.errMode = 'throw';
                });

                $('#check_all').on('click', function (e) {
                    if ($(this).is(':checked', true)) {
                        $(".checkbox").prop('checked', true);
                    } else {
                        $(".checkbox").prop('checked', false);
                    }
                });

                $('.checkbox').on('click', function () {
                    if ($('.checkbox:checked').length == $('.checkbox').length) {
                        $('#check_all').prop('checked', true);
                    } else {
                        $('#check_all').prop('checked', false);
                    }
                });
                $('.show_all').on('click', function (e) {

                    var idsArr = [];
                    $(".checkbox:checked").each(function () {
                        idsArr.push($(this).attr('data-id'));
                    });
                    if (idsArr.length <= 0) {
                        $('.alert-danger').show();
                    } else {

                        var strIds = idsArr.join(",");
                        var tbody_show = '';
                        var tfoot_show = '';
                        $('.tbody_show').empty();
                        $('.tfoot_show').empty();
                        var total_payment_refunds = 0;
                        var total_payment_amount = 0;
                        var total_remain_amount = 0;

                        $.ajax({
                            url: "<?php echo e(route('payment-show')); ?>",
                            type: 'GET',
                            dataType: 'json',
                            data: 'ids=' + strIds,
                            success: function (data) {

                                $.each(data, function (index, element) {

                                    tbody_show += `
                                        <tr>
                                            <td><input type="hidden" name="payment_id[]" value="${element.id}">${element.id}</td>
                                            <td>${element.customer_name}</td>
                                            <td>${element.customer_phone}</td>
                                            <td>${element.payment_invoice}</td>
                                            <td>${element.description?element.description:''}</td>
                                            <td>${element.payment_date}</td>
                                            <td>$ ${parseFloat(element.payment_amount).toFixed(2)}</td>
                                            <td>$ ${parseFloat(element.payment_refunds).toFixed(2)}</td>
                                            <td><input type="hidden" name="remain_amount[]" value="${element.remain_amount}">$ ${parseFloat(element.remain_amount).toFixed(2)}</td>
                                        </tr>`;
                                    total_payment_amount += parseFloat(element.payment_amount);
                                    total_payment_refunds += parseFloat(element.payment_refunds);
                                    total_remain_amount += parseFloat(element.remain_amount);
                                    console.log(tbody_show);
                                });

                                $('.tfoot_show').append(`
                                    <tr>
                                        <th colspan="6">TOTAL</th>
                                        <th class="green text-right" >$ ${parseFloat(total_remain_amount).toFixed(2)}</th>
                                        <th class="yellow">$ ${parseFloat(total_payment_refunds).toFixed(2)}</th>
                                        <th class="yellow">
                                        <input type="hidden" name="journal_credit" value="${total_remain_amount}">
                                        ${parseFloat(total_remain_amount).toFixed(2)}</th>
                                    </tr>`);
                                $('.tbody_show').append(tbody_show);
                                $('#show_modal').modal('show');
                            },
                            error: function (data) {
                                alert(data.responseText);
                            }
                        });

                    }
                });
                $('[data-toggle=confirmation]').confirmation({
                    rootSelector: '[data-toggle=confirmation]',
                    onConfirm: function (event, element) {
                        element.closest('form').submit();
                    }
                });
            </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/customer-payment/index.blade.php ENDPATH**/ ?>