<?php $__env->startSection('content'); ?>

<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><?php echo e(__('administrator.receipt')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <form class="form_data">
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.reference_invoice')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::text('reference_invoice',null, ['placeholder'=>__('administrator.reference_invoice'),'class' => 'form-control ']); ?>

                                </div>
                            </div>

                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.sale_by')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::select('user_id',getUsers(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']); ?>

                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.payment_methods')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::select('payment_type',getPaymentType(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']); ?>

                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.from_date')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']); ?>

                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    <?php echo e(__('administrator.to_date')); ?> :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    <?php echo Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']); ?>

                                </div>
                            </div>

                            <div class="col-sm-12 col-md-12 form-group text-right">
                                <button class="btn btn-md btn-warning btn-clear"
                                        type="button"><?php echo e(__('administrator.clear')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th><?php echo e(__('administrator.date')); ?></th>
                        <th><?php echo e(__('administrator.receipt_invoice')); ?></th>
                        <th><?php echo e(__('administrator.sale_by')); ?></th>
                        <th><?php echo e(__('administrator.member')); ?></th>
                        <th><?php echo e(__('administrator.grand_total')); ?></th>
                        <th><?php echo e(__('administrator.paid')); ?></th>
                        <th><?php echo e(__('administrator.remain_amount')); ?></th>
                        <th><?php echo e(__('administrator.payment_method')); ?></th>
                        <th><?php echo e(__('administrator.payment_status')); ?></th>
                        <th><?php echo e(__('administrator.action')); ?></th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    let table = $('#data_table');
    $(document).ready(function() {
        dataTable();
        $('.form_data').on('change','input,select',function () {
            page = 1;
            dataTable();
        });
        $('.btn-clear').on('click',function () {
            $('.form_data').find('select,input').val('').change();
            page = 1;
            dataTable();
        });
    });

$('.form_data').on('change', '.form-control.input-sm', function() {
        record = $(this).val();
        page = 1;
        dataTable();
    });

    $(document).on('click', '.page-item', function() {
        page = $('.page-item.active .page-link').text();
        dataTable();
    });

    function dataTable() {
        table.DataTable().destroy();
        table.DataTable({
            serverSide: true,
            ordering: false,
            searching: false,
            lengthMenu: tbLength,
            ajax: {
                url:"<?php echo e(route('wholesale.datatables')); ?>?"+$('.form_data').serialize(),
                data: {
                    type: 'paid',
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'sale_date'},
                    {data: 'reference_number'},
                    {data: 'seller'},
                    {data: 'member'},
                    {data: 'grand_total'},
                    {data: 'paid_amount_usd'},
                    {data: 'remain'},
                    {data: 'payment_method'},
                    {data: 'payment_status'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {
                // $('select[name="data_table_length"]').val(json.records);
               // $('.dataTables_paginate').empty();
                // $('#data_table_paginate').twbsPagination('destroy');
                // $('#data_table_paginate').twbsPagination({
                //     totalPages: json.totalPage,
                //     visiblePages: 5,
                //     startPage: parseInt(json.activePage),
                //     next: 'Next',
                //     prev: 'Prev',
                //     onPageClick: function (event, pageD) {
                //     }
                // });
            }
        });
    }
// end

    $(document).on('click', '.showDetail', function(){
      getHtmlFormShow($(this).data('href'),'700px');
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/pos-wholesale/reciept.blade.php ENDPATH**/ ?>