<?php $__env->startSection('content'); ?>
    <?php Fun::lang();
    $ifMember = request()->path() === 'member';
    ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3 class="set_menu_name"></h3>
                                </div>
                                <div class="pull-right">
                                    <a class="btn btn-primary getHtmlForm fa fa-plus set_menu_name" data-href="<?php echo e(route('users.create')); ?>?type=<?php echo e(request()->path()); ?>" data-name="<?php echo e(__('administrator.create')); ?>"></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="top-content">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <form class="form_data">
                                <?php if(Auth::user()->user_type!=='member' && $ifMember): ?>
                                    <div class="col-sm-4 col-md-4">
                                        <div class="col-sm-4 col-md-4">
                                            <?php echo e(__('administrator.leader')); ?> :
                                        </div>
                                        <div class="form-group col-sm-8 col-md-8">
                                            <?php echo Form::select('leader_id',getUsers(null,''),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                        </div>
                                    </div>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="box-body table-responsive">
                    <table id="datatable" width="100%" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr>
                            <th>#</th>
                            <?php if($ifMember): ?>
                                <th><?php echo e(__('administrator.team_leader')); ?></th>
                            <?php endif; ?>
                            <th><?php echo e(__('administrator.name')); ?></th>
                            <?php if($ifMember): ?>
                                <th><?php echo e(__('administrator.member_type')); ?></th>
                            <?php endif; ?>
                            <th><?php echo e(__('administrator.gender')); ?></th>
                            <th><?php echo e(__('administrator.phone_number')); ?></th>
                            <?php if($ifMember): ?>
                                <th><?php echo e(__('administrator.id_card')); ?></th>
                                <th><?php echo e(__('administrator.province')); ?></th>
                            <?php endif; ?>
                            <th><?php echo e(__('administrator.username')); ?></th>
                            <th><?php echo e(__('administrator.status')); ?></th>
                            <th><?php echo e(__('administrator.action')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        let tb = $('#datatable');
        $(document).ready(function () {

            getTable()
            $('.form_data').on('change','select',function (){
                getTable()
            });
            tb.on('click', '.change_status', function () {
                var status = $(this).data('status') == 0 ? 1 : 0;
                var user_id = $(this).data('id');
                console.log(status);
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/user-status',
                    data: {'status': status, 'user_id': user_id},
                    success: function (data) {
                        window.location.reload();
                    }
                });
            })
        });

        function getTable() {
            let data = $('.form_data').serialize();
            tb.DataTable().destroy();
            tb.DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                lengthMenu: tbLength,
                ajax: {
                    url: "<?php echo e(route('member.index')); ?>?" + data,
                    data: {
                        type: '<?php echo e(request()->path()); ?>',
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                            <?php if($ifMember): ?>
                        {
                            data: 'leader_id'
                        },
                            <?php endif; ?>
                        {
                            data: 'name'
                        },
                            <?php if($ifMember): ?>
                        {
                            data: 'member_type_id'
                        },
                            <?php endif; ?>
                        {
                            data: 'gender'
                        },
                        {data: 'phone'},
                            <?php if($ifMember): ?>
                        {
                            data: 'id_card'
                        },
                        {data: 'province_id'},
                            <?php endif; ?>
                        {
                            data: 'username'
                        },
                        {data: 'status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                },
            });
        }
    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/users/index.blade.php ENDPATH**/ ?>