<?php if(Auth::user()->user_type==1 ): ?>
    <?php $app = 'layouts.app';
    ?>
<?php endif; ?>
<?php if(Auth::user()->user_type==1 && optional(Auth::user()->branch)->main != 1): ?>
    <?php $app = 'layouts.app-branch';
    ?>
<?php endif; ?>
<?php if(Auth::user()->user_type=='seller' || Auth::user()->user_type=='coporator'): ?>
    <?php $app = 'layouts.app-seller';
    ?>
<?php endif; ?>

<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php
        $type =  @$_GET['sale_type'];
        $customer =  @$_GET['customer'];
        $date =  @$_GET['date'];
        $status =  @$_GET['status'];
        $supplier =  @$_GET['supplier'];
         $ifPurchase = session()->get('payment_type_in_payment');
        $col = $ifPurchase?3:12;
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <div class="row">
                    <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                        <h3><?php echo e(__('administrator.'.($ifPurchase?'stock_in_payment':'sale_payment'))); ?></h3>
                    </div>
                </div>
                <div class="container-fluid" style="background: white; padding:10px">
                    <div class="row">
                        <?php echo Form::open(['route' => 'payment.index', 'method' => 'get','class'=>'form-payment']); ?>

                        <?php if($ifPurchase): ?>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.suppliers')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::select('supplier', getSupplier()->pluck('supplier_name','id') , $supplier , ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                    <?php echo Form::hidden('nbpo', 'tertfgd'); ?>

                                </div>
                            </div>
                        <?php else: ?>
                            <?php if(Auth::user()->user_type == 1): ?>
                                <div class="col-sm-3 col-md-3">
                                    <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                        <?php echo e(__('administrator.type')); ?>

                                    </div>
                                    <div class="form-group col-sm-9 col-md-9">
                                        <?php echo Form::select('sale_type', ['Pos'=>__('administrator.pos'),'wholesale'=>__('administrator.wholesale')] ,$type , ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.customer')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::select('customer', getCustomerByParent(Auth::user()->id)->pluck('customer_name','id') , $customer , ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-sm-3 col-md-3">
                            <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                <?php echo e(__('administrator.status')); ?>

                            </div>
                            <div class="form-group col-sm-9 col-md-9">
                                <?php echo Form::select('status', getPaymentStatus() , $status , ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                <?php echo e(__('administrator.date')); ?>

                            </div>
                            <div class="form-group col-sm-9 col-md-9">
                                <input type="text" class="form-control date_picker" name="date"
                                       value="<?php echo e($date?$date:''); ?>">
                            </div>
                        </div>
                        <div class="col-xs-<?php echo e($col); ?> col-sm-<?php echo e($col); ?> col-md-<?php echo e($col); ?> col-lg-<?php echo e($col); ?> form-group">
                            <div class="col-sm-12">
                                <button type="button"
                                        class="button_info pull-right submit_search"><?php echo e(__('administrator.search')); ?></button>
                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                    <div class="table-responsive">
                        <table id="customer" class="table table-hover" width="100%">
                            <thead>
                            <tr>
                                <th width="5%">#</th>
                                <?php if(!$ifPurchase): ?>
                                    <th><?php echo e(__('administrator.type')); ?></th>
                                <?php endif; ?>
                                <th><?php echo e(__('administrator.date')); ?></th>
                                <th><?php echo e(__('administrator.invoice')); ?></th>
                                <th><?php echo e(__('administrator.'.($ifPurchase?'user':'seller'))); ?></th>
                                <th><?php echo e(__('administrator.'.($ifPurchase?'suppliers':'customer'))); ?></th>
                                <th><?php echo e(__('administrator.contact')); ?></th>
                                <th><?php echo e(__('administrator.amount')); ?></th>
                                <th><?php echo e(__('administrator.refund')); ?></th>
                                <th><?php echo e(__('administrator.remain_amount')); ?></th>
                                <th><?php echo e(__('administrator.status')); ?></th>
                                <th width="10%"><?php echo e(__('administrator.action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            getTable();
            $('.submit_search').on('click',function () {
                getTable();
            });
            $(document).on('keyup', '.amount', function () {
                let remain = parseFloat($('.remain').data('pp').replace(/\,/g, ''));
                if (parseFloat($(this).val()) > remain) {
                    $(this).val(remain);
                }
            });
            $('#customer tbody').on('click', '.btn_add_payment', function () {
                $id = $(this).data('id');
                $url = '<?php echo e(route("get-payment",':id')); ?>';
                $url = $url.replace(':id', $id);
                $.confirm({
                    title: '<?php echo e(__('administrator.add_payment')); ?>',
                    columnClass: 'col-md-8 col-md-offset-2',
                    closeIcon: true,
                    content: function () {
                        let self = this;
                        return $.ajax({
                            url: $url,
                            dataType: 'html',
                            method: 'get',
                            data: {
                                "_token": "<?php echo e(csrf_token()); ?>",
                            },
                        }).done(function (response) {
                            self.setContent(response);
                        }).fail(function () {
                            $.alert('Something wrong !<br><b class="text-danger">Please Reload</b>');
                        });
                    },
                    buttons: {
                        cancel: {
                            text: '<?php echo e(__('administrator.cancel')); ?>',
                            btnClass: 'button_warning cancel_btn',
                            keys: ['escape'],
                        },
                        submit: {
                            text: '<?php echo e(__('administrator.submit')); ?>',
                            btnClass: 'btn bg-olive btn-flat margin submit_btn',
                            keys: ['enter'],
                            action: function () {
                                let self = this;
                                self.buttons.submit.disable();
                                let form = $('#form_submit').serialize();
                                $.ajax({
                                    url:'<?php echo e(route('add-payment')); ?>',
                                    dataType:'json',
                                    method:'post',
                                    data:form,
                                    success:function (data) {
                                        if(data.status === "alert"){
                                            $.alert({
                                                title:'Add payment successful',
                                                content:'',
                                                icon:'fa fa-check',
                                                theme:'modern',
                                                autoClose:'okreload|100',
                                                buttons:{
                                                    okreload:{
                                                        btnClass:'button_info',
                                                        text:'OK',
                                                        action:function () {
                                                            getTable();
                                                            $(document).find('.cancel_btn').trigger('click');
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    },
                                    error(xhr){
                                        alertErrorFormController(xhr,self);
                                    }
                                });
                                return false;
                            },
                        },
                    }
                });
            });
        });
        function getTable() {
            let supplier = $('.form-payment').find('select[name=supplier]').val();
            let status = $('.form-payment').find('select[name=status]').val();
            let date = $('.form-payment').find('select[name=date]').val();
            let nbpo = $('.form-payment').find('hidden[name=nbpo]').val();
            $('#customer').DataTable().destroy();
            $('#customer').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                    },
                },
                ordering: false,
                processing: false,
                serverSide: true,
                lengthMenu: tbLength,
                ajax: {
                    url: "<?php echo e(route('get-payments')); ?>",
                    data: {
                        supplier:supplier,
                        status:status,
                        date:date,
                        nbpo:nbpo,
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                            <?php if(!$ifPurchase): ?>
                        {
                            data: 'type'
                        },
                            <?php endif; ?>
                        {
                            data: 'payment_date'
                        },
                        {
                            data: 'invoice_number',
                            'name': '<?php echo e($ifPurchase?'nso007_purchases':'nso007_sales'); ?>.invoice_number'
                        },
                        {data: 'user_id', 'searchable': false},
                        {data: 'customer_name', 'searchable': false},
                        {data: 'customer_phone', 'searchable': false},
                        {data: 'payment_amount'},
                        {data: 'paid_amount'},
                        {data: 'remain', 'searchable': false},
                        {data: 'payment_status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                }

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($app, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/payment/index.blade.php ENDPATH**/ ?>