<?php Fun::lang() ?>
<style>
    .select2 {
        width: 100% !important;
    }

    .overflow-auto {
        overflow-y: scroll;
        height: 60vh;
        border: 1px solid rgba(1, 1, 1, 0.5);
    }

    .overflow-auto::-webkit-scrollbar {
        width: 3px;
    }

    .overflow-auto::-webkit-scrollbar-thumb {
        background: #666;
        border-radius: 3px;
    }
</style>
<?php
$if_approve = decrypt(request('if_approve'));
if (@$master) {
    if ($master->request_to_type === 'member') {
        $reqeust_to = findUser($master->request_to);
    } else {
        $reqeust_to = findBranch($master->request_to);
    }
} else {
    $reqeust_to = myParent();
}

if (@$master) {
    $request_by = findUser($master->member_id);
} else {
    $request_by = auth()->user();
}
$poreq = request('poreq') ? decrypt(request('poreq')) : '';
?>
<div class="col-sm-12 col-md-12 ">
    <div class="row">
        <div class="col-sm-7 col-md-7">
            <div class="col-sm-12 col-md-12 ">
                <h3><?php echo e(__('administrator.request_stock')); ?></h3>
                <div class="overflow-auto">
                    <table class="table table-hover text-center">
                        <thead class="">
                        <tr>
                            <th>#</th>
                            <th width="25%" class="required"><?php echo e(__('administrator.item_name')); ?></th>
                            <th class="required"><?php echo e(__('administrator.qty')); ?></th>
                            <th class="required"><?php echo e(__('administrator.shelf')); ?></th>
                            <th style="padding: 5px">
                                    <button type="button" class="btn btn-default btn-sm" onclick="add_request()"><i class="fa fa-plus"></i></button>
                            </th>
                        </tr>
                        </thead>
                        <tbody id="request_stock">
                        <?php if(@$master): ?>
                            <?php $__currentLoopData = $master->detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $product_unit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                                ?>
                                <?php if($product_unit): ?>
                                    <?php
                                    $member_shelf = \App\Model\product\ShelfModel::where('member_id', $request_by->id)->first()->id ?? 0;
                                    $product = getProductById($product_unit->product_id);
                                    $select_item = [$product_unit->id => ($product->product_name . ' | ' . $product_unit->item_code)];
                                    $shelf = \App\Model\StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                                        ->join('nso007_shelf', 'nso007_shelf.id', 'nso007_stocks.shelf')
                                        ->join('nso007_unit', 'nso007_unit.id', 'nso007_product_unit.unit_id')
                                        ->selectRaw('CONCAT(nso007_shelf.name," | ",round(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit),nso007_unit.unit) as name,nso007_shelf.id,(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit) as stock')
                                        ->where(['nso007_stocks.product_unit_id' => $product_unit->id, 'nso007_stocks.shelf' => $member_shelf])
                                        ->pluck('name', 'id');
                                    ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td>
                                            <?php if($if_approve): ?>
                                                <span><?php echo e($select_item[$product_unit->id]); ?></span>
                                                <?php echo Form::hidden('product_unit_id[]',$product_unit->id);; ?>

                                                <?php echo Form::hidden('detail_id[]',$row->id);; ?>

                                            <?php else: ?>
                                                <?php echo Form::select('product_unit_id[]',$select_item,$product_unit->id, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_product']); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo Form::number('qty[]',$row->qty, ['placeholder'=>__('administrator.qty'),'class' => 'form-control']); ?>

                                        </td>
                                        <td>
                                            <?php echo Form::select('shelf[]',$shelf,$member_shelf, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                        </td>

                                        <td style="vertical-align: middle">
                                            <button type="button" class="btn btn-danger btn-sm btn_remove"><i class="fa fa-times"></i></button>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>


                        
                        <?php if(@$purchase_detail): ?>
                            <?php $__currentLoopData = $purchase_detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $product_unit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                                ?>
                                <?php if($product_unit): ?>
                                    <?php
                                    $member_shelf = \App\Model\product\ShelfModel::where('member_id', $request_by->id)->first()->id ?? 0;
                                    $product = getProductById($product_unit->product_id);
                                    $select_item = [$product_unit->id => ($product->product_name . ' | ' . $product_unit->item_code)];
                                    $shelf = \App\Model\StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                                        ->join('nso007_shelf', 'nso007_shelf.id', 'nso007_stocks.shelf')
                                        ->join('nso007_unit', 'nso007_unit.id', 'nso007_product_unit.unit_id')
                                        ->selectRaw('CONCAT(nso007_shelf.name," | ",round(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit),nso007_unit.unit) as name,nso007_shelf.id,(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit) as stock')
                                        ->where(['nso007_stocks.product_unit_id' => $product_unit->id, 'nso007_stocks.shelf' => $member_shelf])
                                        ->pluck('name', 'id');
                                    ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td>
                                            <span><?php echo e($select_item[$product_unit->id]); ?></span>
                                            <?php echo Form::hidden('product_unit_id[]',$product_unit->id);; ?>

                                            <?php echo Form::hidden('detail_id[]',0);; ?>

                                            <?php echo Form::hidden('cost[]',$row->cost);; ?>

                                        </td>
                                        <td>
                                            <?php echo Form::number('qty[]',$row->qty, ['placeholder'=>__('administrator.qty'),'class' => 'form-control']); ?>

                                        </td>
                                        <td>
                                            <?php echo Form::select('shelf[]',$shelf,$member_shelf, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger btn-sm btn_remove"><i class="fa fa-times"></i></button>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-sm-5 col-md-5 ">
            <h3>&nbsp;</h3>
            <div class="col-sm-12 col-md-6 col-lg-6 form-group">
                <label><?php echo e(__('administrator.request_by')); ?> :</label>
                <?php echo Form::text('user',$request_by->name??'',array('class'=>' form-control ','readonly')); ?>

                <?php echo Form::hidden('poreq',$poreq); ?>

            </div>
            <div class="col-sm-12 col-md-6 col-lg-6 form-group">
                <label><?php echo e(__('administrator.request_to')); ?> :</label>
                <?php echo Form::text('request_to',$reqeust_to->name??'',array('class'=>' form-control ','readonly')); ?>

            </div>
            <div class="col-sm-12 form-group">
                <label><?php echo e(__('administrator.date')); ?> :</label>
                <?php echo Form::text('request_date',@$master?date('d-m-Y',strtotime($master->request_date)):date('d-m-Y'),array('placeholder'=>__('administrator.date'),'class'=>' form-control '.($if_approve?'':'date_picker'),$if_approve?'readonly':'')); ?>

            </div>
            <div class="col-sm-12 "></div>
            <div class="col-sm-12 form-group">
                <label><?php echo e(__('administrator.note')); ?></label>
                <?php echo Form::textarea('note', null, ['placeholder'=>__('administrator.note'),'class' => 'form-control form-control no-resize','maxlength'=>'20','rows'=>'3',$if_approve?'readonly':'']); ?>

            </div>
            <div class="col-sm-12">
                <div>
                    <button type="submit" class="btn btn-<?php echo e($if_approve?'success':'primary'); ?> pull-right">
                        <?php echo e(__('administrator.'.($if_approve?'approve':'submit'))); ?>

                    </button>
                    <button type="button"
                            class="btn btn-warning"
                            onclick="
                            <?php if($if_approve): ?>
                                window.location.replace('<?php echo e(route('request-stock.index').'?type=from'); ?>');
                            <?php else: ?>
                                history.back(1)
                            <?php endif; ?>"><?php echo e(__('administrator.back')); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            <?php if(!@$master&&!@$purchase_detail->count()): ?>
            add_request();
            <?php endif; ?>
            $('#request_stock').on('click', '.btn_remove', function () {
                $(this).closest('tr').remove();
            });
            $('#request_stock').on('change', '.search_product', function () {
                let row = $(this).closest('tr');
                $.get('<?php echo e(route('request-stock.create')); ?>', {product_unit_id: $(this).val()}, function (res) {
                    let select = row.find('select[name="shelf[]"]');
                    let qty = row.find('input[name="qty[]"]');
                    let shelf = res.shelf;
                    if (shelf) {
                        select.html(`<option value="${shelf.id}">${shelf.name}</option>`);
                        qty.attr('max', shelf.stock_qty);
                    } else {
                        select.html('');
                        qty.attr('max', 0);
                    }
                });
            });
            $(document).on('keyup', '.request_qty', function () {
                let this_ = $(this);
                let qty = this_.closest('tr').find('.request_qty').val();
                let stock = this_.closest('tr').find('.stock_balance').val();
                stock = parseFloat(stock);
                qty = parseFloat(qty);
                if (stock < qty) {
                    this_.closest('tr').find('.request_qty').val(stock);
                }
            });
            setMenuName('Request Stock');
        });

        function add_request() {
            let count = $('#request_stock tr').length;
            let html = `<tr>
                <td>${count + 1}</td>
                <td>
                <?php echo Form::select('product_unit_id[]',[],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_product']); ?>

            </td>
            <td>
<?php echo Form::number('qty[]',1, ['placeholder'=>__('administrator.qty'),'class' => 'form-control']); ?>

            </td>
             <td>
<?php echo Form::select('shelf[]',[],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

            </td>
            <td style="vertical-align: middle"><button type="button" class="btn btn-danger btn-sm btn_remove" ><i class="fa fa-times"></i></button></td>
            </tr>`;
            $('#request_stock').append(html).find('tr:last .select2').select2();
            search_product();
        }

    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/branch/item-request/form.blade.php ENDPATH**/ ?>