<table id="data_table" class="table table-striped table-hover table-bordered">
    <thead>
    <tr>
        <th>N°</th>
        <th width="15%"><?php echo e(__('administrator.invoice_number')); ?></th>
        <th width="15%"><?php echo e(__('administrator.sale_date')); ?></th>
        <th><?php echo e(__('administrator.sale_by')); ?></th>
        <th><?php echo e(__('administrator.total')); ?></th>
        <th><?php echo e(__('administrator.paid')); ?></th>
        <th><?php echo e(__('administrator.remain_amount')); ?></th>
        <th><?php echo e(__('administrator.payment_methods')); ?></th>
        <th><?php echo e(__('administrator.payment_status')); ?></th>
        <th><?php echo e(__('administrator.store_qty')); ?></th>
        <th><?php echo e(__('administrator.deliver_qty')); ?></th>
        <th><?php echo e(__('administrator.total_qty')); ?></th>
    </tr>
    </thead>
    <tbody class="tbody">

    </tbody>
</table>

<script type="text/javascript">
    //  start datatable
    $(document).ready(function () {
        getTable();
        $('.hide_wholesale').hide();
    });

    function getTable() {
        let is_branch = "<?php echo e(auth()->user()->is_role); ?>";
        let column = [
            {data: 'DT_RowIndex'},
            {data: 'reference_number'},
            {data: 'sale_date'},
            {data: 'seller'},
            {data: 'payment_amount'},
            {data: 'paid_amount'},
            {data: 'remain'},
            {data: 'payment_method'},
            {data: 'payment_status'},
            {data: 'total_store_qty'},
            {data: 'total_deliver_qty'},
            {data: 'total_qty'},
        ];

        if (is_branch === 'Seller') {
            column.splice(1, 1);
        }
        $('#data_table').DataTable().destroy();
        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                "oPaginate": {
                    "sFirst": "<?php echo e(__('administrator.first')); ?>",
                    "sLast": "<?php echo e(__('administrator.last')); ?>",
                    "sNext": "<?php echo e(__('administrator.next')); ?>",
                    "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                },
            },
            dom: 'lBfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    autoFilter: true,
                    className: 'btn btn-info pull-right',
                    filename: menu_name,
                    title: menu_name,
                    sheetName: menu_name,
                    footer:true,
                    header: true,
                    text: 'Save as Excel',
                },
            ],
            serverSide: true,
            ordering: false,
            searching: false,
            ajax: {
                url: "<?php echo e(route('report-wholesale')); ?>"+ '?' + $('.form_data').serialize(),
                data: {
                    isAjax:1,
                }
            },
            columns: column,

            "initComplete": function (settings, json) {

            }
        });
    }
</script>



<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/report-sales/wholesale.blade.php ENDPATH**/ ?>