<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3><?php echo e(__('administrator.reason')); ?></h3>
                                </div>
                                <div class="pull-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Reason Create')): ?>
                                            <a class="btn btn-sm btn-primary button_primary create_reason"><span class="fa fa-plus"></span> <?php echo e(__('administrator.new_record')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-body">
                    <form class="form_data">
                        <table id="data_table" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr>
                                <th>N°</th>
                                <th><?php echo e(__('administrator.reason')); ?></th>
                                <th><?php echo e(__('administrator.action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reason; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td><?php echo e($row->reason); ?></td>
                                        <td>
                                            <button data-href="<?php echo e(route('reason.edit',$row->id)); ?>" type="button" class="btn btn-warning fa fa-edit btn_edit"></button>
                                            <button type="button" class="btn btn-danger fa fa-trash btn_delete" data-href ="<?php echo e(route('reason-delete',$row->id)); ?>"></button></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#data_table').dataTable();
        });

        $(document).on('click', '.create_reason', function () {
            getHtmlForm('<?php echo e(route('reason.create')); ?>', '<?php echo e(__('administrator.create')); ?> <?php echo e(__('administrator.reason')); ?>');
        });
        $(document).on('click', '.btn_edit', function () {
            $href = $(this).data('href');
            getHtmlForm($href, '<?php echo e(__('administrator.edit')); ?> <?php echo e(__('administrator.reason')); ?>');
        });
        $(document).on('click', '.btn_delete', function () {
            $href = $(this).data('href');
            let text = $(this).closest('tr').find('td:nth-child(2)').text();
            confirmForm($href,  '<?php echo e(__('administrator.are_you_sure')); ?>',  'Name: '+text,  'danger', '400px', 'fa fa-trash', 'red')
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/setup/reason/index.blade.php ENDPATH**/ ?>