<?php $__env->startSection('content'); ?>
    <?php Fun::lang() ?>
    <style>
        .select2 {
            width: 100% !important;
        }
        .overflow-auto{
            overflow-y: scroll;
            height: 30vh;
            border: 1px solid rgba(1,1,1,0.5);
        }
        .overflow-auto::-webkit-scrollbar {
            width: 3px;
        }
        .overflow-auto::-webkit-scrollbar-thumb {
            background: #666;
            border-radius: 3px;
        }
    </style>
    <div class="page-purchases">
        <div class="preview">
            <?php echo Form::open(array('route' => 'product-return.store','method'=>'POST','enctype'=>'multipart/form-data','id'=>'submit_post','class'=>'jform')); ?>

            <div class="col-sm-12 col-md-12">
                <div class="row">
                    <div class="col-sm-8 col-md-8">
                        <div class="col-sm-12 col-md-12 ">
                            <h3><?php echo e(__('administrator.return_item')); ?></h3>
                            <div class="overflow-auto">
                                <table class="table table-hover text-center">
                                    <thead class="">
                                    <tr>
                                        <th>#</th>
                                        <th class="required"><?php echo e(__('administrator.item_name')); ?></th>
                                        <th class="required"><?php echo e(__('administrator.qty')); ?></th>
                                        <th class="required"><?php echo e(__('administrator.return_item_price')); ?></th>
                                        <th><?php echo e(__('administrator.total')); ?></th>
                                        <th style="padding: 5px">
                                            <button type="button" class="btn btn-default btn_add_return btn-sm"><i class="fa fa-plus"></i></button>
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody id="return_item">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12">
                            <h3><?php echo e(__('administrator.change_item')); ?></h3>
                            <div class="overflow-auto">
                                <table class="table table-hover text-center">
                                    <thead class="">
                                    <tr>
                                        <th>#</th>
                                        <th class="required"><?php echo e(__('administrator.item_name')); ?></th>
                                        <th class="required"><?php echo e(__('administrator.stock_balance')); ?></th>
                                        <th class="required"><?php echo e(__('administrator.qty')); ?></th>
                                        <th class="required"><?php echo e(__('administrator.price')); ?></th>
                                        <th><?php echo e(__('administrator.total')); ?> </th>
                                        <th style="padding: 5px">
                                            <button type="button" class="btn btn-default btn_add_change btn-sm"><i class="fa fa-plus"></i></button>
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody id="change_item"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4 col-md-4 ">
                        <h3>&nbsp;</h3>
                        <div class="col-sm-6 form-group">
                            <label class="required"><?php echo e(__('administrator.reference_number')); ?> :</label>
                            <?php echo Form::text('reference_number',null,array('placeholder'=>__('administrator.reference_number'),'class'=>'form-control','required')); ?>

                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="required"><?php echo e(__('administrator.date')); ?> :</label>
                            <?php echo Form::text('date',date('d-m-Y'),array('placeholder'=>__('administrator.date'),'class'=>'date_picker form-control','required')); ?>

                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="required"><?php echo e(__('administrator.customer')); ?> :</label>
                            <?php echo Form::select('customer', [], null, ['class' => 'form-control search_customer','placeholder'=>__('administrator.please_select'),'required']); ?>

                        </div>

                        <div class="col-sm-6 form-group">
                            <label><?php echo e(__('administrator.reference')); ?> :</label>
                            <input type="file" name="reference">
                        </div>

                        <div class="col-sm-12 "></div>
                        <div class="col-sm-6 form-group">
                            <label><?php echo e(__('administrator.total')); ?> ( ៛ ) :</label>
                            <?php echo Form::text('sub_total_kh',0,array('placeholder'=>__('administrator.sub_total'),'class'=>'form-control number-only','readonly')); ?>

                        </div>
                        <div class="col-sm-6 form-group">
                            <label><?php echo e(__('administrator.total')); ?> ( $ ) :</label>
                            <?php echo Form::text('sub_total_en',0,array('placeholder'=>__('administrator.sub_total'),'class'=>'form-control number-only','readonly')); ?>

                        </div>
                        <div class="col-sm-12 form-group">
                            <label><?php echo e(__('administrator.paid')); ?> ( $ ) :</label>
                            <?php echo Form::text('paid',0,array('placeholder'=>__('administrator.paid'),'class'=>'form-control number-only')); ?>

                        </div>
                        <div class="col-sm-12 form-group">
                            <label><?php echo e(__('administrator.note')); ?></label>
                            <?php echo Form::textarea('note', null, ['placeholder'=>__('administrator.note'),'class' => 'form-control form-control no-resize','maxlength'=>'20','rows'=>'3']); ?>

                        </div>
                        <div class="col-sm-12 text-right">
                           <?php echo $__env->make('component.form-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            add_return();
            add_change_item();
            $(document).on('change', 'select[name=payment_method]', function () {
                $.getJSON ('<?php echo e(route('get-account-code',0)); ?>',{account_code:$(this).val()},function (data) {
                    let html = `<option value=""><?php echo e(__('administrator.please_select')); ?></option>`;
                    $.each(data.acc_chart,function (ii,vv) {
                        html += `<option value="${vv.id}">${vv.acc_name}</option>`;
                    });
                    $('select[name=payment_type]').html(html);
                });
            });
            $('body').addClass('sidebar-collapse');
            $(document).on('click', '.btn_remove', function () {
                $(this).closest('tr').remove();
            });
            $(document).on('keyup', '.item_qty,.item_price', function () {
                generate_total();
            });
            $(document).on('click', '.btn_add_return', function () {
                add_return();
            });
            $(document).on('click', '.btn_add_change', function () {
                add_change_item();
            });
            $(document).on('change', '.search_product', function () {
                let this_=$(this);
                $.get('<?php echo e(route('product-return.create')); ?>',{product_unit_id:this_.val()},function (res){
                    let row = this_.closest('tr');
                    row.find('.item_price').val(res.price);
                    row.find('.stock_balance').val(res.stock);
                    generate_total();
                });
            });
        });
        function clear_row(this_){
            let row =  this_.closest('tr');
            row.find('.stock_balance').val(0);
            row.find('.item_qty').val(1);
            row.find('.item_price').val(0);
            row.find('.total_price').val(0);
        }

        function add_return() {

            let key = $('#return_item tr').length;
            let html = ` <tr>
               <td>${key+1}</td>
               <td>
                   <?php echo Form::select('r_product[]', [], null, ['class' => 'form-control search_product','placeholder'=>__('administrator.please_select'),'required']); ?>

                </td>
                 <td>
                    <?php echo Form::text('r_qty[]', 1, ['class' => 'form-control number-only item_qty','placeholder'=>__('administrator.qty'),'required']); ?>

                </td>
                <td>
                    <?php echo Form::number('r_price[]', null, ['class' => 'form-control item_price','placeholder'=>__('administrator.return_item_price'),'required','step'=>"any"]); ?>

                </td>
                <td>
                    <?php echo Form::text('r_total[]', null, ['class' => 'form-control number-only total_price','placeholder'=>__('administrator.total'),'required','readonly']); ?>

                </td>
                <td><button class="btn btn-danger btn_remove" type="button"><i class="fa fa-times "></i></button></td>
            </tr>`;
            $('#return_item').append(html);
            search_product();
            date_picker();
        }

        function add_change_item() {
            let key = $('#change_item tr').length;
            let html = ` <tr>
               <td>${key+1}</td>
               <td>
                   <?php echo Form::select('c_product[]', [], null, ['class' => 'form-control search_product','placeholder'=>__('administrator.please_select'),'required']); ?>

                </td>
                 <td>
                    <?php echo Form::text('c_stock[]',0, ['class' => 'form-control stock_balance','placeholder'=>__('administrator.stock_balance'),'readonly']); ?>

                </td>
                <td>
                    <?php echo Form::text('c_qty[]', 1, ['class' => 'form-control number-only item_qty','placeholder'=>__('administrator.qty'),'required']); ?>

                </td>
                <td>
                    <?php echo Form::number('c_price[]', null, ['class' => 'form-control item_price','placeholder'=>__('administrator.price'),'required','step'=>"any"]); ?>

                </td>
                <td>
                    <?php echo Form::text('c_total[]', null, ['class' => 'form-control total_price','placeholder'=>__('administrator.total'),'required','readonly']); ?>

                </td>
                <td><button class="btn btn-danger btn_remove" type="button"><i class="fa fa-times "></i></button></td>
            </tr>`;
            $('#change_item').append(html);
            search_product();
        }

        function generate_total() {
            let item_qty = $('.item_qty');
            let total_return = 0;
            let total_change = 0;
            $.each(item_qty,function (ii,vv) {
                let qty = $(this).val();
                let price = $(this).closest('tr').find('.item_price').val();
                let tabble = $(this).closest('tbody').attr('id');
                qty = qty?parseFloat(qty):0;
                price = price?parseFloat(price):0;
                let total= price*qty;
                if(tabble==='return_item'){
                    total_return+=total;
                }else{
                    total_change+=total;
                }
                $(this).closest('tr').find('.total_price').val(total);
            });
            let subtotal = total_change-total_return;
            subtotal = subtotal>0?subtotal:0;
            let rate = '<?php echo e(currencyExchange()); ?>';
            rate = parseFloat(rate);
            let subtotal_kh = subtotal*rate;
            $('input[name=sub_total_kh]').val((subtotal_kh).toFixed(2));
            $('input[name=sub_total_en]').val(subtotal);

        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/product-return/create.blade.php ENDPATH**/ ?>