<?php
$hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
$seller = findUser($master->user_id)->name ?? '';
$sub_total = 0;

if ($master->request_to_type === 'member') {
    $request_to = findUser($master->request_to)->name ?? '';
} else {
    $request_to = findBranch($master->request_to)->name ?? '';
}
?>
<div class="print_this_form">
    <table style="width: 100%">
        <tr>
            <td style="text-align: center"><img style="width: 150px" src="<?php echo e(findImg(mainBranch()->logo)); ?>"></td>
        </tr>
        <tr>
            <td style="text-align: center;">
                 <span>
                     <b class="name_logo">សំណើរស្នើសុំស្តុក / Purchase Order</b><br>
                </span>
            </td>
        </tr>
    </table>

    <hr width="40%">
    <table>
        <tr style="text-align: left;">
            <td style="width: 70%;">
                <table>
                    <tr class="font_12">
                        <td><?php echo e(__('administrator.date')); ?> </td>
                        <td>:
                            <b><?php echo e(myDate($master->purchase_date)); ?></b>
                        </td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20"><?php echo e(__('administrator.reference_number')); ?></td>
                        <td>: <?php echo e($master->invoice_number); ?></td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20"><?php echo e(__('administrator.request_by')); ?></td>
                        <td>: <?php echo e($seller); ?></td>
                    </tr>
                    <?php if($request_to): ?>
                        <tr class="font_12">
                            <td class="width-20"><?php echo e(__('administrator.request_to')); ?></td>
                            <td>: <?php echo e($request_to); ?></td>
                        </tr>
                    <?php endif; ?>
                </table>
            </td>
            <?php if($master->payment_method): ?>
                <td>
                    <table>
                        <tr class="font_12">
                            <td><?php echo e(__('administrator.payment_method')); ?></td>
                            <td> :
                                <?php echo e(\App\Model\Accounting\AccountChartModel::find($master->payment_method)->acc_namekh); ?>

                            </td>
                        </tr>
                    </table>
                </td>
            <?php endif; ?>
        </tr>
    </table>
    <table class="table m-top-30 " style="border-top: 1px solid #ddd;margin-top: 15px">
        <thead>
        <tr>
            <th class="text-left">#</th>
            <th class="text-left">ឈ្មោះ</th>
            <th class="text-left">តម្លៃ</th>
            <th class="text-left">បរិមាណ</th>
            <?php if($master->request_to): ?>
                <th>ចំនួនទទួល</th>
                <th>ចំនួនផ្ញើរ</th>
            <?php endif; ?>
            <th>តម្លៃសរុប</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $master->detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $product_unit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = null;
                if($product_unit){
                     $product = getProductById($product_unit->product_id);
                      $product = $product?$product->product_name:'';
                }
                $total = $row->qty*$row->cost;
                $sub_total+=$total;
                $unit = $product_unit->unit->unit??'';
            ?>
            <tr>
                <td><?php echo e($key+1); ?></td>
                <td><?php echo e($product); ?> | <?php echo e($product_unit->item_code); ?></td>
                <td><?php echo e($row->cost); ?>$</td>
                <td><?php echo e($row->qty.' '.$unit); ?></td>
                <?php if($master->request_to): ?>
                    <td><?php echo e($row->deliver_qty.' '.$unit); ?></td>
                    <td><?php echo e(($row->store_qty?:0).' '.$unit); ?></td>
                <?php endif; ?>
                <td>$<?php echo e($total); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php
            $total_row = 10;
            $total_data = $master->detail->count();
            $left_row = $total_row-$total_data;
        ?>
        <?php if($total_row>$total_data): ?>
            <?php for($i=0;$i<$left_row; $i++): ?>
                <tr>
                    <td><?php echo e($key += 1); ?></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <?php if($master->request_to): ?>
                        <td></td>
                        <td></td>
                    <?php endif; ?>
                </tr>
            <?php endfor; ?>
        <?php endif; ?>
        </tbody>
        <?php
        $g_total = $master->grand_total;
        $col = 3;
        $grand_total = $master->grand_total;
        $g_kh = currencyExchange() * $grand_total;
        $paid = ($master->paid_kh / currencyExchange()) + ($master->paid_usd);
        $owe = $grand_total - $paid;
        $change = $paid - $grand_total;
        if ($master->request_to) {
            $col += 2;
        }
        ?>
        <tfoot>
        <tr class="">
            <td colspan="<?php echo e($col); ?>" rowspan="5" class="text-left" style="position: relative;border:none!important;">

                <?php if($master->delivery_to_member): ?>
                    <h4 class="text-left"><u><?php echo e(__('administrator.delivery_info')); ?></u></h4>
                    <table class="no-border" style="margin-top: 10px">
                        <?php
                            $member = findUser($master->delivery_to_member);
                            $province = findProvince($member->province_id)->name_kh??'';
                            $district = findDistrict($member->district_id)->name_kh??'';
                            $commune = findCommune($member->commune_id)->name_kh??'';
                            $village = findCommune($member->village_id)->name_kh??'';
                            $address = $province.' '.$district.' '.$commune.' '.$village.' , '.$member->street.' , '.$member->house;
                        ?>

                        <?php if($member): ?>
                            <tr>
                                <td>
                                    <?php echo e(__('administrator.receiver_name')); ?>

                                </td>
                                <td class="text-left">: <?php echo e($member->name); ?></td>
                            </tr>
                            <?php if($member->phone): ?>
                                <tr>
                                    <td><?php echo e(__('administrator.phone')); ?></td>
                                    <td class="text-left">: <?php echo e($member->phone); ?><br></td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <td><?php echo e(__('administrator.address')); ?></td>
                                <td class="text-left">: <?php echo e($address); ?><br></td>
                            </tr>
                        <?php endif; ?>
                        <?php if($master->description): ?>
                            <tr>
                                <td class="text-left" width="20%"><?php echo e(__('administrator.description')); ?></td>
                                <td class="text-left">: <?php echo e($master->description); ?></td>
                            </tr>
                        <?php endif; ?>
                    </table>
                <?php endif; ?>

            </td>
            <?php if($master->discount): ?>
                <td><?php echo e(__('administrator.subtotal')); ?></td>
                <td class="text-left " style="position: relative;"><?php echo e(number_format($sub_total,2)); ?>$</td>
            <?php endif; ?>
        </tr>
        <?php if($master->discount): ?>
            <tr>
                <td>
                    <?php echo e(__('administrator.discount')); ?>

                </td>
                <td class="text-left"><?php echo e($master->discount); ?>%
                    ($<?php echo e(($sub_total * $master->discount) / 100); ?>)
                </td>
            </tr>
        <?php endif; ?>
        <tr>
            <td>
                <?php echo e(__('administrator.grand_total')); ?></td>
            <td class="text-left">$<?php echo e(number_format(($g_total),2)); ?></td>
        </tr>
        <?php if($master->paid_usd): ?>
            <tr>
                <td><?php echo e(__('administrator.paid')); ?></td>
                <td class="text-left">$<?php echo e(number_format(($master->paid_usd),2)); ?></td>
            </tr>
        <?php endif; ?>
        <?php if($master->paid_usd<$g_total): ?>
            <tr>
                <td><?php echo e(__('administrator.owed')); ?></td>
                <td class="text-left">$<?php echo e(number_format(($g_total-$master->paid_usd),2)); ?></td>
            </tr>
        <?php endif; ?>
        </tfoot>
    </table>
    
    
    
    
    
    
</div>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/stock-inventory/purchases/item/show.blade.php ENDPATH**/ ?>