<!doctype html>
<?php Fun::lang()?>
<html>
<head>
    <meta charset="utf-8">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/pos-invoice.css')); ?>">
    <?php
    $hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
    ?>
</head>
<body>
<div class="invoice-box">
    <table class="tb-header">
        <tr>
            <td><img src="<?php echo e(nsoLogo()); ?>" style="height: 50px;margin: 5px"></td>
        </tr>
        <tr>
            <td>
                <span>
                     <b class="name_logo"><?php echo e(getBranch()->name); ?></b><br>
                    <i style="font-size: 11px"><?php echo e(getBranch()->address); ?><br><?php echo e(getBranch()->phone); ?></i>
                </span>
            </td>
        </tr>
    </table>
    <?php echo $hr; ?>

    <table class="tb-inv-info text-left fl-left" style="font-style: italic">
        <tr>
            <td><?php echo e(__('administrator.invoice')); ?></td>
            <td>&nbsp;:&nbsp;<?php echo e($master->invoice_number); ?></td>
        </tr>
        <tr>
            <td><?php echo e(__('administrator.date')); ?></td>
            <td>&nbsp;:&nbsp; <b
                        style="font-size: 12px"><?php echo e(date('d-m-Y H:i:s',strtotime($master->created_at))); ?> <?php echo e($master->daily_order_number?'('.$master->daily_order_number.')':''); ?></b>
            </td>
        </tr>
        <?php if($master->customer_id): ?>
            <tr>
                <td>
                    <?php echo e(__('administrator.customer')); ?>

                </td>
                <td style="">
                    &nbsp;:&nbsp;<?php echo e(findCustomer($master->customer_id)->customer_name); ?>

                </td>
            </tr>
        <?php endif; ?>
        <?php if($master->user_id): ?>
            <tr>
                <td><?php echo e(__('administrator.cashier')); ?></td>
                <td>&nbsp;:&nbsp;<?php echo e(findUser($master->user_id)->name); ?></td>
            </tr>
        <?php endif; ?>
    </table>
    <?php echo $hr; ?>

    <?php
        $hide=0;
            foreach($detail as $key => $row){
                if($row->dis==0){
                    $hide ++;
                }
            }
    ?>
    <table class="tb-list-item small-font">
        <thead>
        <tr>
            <th><?php echo e(__('administrator.products')); ?></th>
            <th><?php echo e(__('administrator.price')); ?></th>
            <th class="<?php echo e($hide>0?'display-none':''); ?>"><?php echo e(__('administrator.discount')); ?></th>
            <th><?php echo e(__('administrator.total')); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php $total_qty = 0; ?>
        <?php $__currentLoopData = $detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $total_qty+=$row->qty; ?>
            <tr>
                <td><?php echo e(getProductById($row->product_id)->product_name); ?> ( <?php echo e(findSize($row->size_id)->size); ?> )</td>
                <td><?php echo e($row->qty.findUnit($row->unit_id)->unit); ?>

                    <small> x&nbsp;</small><?php echo e(user_currency()->symbol.number_format(convert_sale_detail_to_user_currency($row),2)); ?></td>
                <td class="<?php echo e($hide>0?'display-none':''); ?>"><?php echo e($row->dis); ?>%</td>
                <td><?php echo e(user_currency()->symbol.number_format(generateTotal($row),2)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php echo $hr; ?>

    <?php
    $sub_total = generateSubTotal($master);
    $g_total = 0;
    if ($master->delivery_fee || $master->discount) {
        $g_total = generateGrandTotal($master);
    }
    ?>
    <table class="tb-list-foot">
        <tr>
            <td colspan="3"><?php echo e(__('administrator.total_item')); ?></td>
            <td class="text-left"><?php echo e($total_qty); ?></td>
        </tr>
        <tr>
            <td colspan="3"><?php echo e(__('administrator.total')); ?></td>
            <td class="text-left"><?php echo e(user_currency()->symbol); ?><?php echo e(number_format(($sub_total),2)); ?></td>
        </tr>
        <?php if($master->discount): ?>
            <tr>
                <td colspan="3"><?php echo e(__('administrator.discount')); ?></td>
                <td class="text-left"><?php echo e($master->discount); ?>%
                    (<?php echo e(user_currency()->symbol); ?><?php echo e(($sub_total * $master->discount) / 100); ?>)
                </td>
            </tr>
        <?php endif; ?>
        <?php $fee = 0; ?>
        <?php if($master->delivery_fee>0): ?>
            <?php
                $fee = covert_delivery_fee($master);
            ?>
            <tr>
                <td colspan="3"><?php echo e(__('administrator.delivery_fee')); ?></td>
                <td class="text-left"><?php echo e(user_currency()->symbol); ?><?php echo e($fee); ?></td>
            </tr>
        <?php endif; ?>
        <?php if($master->delivery_fee || $master->discount): ?>
            <tr>
                <td colspan="3"><?php echo e(__('administrator.grand_total')); ?></td>
                <td class="text-left"><?php echo e(user_currency()->symbol); ?><?php echo e(number_format(($g_total+$fee),2)); ?></td>
            </tr>
        <?php endif; ?>
    </table>
    <?php echo $hr; ?>

    <?php if($master->delivery_status): ?>
        <h4 class="text-left"><u><?php echo e(__('administrator.delivery_info')); ?></u></h4>
    <?php endif; ?>
    <table class="text-left " style="font-size: 12px;margin-top: 10px">
        <?php if($master->delivery_status): ?>
            <?php if($master->customer_id): ?>
                <?php $customer = findCustomer($master->customer_id); ?>
                <tr>
                    <td width="32%">
                        <?php echo e(__('administrator.customer_name')); ?>

                    </td>
                    <td style="">: <?php echo e($customer->customer_name); ?></td>
                </tr>
                <?php if($customer->customer_phone): ?>
                    <tr>
                        <td><?php echo e(__('administrator.customer_phone')); ?></td>
                        <td>: <?php echo e($customer->customer_phone); ?><br></td>
                    </tr>
                <?php endif; ?>
            <?php endif; ?>
            <?php if($master->driver_id): ?>
                <?php $driver = findDriver($master->driver_id); ?>
                <tr>
                    <td><?php echo e(__('administrator.driver_name')); ?></td>
                    <td>: <?php echo e($driver->name); ?></td>
                </tr>
                <?php if($driver->phone): ?>
                    <tr>
                        <td><?php echo e(__('administrator.driver_number')); ?></td>
                        <td>: <?php echo e($driver->phone); ?></td>
                    </tr>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
        <?php if($master->note): ?>
            <tr>
                <td class="text-left" width="32%"><?php echo e(__('administrator.note')); ?></td>
                <td>: <?php echo e($master->note); ?></td>
            </tr>
        <?php endif; ?>
    </table>
    <?php if($master->delivery_status || $master->note): ?>
        <?php echo $hr; ?>

    <?php endif; ?>
    <table>
        <tr>
            <td class="small-font"><b><?php echo e(getBranch()->invoice_footer); ?></b></td>
        </tr>
    </table>
</div>
<script>

</script>
</body>
</html>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/invoice/pos-invoice.blade.php ENDPATH**/ ?>