@extends(branchMenu())

@section('content')

<?php Fun::lang()?>

<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3 class="set_menu_name"></h3>
                        </div>
                        <div class="pull-right">
                            @can('Member Type Create')
                                <a class="btn btn-primary getHtmlForm set_menu_name fa fa-plus" data-href="{{route('member-type.create')}}" data-name="{{__('administrator.create')}}"></a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body">
                <table id="my-table" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.name')}}</th>
                        <th>{{__('administrator.level')}}</th>
                        <th>{{__('administrator.discount')}}</th>
                        <th>{{__('administrator.note')}}</th>
                        <th>{{__('administrator.created_at')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
    let tb = $('#my-table');
    $(document).ready(function() {
        getTable();
    });
    function getTable() {
        tb.DataTable().destroy();
        tb.DataTable({
            serverSide: true,
            searching: false,
            ordering: false,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('member-type.index') }}",
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'name'},
                    {data: 'level'},
                    {data: 'discount'},
                    {data: 'note'},
                    {data: 'created_at'},
                    {data: 'action'},
                ],
        });

    }
</script>

@endsection







