@extends(branchMenu())
@section('content')
    <style>
        span.label {
            cursor: pointer !important;
        }
    </style>
    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3>{{__('administrator.customer_status')}}</h3>
                                </div>
                                <div class="pull-right">
                                    @can('Customer Status List')
                                        <a class="btn btn-sm btn-primary button_primary create_customer_status"><span class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-body">
                    <form class="form_data">
                        <table id="data_table" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>{{__('administrator.name')}}</th>
                                <th>{{__('administrator.action')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($customer_status as $key=> $row)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$row->name}}</td>
                                    <td>
                                        <button data-href="{{route('customer-status.edit',$row->id)}}" type="button" class="btn btn-warning fa fa-edit btn_edit"></button>
                                        <button type="button" class="btn btn-danger fa fa-trash btn_delete" data-href="{{route('customer-status-delete',$row->id)}}"></button>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#data_table').dataTable();
        });

        $(document).on('click', '.create_customer_status', function () {
            getHtmlForm('{{route('customer-status.create')}}', '{{__('administrator.create')}} {{__('administrator.customer_status')}}');
        });
        $(document).on('click', '.btn_edit', function () {
            $href = $(this).data('href');
            getHtmlForm($href, '{{__('administrator.edit')}} {{__('administrator.customer_status')}}');
        });
        $(document).on('click', '.btn_delete', function () {
            $href = $(this).data('href');
            let text = $(this).closest('tr').find('td:nth-child(2)').text();
            confirmForm($href, '<?php echo e(__('administrator.are_you_sure')); ?>', 'Name: ' + text, 'danger', '400px', 'fa fa-trash', 'red')
        });

    </script>
@endsection
