<!doctype html>
<?php
Fun::lang();
$myBranch = mainBranch();
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/css/pos-invoice.css')}}">
    <style>
.tb-header{
    text-align: center!important;
}
    </style>
</head>
<body>
<?php
$hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
?>
@if($master)
<div class="print_this_form">
    <table class="tb-header" width="100%">
        <tr>
            <td><img src="{{asset($myBranch->logo)}}" style="width: 100px;"></td>
        </tr>
        <tr>
            <td>
                  <span>
                     <b class="name_logo">{{$myBranch->name}}</b><br>
                    <i style="font-size: 11px">{{$myBranch->address}}<br>{{$myBranch->contact}}</i>
                </span>
            </td>
        </tr>
    </table>
    <hr width="40%">
    <table>
        <tr style="text-align: left;">
            <td style="width: 70%;">
                <table>
                    <tr class="font_12">
                        <td>{{__('administrator.date')}} </td>
                        <td>:
                            @if($master)
                            <b>{{ date('d-m-Y',strtotime($master->return_date))}} </b>
                                @endif
                        </td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20">{{__('administrator.invoice')}}</td>
                        <td>: {{ $master->invoice_number}}</td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20">{{__('administrator.returner')}}</td>
                        <td>: {{ findUser($master->user_id)->name }}</td>
                    </tr>
                </table>
            </td>
            <td>
                @if($master->customer_id)
                    @php
                        $customer = findCustomer($master->customer_id);
                    @endphp
                    <table>

                        @if($customer)
                            <tr class="font_12">
                                <td>{{__('administrator.customer')}}</td>
                                <td> : {{ $customer->customer_name }}</td>
                            </tr>
                            @if( $customer->customer_phone)
                                <tr class="font_12">
                                    <td class="width-15">{{__('administrator.phone')}}</td>
                                    <td> : {{ $customer->customer_phone }}</td>
                                </tr>
                            @endif
                            @if($customer->customer_address)
                                <tr class="font_12">
                                    <td>{{__('administrator.location')}}</td>
                                    <td> : {{ $customer->customer_address }}</td>
                                </tr>
                            @endif
                        @endif

                    </table>
                @endif
            </td>
        </tr>
    </table>
    <?php
    $key = 0;
    $total_return = 0;
    $total_change = 0;
    ?>
    <h4 class="m-top-30">{{__('administrator.return_item')}}</h4>
    <table class="table ">
        <thead>
        <tr>
            <th width="6%">#</th>
            <th>{{__('administrator.item_name')}}</th>
            <th>{{__('administrator.item_code')}}</th>
            <th>{{__('administrator.qty')}}</th>
            <th>{{__('administrator.price')}}</th>
            <th>{{__('administrator.total')}}</th>
        </tr>
        </thead>
        <tbody>


        @if($in)
            @foreach ($in as  $key => $row)
                <?php
                $punit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = getProductById($punit->product_id);
                $unit = (findUnit($punit->unit_id));

                $itotal = $row->price*$row->qty;
                $total_return += $itotal;
                ?>
                <tr role="row">
                    <td>{{ $key+=1 }}</td>
                    <td>{{ $product->product_name }}</td>
                    <td>{{ $punit->item_code }}</td>
                    <td>{{ $row->qty.' '.($unit?$unit->unit:'') }}</td>
                    <td>${{ number_format($row->price,2) }}</td>
                    <td>${{ number_format($itotal,2) }}</td>

                </tr>
            @endforeach

        @endif
        </tbody>
        <tr class="">
            <td colspan="4" class="text-left no-border" style="position: relative;"></td>
            <td style="" class="my-customer-border"><span></span>{{__('administrator.sub_total')}}
            </td>
            <td class="text-left " style="position: relative;">${{$total_return}}</td>
        </tr>

    </table>
    <h4 class="m-top-30">{{__('administrator.change_item')}}</h4>
    <table class="table ">
        <thead>
        <tr>
            <th width="6%">#</th>
            <th>{{__('administrator.item_name')}}</th>
            <th>{{__('administrator.item_code')}}</th>
            <th>{{__('administrator.qty')}}</th>
            <th>{{__('administrator.price')}}</th>
            <th>{{__('administrator.total')}}</th>
        </tr>
        </thead>
        <tbody>


        @if($out)
            @foreach ($out as  $key => $row)
                <?php
                $punit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = getProductById($punit->product_id);
                $unit = (findUnit($punit->unit_id));
                $itotal = $row->price*$row->qty;
                $total_change += $itotal;

                ?>
                <tr role="row">
                    <td>{{ $key+=1 }}</td>
                    <td>{{ $product->product_name }}</td>
                    <td>{{ $punit->item_code }}</td>
                    <td>{{ $row->qty.' '.($unit?$unit->unit:'') }}</td>
                    <td>${{ number_format($row->price,2) }}</td>
                    <td>${{ number_format($itotal,2) }}</td>

                </tr>
            @endforeach

        @endif
        </tbody>
        <tr class="">
            <td colspan="4" class="text-left no-border" style="position: relative;"></td>
            <td style="" class="my-customer-border"><span></span>{{__('administrator.sub_total')}}
            </td>
            <td class="text-left " >${{$total_change}}</td>
        </tr>
    </table>
</div>
    @endif
</body>
</html>
