@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.product_return')}}</h3>
                            </div>
                            <div class="pull-right">
                                <a href="{{route('product-return.create')}}" class=" btn btn-info"><span class="fa fa-plus"></span> {{__('administrator.add_new')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br>&nbsp;
            <br>
            <div class="wrapper-table">
                <table id="data_table" class="table table-hover">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.return_date')}}</th>
                        <th>{{__('administrator.invoice_number')}}</th>
                        <th>{{__('administrator.user')}}</th>
                        <th>{{__('administrator.customer')}}</th>
                        <th>{{__('administrator.paid')}}</th>
                        <th>{{__('administrator.total')}}</th>
                        <th>{{__('administrator.note')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        let tb=$('#data_table');
        function getTable() {
            tb.DataTable().destroy();
            tb.DataTable({
                ordering: false,
                serverSide: true,
                searching:false,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('product-return.index') }}",
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'return_date', 'searchable': false},
                        {data: 'invoice_number', 'name': 'nso007_product_return.invoice_number'},
                        {data: 'user_id', 'searchable': false},
                        {data: 'customer_id', 'searchable': false},
                        {data: 'paid', 'searchable': false},
                        {data: 'total', 'searchable': false},
                        {data: 'note', 'name': 'nso007_product_return.invoice_number'},
                        {data: 'action','searchable': false},

                    ],

                "initComplete": function (settings, json) {
                }
            });
        }

        $(document).ready(function () {
            getTable();

            $(document).on('click', ' .show_return', function () {
                let url = $(this).data('href');
                getHtmlFormShow(url,'700px');
            });
            $(document).on('click', ' .btn_delete', function () {
                let row = $(this).closest('tr');

                let date = text(2,row);
                let inv = text(3,row);
                let user = text(4,row);
                let html = '{{__('administrator.date')}} : '+date;
                html += '<br>{{__('administrator.invoice_number')}} : '+inv;
                html += '<br>{{__('administrator.user')}} : '+user;
                let url = $(this).data('href');
                confirmForm(url, '<?php echo e(__('administrator.are_you_sure')); ?>', html, 'danger', '500px', 'fa fa-trash', 'red')
            });

        });
        function text(number,row){
            return row.find('td:nth-child('+number+')').text();
        }
    </script>
@stop
