<?php Fun::lang()?>
        <!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/css/pos-invoice.css')}}">
</head>
<body>
<div class="print_invoice_wholesale">
    <table class="tb-header">
        <tr>
            <td><img src="{{nsoLogo()}}" style="height: 60px;margin: 5px"></td>
        </tr>
        <tr>
            <td>
                <span>
                     <b>{{getBranch()->company_name}}</b><br>
                    <i style="font-size: 11px">{{getBranch()->address}}<br>{{getBranch()->phone}}</i>
                </span>
            </td>
        </tr>
    </table>
    <hr width="40%">
    <table>
        <tr>
            <td>
                <table>
                    <tr>
                        <td width="20%">{{__('administrator.date')}}</td>
                        <td>: {{ date('d-m-Y',strtotime($master->purchase_date))}}</td>
                    </tr>
                    <tr>
                        <td>{{__('administrator.invoice')}}</td>
                        <td>: {{ $master->invoice_number}}</td>
                    </tr>
                    <tr>
                        @if($master->user_id)
                            <td>{{__('administrator.request_by')}}</td>
                            <td>: {{ findUser($master->user_id)->name}}</td>
                        @endif
                    </tr>
                </table>
            </td>
            <td>
                @if($master->customer_id)
                    <table class="table-right-side">
                        <tr>
                            <td>{{__('administrator.customer')}}</td>
                            <td width="40%">: {{ findCustomer($master->customer_id)->customer_name }}</td>
                        </tr>
                        <tr>
                            <td>{{__('administrator.phone')}}</td>
                            <td>: {{ findCustomer($master->customer_id)->customer_phone }}</td>
                        </tr>
                        <tr>
                            <td>{{__('administrator.email')}}</td>
                            <td>: {{ findCustomer($master->customer_id)->customer_email }}</td>
                        </tr>
                    </table>
                @endif
                @if($master->delivery_status)
                    <table class="table-right-side">
                        <tr>
                            <td>{{__('administrator.delivery_number')}}</td>
                            <td>: {{ $master->delivery_phone}}</td>
                        </tr>
                        <tr>
                            <td>{{__('administrator.delivery_fee')}}</td>
                            <td>: {{ $master->delivery_fee}}</td>
                        </tr>
                        <tr>
                            <td>{{__('administrator.note')}}</td>
                            <td>: {{ $master->delivery_note}}</td>
                        </tr>
                    </table>
                @endif
            </td>
        </tr>
    </table>
    <table class="table" style="margin-top: 30px">
        <thead>
        <tr>
            <th width="6%">#</th>
            <th col>{{__('administrator.code')}}</th>
            <th col>{{__('administrator.products')}}</th>
            <th col>{{__('administrator.qty')}}</th>
            <th col>{{__('administrator.price')}}</th>
            <th col>{{__('administrator.discount')}}(%)</th>
            <th width="10%">{{__('administrator.total')}}</th>
        </tr>
        </thead>
        <tbody>
        <?php  $subtotal = 0; ?>
        @if($detail)
            @foreach ($detail as  $key => $row)
                <?php
                $product = getProductById($row->product_id);
                $total = $row->sale_price * $row->qty;
                $total = $total - ($total * $row->dis / 100);

                if ($product->currency == '1') {
                    $currency = '៛';
                    $subtotal += $total / $master->rate;
                } else {
                    $currency = '$';
                    $subtotal += $total;
                }

                $unit = (findUnit($row->unit_id));
                if (\App\Fun\Fun::lang() == 'km') {
                    $unit = $unit->unit_name_km;
                } else {
                    $unit = $unit->unit_name_en;
                }
                ?>
                <tr role="row">
                    <td>{{ $key+1 }}</td>
                    <td>{{ $product->barcode }}</td>
                    <td>{{ $product->product_name }}</td>
                    <td>{{ $row->qty.' '.$unit }}</td>
                    <td>{{ $currency.' '.number_format($row->sale_price, 2) }}</td>
                    <td>{{ number_format($row->dis) }}%</td>
                    <td>{{ $currency.' '.number_format($total, 2)  }}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot>
        <tr>
            <td colspan="6" class="text-right"><b>{{__('administrator.subtotal')}}($):</b></td>
            <td> {{ number_format($subtotal, 2) }}</td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b>{{__('administrator.discount')}}:</b></td>
            <td>{{ number_format($master->discount, 0) }}%</td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b>{{__('administrator.grand_total')}}(៛):</b></td>
            <td> {{ number_format(($subtotal-($subtotal*$master->discount/100))*$master->rate, 2) }}</td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b>{{__('administrator.grand_total')}}($):</b></td>
            <td> {{ number_format(($subtotal-($subtotal*$master->discount/100)), 2) }}</td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b>{{__('administrator.paid')}}(៛):</b></td>
            <td> {{ number_format($master->paid_amount_kh, 2) }}</td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b>{{__('administrator.paid')}}($):</b></td>
            <td>{{ number_format($master->paid_amount_usd  , 2) }}</td>
        </tr>
        </tfoot>
    </table>
    <hr width="40%">
    <table>
        <tr>
            <td style="text-align: center"><b>{{__('administrator.thank_your_for_shopping_with_us')}}</b></td>
        </tr>
    </table>

</div>
</body>
</html>
