@extends('layouts.jform')
@section('content')
    <?php Fun::lang()?>
    <div class="print_this_form ">
        <table width="100%" class="text-center">
            <tr>
                <td colspan="2">
                    @if (file_exists(public_path() . '/' . $branch->logo))
                        <img src="{{asset($branch->logo)}}" width="70px">
                    @endif
                    <h4>{{$branch->name}}</h4>
                    <h5>{{$branch->contact}}</h5>
                    <h5>{{$branch->address}}</h5>
                    <h5>{{$branch->quote}}</h5>
                </td>
            </tr>
            <tr><td><br></td></tr>
            <tr>
                <td>{!! Form::select('user', getUsers(1) , null , ['class' => 'form-control select2','placeholder'=>__('administrator.please_select')]) !!}</td>
                <td><button class="btn btn-primary btn_add_user">{{__('administrator.add_user')}}</button></td>
            </tr>
            <tr>
                <td>
                    <br>
                </td>
            </tr>
        </table>
        <table class="table table-hover">
            <thead>
            <th>#</th>
            <th>{{__('administrator.employee_name')}}</th>
            <th>{{__('administrator.contact')}}</th>
            <th>{{__('administrator.email')}}</th>
            </thead>
            <tbody class="getData">
            </tbody>
        </table>
    </div>
@endsection
@section('jq')
    <script type="text/javascript">
        $(document).ready(function () {
            getData();
            $('.getData').on('click','.btn_remove',function () {
                let user = $(this).data('id');
                $.confirm({
                    title: '',
                    theme: 'modern',
                    closeAnimation: 'zoom',
                    content: '{{__('administrator.are_you_sure')}}',
                    buttons: {
                        hidden: {
                            btnClass: 'btn btn-warning',
                            text: '{{__('administrator.close')}}',
                            keys: ['esc'],
                            action: function () {}
                        },
                        enter: {
                            btnClass: 'btn btn-danger ',
                            text: '{{__('administrator.remove')}}',
                            keys: ['enter'],
                            action: function () {
                                $.get('{{route('branch.show',$branch->id)}}',{remove:1,user},function (data) {
                                    getData();
                                });
                            }
                        },

                    },
                });

            });
            $('.btn_add_user').on('click',function () {
                let user = $(this).closest('tr').find('select[name=user]').val();
                if(user){
                    $.get('{{route('branch.show',$branch->id)}}',{add:1,user},function (data) {
                        if(data==='ok'){
                            getData();
                        }else{
                            jalert('User already existed in branch','500px',1)
                        }
                    });
                }else{
                    jalert('No user selected','500px',1)
                }
            });
        });
        function getData() {
            $.get('{{route('branch.show',$branch->id)}}',{myAjax:1},function (data) {
                $('.getData').html(data);
            });
        }
    </script>
@endsection
