@extends(branchMenu())
@section('content')
    <style>
        span.label {
            cursor: pointer !important;
        }
    </style>
    <?php
        $if = request()->path()!=='partner';
    ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3 class="set_menu_name"></h3>
                                </div>
                                <div class="pull-right">
                                    @can('Branch Create')
                                            <a class="btn btn-sm btn-primary button_primary create_branch"><span class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-body">
                    <form class="form_data table-responsive">
                        <table id="data_table" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr>
                                <th>N°</th>
                                @if($if)
                                <th>{{__('administrator.parent')}}</th>
                                @endif
                                <th>{{__('administrator.logo')}}</th>
                                <th>{{__('administrator.name')}}</th>
                                <th>{{__('administrator.contact')}}</th>
                                <th>{{__('administrator.email')}}</th>
                                <th>{{__('administrator.user')}}</th>
                                <th>{{__('administrator.action')}}</th>
                            </tr>
                            <tr>
                                @if($if)
                                <td></td>
                                @endif
                                <td></td>
                                <td></td>
                                <td>
                                    <input type="text" name="name" class="form-control"
                                           placeholder=" {{__('administrator.name')}} ">
                                </td>
                                <td>
                                    <input type="text" name="phone" class="form-control"
                                           placeholder=" {{__('administrator.phone')}} ">
                                </td>
                                <td>
                                    <input type="text" name="email" class="form-control"
                                           placeholder=" {{__('administrator.email')}}  ">
                                </td>
                                <td></td>
                                <td></td>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        let data_table = $('#data_table');
        let record = 20;
        let page = 1;
        $(document).ready(function () {
            getTable();
        });
        $(document).on('change', '.form-control.input-sm', function () {
            record = $(this).val();
            page = 1;
            getTable();
        });

        $('.form_data').on('blur', 'input[name="name"], input[name="phone"], input[name="email"]', function () {
            page = 1;
            getTable();
        });
        function getTable() {
            data_table.DataTable().destroy();
            data_table.DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                pageLength: record,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('branch.index') }}?" + $('.form_data').serialize(),
                    data: {
                        type:window.location.pathname,
                        record,
                        page
                    }
                },

                columns:
                    [
                        {data: 'DT_RowIndex'},
                        @if($if)
                        {data: 'parent_id'},
                        @endif
                        {data: 'logo'},
                        {data: 'name'},
                        {data: 'contact'},
                        {data: 'email'},
                        {data: 'user_admin'},
                        {data: 'action'},
                    ],
            });
        }

        $(document).on('click', '.create_branch', function () {
            getHtmlForm('{{route('branch.create')}}?type={{request()->path()}}', '{{__('administrator.create')}} {{__('administrator.'.request()->path())}}','550px');
        });
        $(document).on('click', '.btn_set', function () {
            let route = $(this).data('url');
            let content = $(this).closest('tr').find('td:nth-child(3)').text();
            content = '{{__('administrator.branch')}} : ' + content;
            confirmForm(route, title = '<?php echo e(__('administrator.are_you_sure')); ?>', content);
        });
        $(document).on('click', '.btn_edit', function () {
            $href = $(this).data('url');
            getHtmlForm($href+'?type={{request()->path()}}', '{{__('administrator.edit')}} {{__('administrator.'.request()->path())}}','550px');
        });
        $(document).on('click', '.show_logo', function () {
            $href = $(this).attr('src');
            let img = `<img class="print_this_form" src="${$href}">`;
            jalert(img, '500px');
        });
        $(document).on('click', '.btn_show', function () {
            $href = $(this).data('url');
            getHtmlFormShow($href, '700px');
        });
    </script>
@endsection
