@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3>{{__('administrator.warehouses')}}</h3>
                                </div>
                                <div class="pull-right">
                                    @can('Warehouse Create')
                                        <a class="btn bg-olive btn-flat margin"><span
                                                class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-body" style="overflow-x:auto;">
                    <form class="form_data">
                        <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr>
                                <th>N°</th>
                                <th>{{__('administrator.branch')}}</th>
                                <th>{{__('administrator.warehouse_name')}}</th>
                                <th>{{__('administrator.address')}}</th>
                                <th>{{__('administrator.description')}}</th>
                                <th>{{__('administrator.created_at')}}</th>
                                <th width="15%">{{__('administrator.action')}}</th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        //  start datatable
        var record = 20;
        var page = 1;
        $(document).ready(function () {
            dataTable();
        });
        $(document).on('change', '.data_table_length', function () {
            record = $(this).val();
            page = 1;
            dataTable();
        });


        $(document).on('click', '.page-item', function () {
            page = $('.page-item.active .page-link').text();
            dataTable();
        });

        function dataTable() {
            $('#data_table').DataTable().destroy();
            $('#data_table').DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.previous')}}"
                    },
                },
                serverSide: true,
                ordering: false,
                searching: false,
                pageLength: record,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('warehouse.index') }}?",
                    data: {
                        record,
                        page
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'branch'},
                        {data: 'name'},
                        {data: 'location_name'},
                        {data: 'description'},
                        {data: 'created_at'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                    $('select[name="data_table_length"]').val(json.records);
                    $('.dataTables_paginate').empty();
                    $('#data_table_paginate').twbsPagination('destroy');
                    $('#data_table_paginate').twbsPagination({
                        totalPages: json.totalPage,
                        visiblePages: 5,
                        startPage: parseInt(json.activePage),
                        next: 'Next',
                        prev: 'Prev',
                        onPageClick: function (event, pageD) {
                        }
                    });
                }
            });
        }

        // end

        //  set mainwarehouse
        $(document).on('click', 'tbody .btn-default', function () {
            var id = $(this).data('id');
            $.confirm({
                title: '<strong style="color:darkcyan;">{{__('administrator.change_status')}}</strong>',
                content: "<b>{{__('administrator.Change_Main_Warehouse')}} ? ",
                buttons: {
                    '{{__('administrator.ok')}}': {
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                type: "GET",
                                dataType: "json",
                                url: '{{route("warehouse_changeStatus")}}',
                                data: {'id': id},
                                success: function (data) {
                                    showSuccessToast('Warehouse updated successfully!');
                                    $('.jconfirm-buttons .btn-default').trigger('click');
                                    $('#data_table').DataTable().destroy();
                                    dataTable();
                                }
                            });
                            return false;
                        }
                    },
                    '{{__('administrator.cancel')}}': function () {
                    },
                }
            });
        });
        // end

        $(document).on('click', '.btn.bg-olive.btn-flat', function () {
            getHtmlForm('{{route('warehouse.create')}}', '{{__('administrator.create')}} {{__('administrator.warehouse')}}');
        });
        $(document).on('click', '.fa.fa-pencil.btn.btn-sm.btn-warning', function () {
            $href = $(this).data('url');
            getHtmlForm($href, '{{__('administrator.edit')}} {{__('administrator.warehouse')}}');
        });

        // delete category
        $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function () {
            var url = $(this).data('url');
            $.confirm({
                icon: 'flaticon-danger',
                title: '{{__('administrator.confirm')}} ',
                content: '{{__('administrator.are_you_sure')}} ',
                type: 'red',
                typeAnimated: true,
                closeIcon: true,
                closeIconClass: 'flaticon-close',
                buttons: {
            {{__('administrator.submit')}}:
            {
                btnClass: 'btn-red',
                    action
            :

                function () {
                    $.ajax({
                        type: 'DELETE',
                        url: url,
                        data: {
                            '_token': '{{ csrf_token() }}'
                        },
                        dataType: 'json',
                        success: function (data) {
                            if (data[1] == 401) {
                                showWarningToast(data[0]);
                            } else {
                                showSuccessToast('Warehouse deleted successfully!');
                                $('.jconfirm-buttons .btn-default').trigger('click');
                                $('#data_table').DataTable().destroy();
                                dataTable();
                            }
                        }
                    });
                    return false;
                }
            }
        ,
            {{__('administrator.cancel')}}:
            {
                action: function () {
                }
            }
        }
        })
            ;
        });
        // end
    </script>
@endsection



