@extends(branchMenu())
@section('content')
    <?php Fun::lang();
    $ifMember = request()->path() === 'member';
    ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3 class="set_menu_name"></h3>
                                </div>
                                <div class="pull-right">
                                    <a class="btn btn-primary getHtmlForm fa fa-plus set_menu_name" data-href="{{route('users.create')}}?type={{request()->path()}}" data-name="{{__('administrator.create')}}"></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="top-content">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <form class="form_data">
                                @if(Auth::user()->user_type!=='member' && $ifMember)
                                    <div class="col-sm-4 col-md-4">
                                        <div class="col-sm-4 col-md-4">
                                            {{__('administrator.leader')}} :
                                        </div>
                                        <div class="form-group col-sm-8 col-md-8">
                                            {!! Form::select('leader_id',getUsers(null,''),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                                        </div>
                                    </div>
                                @endif
                            </form>
                        </div>
                    </div>
                </div>
                <div class="box-body table-responsive">
                    <table id="datatable" width="100%" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr>
                            <th>#</th>
                            @if($ifMember)
                                <th>{{__('administrator.team_leader')}}</th>
                            @endif
                            <th>{{__('administrator.name')}}</th>
                            @if($ifMember)
                                <th>{{__('administrator.member_type')}}</th>
                            @endif
                            <th>{{__('administrator.gender')}}</th>
                            <th>{{__('administrator.phone_number')}}</th>
                            @if($ifMember)
                                <th>{{__('administrator.id_card')}}</th>
                                <th>{{__('administrator.province')}}</th>
                            @endif
                            <th>{{__('administrator.username')}}</th>
                            <th>{{__('administrator.status')}}</th>
                            <th>{{__('administrator.action')}}</th>
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>


@endsection



@section('script')
    <script type="text/javascript">
        let tb = $('#datatable');
        $(document).ready(function () {

            getTable()
            $('.form_data').on('change','select',function (){
                getTable()
            });
            tb.on('click', '.change_status', function () {
                var status = $(this).data('status') == 0 ? 1 : 0;
                var user_id = $(this).data('id');
                console.log(status);
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/user-status',
                    data: {'status': status, 'user_id': user_id},
                    success: function (data) {
                        window.location.reload();
                    }
                });
            })
        });

        function getTable() {
            let data = $('.form_data').serialize();
            tb.DataTable().destroy();
            tb.DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('member.index') }}?" + data,
                    data: {
                        type: '{{request()->path()}}',
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                            @if($ifMember)
                        {
                            data: 'leader_id'
                        },
                            @endif
                        {
                            data: 'name'
                        },
                            @if($ifMember)
                        {
                            data: 'member_type_id'
                        },
                            @endif
                        {
                            data: 'gender'
                        },
                        {data: 'phone'},
                            @if($ifMember)
                        {
                            data: 'id_card'
                        },
                        {data: 'province_id'},
                            @endif
                        {
                            data: 'username'
                        },
                        {data: 'status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                },
            });
        }
    </script>
@stop



