@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3>{{__('administrator.purchase_approval')}}</h3>
                                </div>
                                <div class="pull-right">
                                    @if(request('show')==='p')
                                        <a href="{{ route('purchases-item.create') }}" class="btn bg-olive btn-flat margin"><span class="fa fa-plus"></span> {{__('administrator.new_record')}}</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="top-content">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <form class="form_data">
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.from_date')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.to_date')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <div class="col-sm-4 col-md-4">
                                        {{__('administrator.payment_status')}} :
                                    </div>
                                    <div class="form-group col-sm-8 col-md-8">
                                        {!! Form::select('payment_status',getPaymentStatus(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                                    </div>
                                </div>
                                @if(!ifMember())
                                    <div class="col-sm-4 col-md-4">
                                        <div class="col-sm-4 col-md-4">
                                            {{__('administrator.purchase_by')}} :
                                        </div>
                                        <div class="form-group col-sm-8 col-md-8">
                                            {!! Form::select('user_id',$user,null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                                        </div>
                                    </div>
                                    @if(request('show')==='p')
                                        <div class="col-sm-4 col-md-4">
                                            <div class="col-sm-4 col-md-4">
                                                {{__('administrator.supplier')}} :
                                            </div>
                                            <div class="form-group col-sm-8 col-md-8">
                                                {!! Form::select('supplier_id',getSupplier(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                                            </div>
                                        </div>
                                    @endif
                                @endif
                            </form>
                        </div>
                    </div>
                </div>
                <div class="box-body table-responsive">
                    <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                        <thead>
                        <tr>
                            <th>N°</th>
                            <th>{{__('administrator.purchase_date')}}</th>
                            <th>{{__('administrator.invoice_number')}}</th>
                            <th>{{__('administrator.purchase_by')}}</th>
                            <th>{{__('administrator.supplier')}}</th>
                            <th>{{__('administrator.grand_total')}}</th>
                            <th>{{__('administrator.paid')}}</th>
                            <th>{{__('administrator.remain_amount')}}</th>
                            <th>{{__('administrator.payment_status')}}</th>
                            <th>{{__('administrator.status')}}</th>
                            <th>{{__('administrator.confirm_received')}}</th>
                            <th>{{__('administrator.action')}}</th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        let table = $('#data_table');
        $(document).ready(function () {
            dataTable();
            table.on('click', '.btn_receive', function () {
                let href = $(this).data('href');
                $.get(href, function (res) {
                    href = href + '?confirm=1';
                    confirmForm(href, '', res, 'success', '900px', '', 'green', {confirm_: 1});
                });
            });
            table.on('click', '.btn_delete', function () {
                let this_ = $(this);

                function td(nth) {
                    return this_.closest('tr').find('td:nth-child(' + nth + ')').text();
                }

                let request = td(2);
                let inv = td(3);
                let date = td(4);
                let text = '';
                if (request) {
                    text += '<b>Request By</b>: ' + request;
                }
                text += '<br><b>Invoice Number</b>: ' + inv;
                text += '<br><b>Request Date</b>: ' + date;


                confirmForm($(this).data('href'), '{{__('administrator.are_you_sure')}}', text, 'danger', '500px', 'fa fa-trash', 'red');
            });
            $(document).on('change', '.form-control', function () {
                dataTable();
            });
            table.on('click', '.btn-approve', function () {
                let url = $(this).data('url');
                $.confirm({
                    icon: 'flaticon-danger',
                    title: '{{__('administrator.confirm')}}!',
                    content: '{{__('administrator.Are_you_sure_to_Approve_this_item')}}?',
                    type: 'blue',
                    typeAnimated: true,
                    closeIcon: true,
                    closeIconClass: 'flaticon-close',
                    buttons: {
                        'confirm': {
                            btnClass: 'btn-blue confirmmm',
                            text: '{{__('administrator.confirm')}}',
                            action: function () {
                                this.buttons.confirm.disable();
                                $.ajax({
                                    url: url,
                                    type: 'GET',
                                    dataType: 'json',
                                    success: function (data) {
                                        console.log(data);
                                        if (data.route) {
                                            toastDemo('{{__('administrator.approved_successfully')}}', '{{__('administrator.success')}}');
                                            $('.jconfirm-buttons .btn-default').trigger('click');
                                            $('#data_table').DataTable().destroy();
                                            dataTable();
                                            $('.jconfirm-closeIcon').trigger('click');
                                        } else {
                                            showWarningToast(data[0]);
                                        }
                                    },
                                    error: function (xhr) {
                                        alertErrorFormController(xhr);
                                    }
                                });
                            }
                        },
                        '{{__('administrator.cancel')}}': {
                            action: function () {
                            }
                        }
                    }
                });
            });
        });

        function dataTable() {

            table.DataTable().destroy();
            table.DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('purchases-item-approval') }}?" + $('.form_data').serialize(),
                    data: {show: '{{request('show')}}'}
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'purchase_date'},
                        {data: 'invoice_number'},
                        {data: 'member_id'},
                        {data: 'request_to'},
                        {data: 'grand_total'},
                        {data: 'paid_usd'},
                        {data: 'remain_amount'},
                        {data: 'payment_status'},
                        {data: 'status'},
                        {data: 'confirm_receive'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {

                }
            });
        }

        // delete Purchase
        $(document).on('click', '.fa.fa-times.btn.btn-sm.btn-danger', function () {
            let url = $(this).data('url');
            $.confirm({
                icon: 'flaticon-danger',
                title: '{{__('administrator.confirm')}}!',
                content: '{{__('administrator.Are_you_sure_to_Approve_this_item')}}!',
                type: 'red',
                typeAnimated: true,
                closeIcon: true,
                closeIconClass: 'flaticon-close',
                buttons: {
                    '{{__('administrator.confirm')}}': {
                        btnClass: 'btn-red',
                        action: function () {
                            $.ajax({
                                url: url,
                                type: 'GET',
                                dataType: 'json',
                                success: function (data) {
                                    if (data[1] == 401) {
                                        showWarningToast(data[0]);
                                    } else {
                                        toastDemo('{{__('administrator.delete_item_successfully')}}', '{{__('administrator.success')}}');
                                        $('.jconfirm-buttons .btn-default').trigger('click');
                                        dataTable();
                                        $('.jconfirm-closeIcon').trigger('click');
                                    }
                                }
                            });
                            return false;
                        }
                    },
                    '{{__('administrator.cancel')}}': {
                        action: function () {
                        }
                    }
                }
            });
        });
        // end
    </script>
@endsection
