@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>

    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.adjustment')}}</h3>
                            </div>
                            <div class="pull-right">
                                @can('Adjustment Create')
                                    <a href="{{route('adjustment.create')}}" class=" btn btn-primary"><span
                                            class="fa fa-plus"></span> {{__('administrator.adjustment')}}</a>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="datatable_purchases" width="100%" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.date')}}</th>
                        <th>{{__('administrator.invoice_number')}}</th>
                        <th>{{__('administrator.user')}}</th>
                        <th>{{__('administrator.note')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>

        @endsection



        @section('script')

            <script type="text/javascript">
                let table = $('#datatable_purchases');
                $(document).ready(function () {
                    getTable();
                    $('table').on('click', '.btn_show', function () {
                        getHtmlFormShow($(this).data('href'), '800px');
                    });
                });

                function getTable() {
                    table.DataTable().destroy();
                    table.DataTable({
                        ordering: false,
                        serverSide: true,
                        lengthMenu: tbLength,
                        ajax: "{{ route('adjustment.index') }}",
                        columns:
                            [
                                {data: 'DT_RowIndex', 'searchable': false},
                                {data: 'adjustment_date'},
                                {data: 'invoice_number'},
                                {data: 'user_id'},
                                {data: 'note'},
                                {data: 'action', 'searchable': false},

                            ],

                        "initComplete": function (settings, json) {
                        }
                    });

                    $.fn.dataTable.ext.errMode = 'throw';
                }

            </script>
@stop



