@extends('layouts.app')
@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.request_stock')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br>&nbsp;
            <br>

            <div class="wrapper-table">
                <table id="print_table" width="100%" class="table table-striped table-hover ​​">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.invoice_number')}}</th>
                        <th>{{__('administrator.request_by')}}</th>
                        <th>{{__('administrator.date')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th style="width:200px;">{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        function getTable(supplier='',type='') {
            $('#print_table').DataTable().destroy();
            $('#print_table').DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.previous')}}"
                    },
                },
                ordering: false,
                serverSide: true,
                lengthMenu: tbLength,
                ajax: {
                    url:"{{ route('request-stock-item.index') }}",
                    data:{
                        supplier:supplier,
                        type:type
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'invoice_number', 'name': 'nso007_production_request.invoice_number'},
                        {data: 'request_by', 'searchable': false},
                        {data: 'date', 'searchable': false},
                        {data: 'status', 'searchable': false},
                        {data: 'action', 'searchable': false},
                    ],

                "initComplete": function (settings, json) {
                }
            });
        }
        $(document).ready(function () {
            getTable();
            $('.select2').on('change',function () {
                var supplier = $('select[name=supplier]').val();
                var type = $('select[name=type]').val();
                getTable(supplier,type);
            });


            $(document).on('click',' .show_request',function () {
                let id = $(this).data('id');
                $.ajax({
                    url:$(this).data('href'),
                    method:'get',
                    dataType: 'json',
                    success:function (data) {
                        $.alert({
                            title:'',
                            theme:'modern',
                            useBootstrap:false,
                            boxWidth:'50%',
                            content:data.html,
                            buttons:{
                                reject: {
                                    text: '{{__('administrator.reject')}}',
                                    btnClass: 'button_danger status_btn',
                                    action: function () {
                                        let this_ = this;
                                        update_status(id, this, 2);
                                        return false;
                                    }
                                },
                                approve: {
                                    text: '{{__('administrator.approve')}}',
                                    btnClass: 'button_success status_btn',
                                    action: function () {
                                        update_status(id, this, 1);
                                        return false;
                                    }
                                },
                                close: {
                                    text: '{{__('administrator.close')}}',
                                    btnClass: 'button_warning',
                                },
                            }
                        });

                    }
                });
            });
        });
        function update_status(id, this_, status)
        {
            let text_note = '<label>{{__('administrator.note')}}</label>{!! Form::textarea('request_note',null, ['class' => 'form-control no-resize','placeholder'=>__('administrator.note')]) !!}';
            $.confirm({
                title: '',
                theme: 'modern',
                content: text_note,
                buttons: {
                    submit: {
                        text: (status === 2 ? '{{__('administrator.reject')}}' : '{{__('administrator.approve')}}'),
                        btnClass: (status === 2 ? 'button_danger' : 'btn bg-olive btn-flat margin'),
                        action: function () {
                            let this_ = this;
                            this_.buttons.submit.disable();
                            let note = this.$content.find('textarea[name=request_note]').val();
                            $.ajax({
                                url: '{{route("request-stock-item-update-status")}}',
                                dataType: 'json',
                                data: {
                                    "_token": "{{ csrf_token() }}",
                                    id: id,
                                    status: status,
                                    note: note,
                                },
                                method: 'post'
                            }).done(function (response) {
                                if (response.status === 'success') {
                                    window.location.reload();
                                } else {
                                    if (parseInt(response.count) > 0) {
                                        $.alert({
                                            title: '',
                                            content: response.message,
                                            theme: 'modern',
                                        });
                                        this_.buttons.submit.enable();
                                    }
                                }
                            }).fail(function (xhr) {
                                let error       = xhr.responseJSON.errors;
                                let text_err    = '';
                                $.each(error, function (i, val) {
                                    text_err += '' + val + '<br>';
                                });
                                if (text_err === '') {
                                    text_err = 'Data is Invalid...';
                                }
                                $.alert(text_err);
                                this_.buttons.submit.enable();
                            });
                            return false;
                        }
                    },
                    cancel: {
                        text: '{{__('administrator.cancel')}}',
                        btnClass: 'button_warning',
                        action: function () {
                        }
                    },
                },
            });
            return false;
        }
    </script>
@stop
