@extends(branchMenu())
@section('content')
<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.report_purchase')}}</h3>
                        </div>
                        <div class="pull-right">

                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th>{{__('administrator.invoice_number')}}</th>
                        <th>{{__('administrator.purchase_date')}}</th>
                        <th>{{__('administrator.total')}}</th>
                        <th>{{__('administrator.paid')}}</th>
                        <th>{{__('administrator.remain_amount')}}</th>
                        <th>{{__('administrator.payment_status')}}</th>
                        <th>{{__('administrator.total_qty')}}</th>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <input type="text" name="invoice_number" class="form-control"  placeholder="{{__('administrator.invoice_number')}}" autocomplete="off">
                        </td>
                        <td>
                            <input type="text" name="created_at" class="form-control"  placeholder="{{__('administrator.purchase_date')}}" autocomplete="off" value="">
                        </td>
                        <td>
                            <input type="text" name="total" class="form-control"  placeholder="{{__('administrator.total')}}" autocomplete="off" value="">
                        </td>
                        <td>
                            <input type="text" name="paid" class="form-control"  placeholder="{{__('administrator.paid')}}" autocomplete="off" value="">
                        </td>
                        <td>
                            <input type="text" name="remain_amount" class="form-control"  placeholder="{{__('administrator.remain_amount')}}" autocomplete="off" value="">
                        </td>
                        <td>
                            {!! Form::select('payment_status', ['owe' => 'Owe', 'paid' => 'Paid'], null, ['class' => 'form-control', 'placeholder' => __('administrator.payment_status')]) !!}
                        </td>
                        <td></td>

                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
    $(document).ready(function() {
        dataTable();
    });
    $(document).on('change', 'select[name="payment_status"]', function() {
        dataTable();
    });

    $(document).on('blur', '#data_table input', function(){
        dataTable();
    })


    function dataTable() {
        var invoice_number = $('input[name="invoice_number"]').val();
        var created_at = $('input[name="created_at"]').val();
        var total = $('input[name="total"]').val();
        var paid = $('input[name="paid"]').val();
        var remain_amount = $('input[name="remain_amount"]').val();
        var payment_status = $('select[name="payment_status"]').val();
        $('#data_table').DataTable().destroy();

        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.previous')}}"
                },
            },
            serverSide: true,
            ordering: false,
            searching: false,
            dom: 'lBfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    autoFilter: true,
                    className: 'btn btn-info pull-right',
                    filename: menu_name,
                    title: menu_name,
                    sheetName: menu_name,
                    footer:true,
                    header: true,
                    text: 'Save as Excel',
                },
            ],
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('report-purchases.index') }}",
                data:{
                    invoice_number,
                    created_at,
                    total,
                    paid,
                    remain_amount,
                    payment_status,
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'invoice_number'},
                    {data: 'purchase_date'},
                    {data: 'total'},
                    {data: 'paid_usd'},
                    {data: 'remain_amount'},
                    {data: 'payment_status'},
                    {data: 'total_qty'},
                ],
            "initComplete": function (settings, json) {

            }
        });
    }
// end
// delete Purchase
    $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function(){
        var url = $(this).data('url');
        $.confirm({
            icon: 'flaticon-danger',
            title: 'Confirm!',
            content: 'Are you sure to delete this item?',
            type: 'red',
            typeAnimated: true,
            closeIcon: true,
            closeIconClass: 'flaticon-close',
            buttons: {
                confirm: {
                    btnClass: 'btn-red',
                    action: function () {
                        $.ajax({
                            type: 'DELETE',
                            url: url,
                            data:{
                                '_token': '{{ csrf_token() }}'
                            },
                            dataType:'json',
                            success:function(data){
                                if(data[1] == 401){
                                    showWarningToast(data[0]);
                                }else{
                                    showSuccessToast('Purchase deleted successfully!');
                                    $('.jconfirm-buttons .btn-default').trigger('click');
                                    $('#data_table').DataTable().destroy();
                                    dataTable();
                                }
                            }
                        });
                        return false;
                    }
                },
                cancel: {
                    action: function () {
                    }
                }
            }
        });
    });
// end
</script>
@endsection
