@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.report_stock_item')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group padding-0">
                        <div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    {{__('administrator.warehouse')}}
                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    {!! Form::select('warehouse', $warehouses, null, array('class' => 'form-control select2', 'placeholder' =>  __('administrator.please_select_warehouse'))) !!}
                                </div>
                            </div>
                            <div class="col-sm-offset-6 col-sm-6">
                                <button class=" button_success pull-right print_button" type="button" data-text="{{__('administrator.report_stock')}}"><i class="fa fa-print" ></i> {{__('administrator.print')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="print_table" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.warehouse')}}</th>
                        <th>{{__('administrator.barcode')}}</th>
                        <th>{{__('administrator.item_name')}}</th>
                        <th>{{__('administrator.import_qty')}}</th>
                        <th>{{__('administrator.production_qty')}}</th>
                        <th>{{__('administrator.export_qty')}}</th>
                        <th>{{__('administrator.balance_qty')}}</th>
                    </tr>
                    </thead>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        @endsection
        @section('script')
            <script type="text/javascript">
                function getTable(warehouse=''){
                    $('#print_table').DataTable({
                        "oLanguage": {
                            "sSearch": "{{__('administrator.search')}}:",
                            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                            "oPaginate": {
                                "sFirst": "{{__('administrator.first')}}",
                                "sLast": "{{__('administrator.last')}}",
                                "sNext": "{{__('administrator.next')}}",
                                "sPrevious": "{{__('administrator.previous')}}"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        lengthMenu: tbLength,
                        ajax: {
                            url:'{{route('report.stock-item')}}',
                            data:{
                                warehouse:warehouse,
                            },
                        },
                        columns:
                            [
                                {data: 'DT_RowIndex','searchable': false},
                                {data: 'warehouse', 'searchable': true},
                                {data: 'barcode', 'name': 'nso007_stocks.barcode'},
                                {data: 'product_name', 'name': 'nso007_products.product_name'},
                                {data: 'in_qty'},
                                {data: 'production_qty'},
                                {data: 'out_qty'},
                                {data: 'stock_qty'},
                            ],
                        "footerCallback": function (row, data, start, end, display) {

                        },
                    });
                }
                $(document).ready(function () {
                    getTable();
                    $('select').on('change',function () {
                        $('#print_table').DataTable().destroy();
                        let warehouse = $('select[name=warehouse]').val();
                        getTable(warehouse);
                    });
                });
            </script>
@stop



