<table id="data_table" class="table table-striped table-hover table-bordered">
    <thead>
    <tr>
        <th>N°</th>
        <th width="15%">{{__('administrator.invoice_number')}}</th>
        <th width="15%">{{__('administrator.sale_date')}}</th>
        <th>{{__('administrator.sale_by')}}</th>
        <th>{{__('administrator.total')}}</th>
        <th>{{__('administrator.paid')}}</th>
        <th>{{__('administrator.remain_amount')}}</th>
        <th>{{__('administrator.payment_methods')}}</th>
        <th>{{__('administrator.payment_status')}}</th>
        <th>{{__('administrator.store_qty')}}</th>
        <th>{{__('administrator.deliver_qty')}}</th>
        <th>{{__('administrator.total_qty')}}</th>
    </tr>
    </thead>
    <tbody class="tbody">

    </tbody>
</table>

<script type="text/javascript">
    //  start datatable
    $(document).ready(function () {
        getTable();
        $('.hide_wholesale').hide();
    });

    function getTable() {
        let is_branch = "{{ auth()->user()->is_role }}";
        let column = [
            {data: 'DT_RowIndex'},
            {data: 'reference_number'},
            {data: 'sale_date'},
            {data: 'seller'},
            {data: 'payment_amount'},
            {data: 'paid_amount'},
            {data: 'remain'},
            {data: 'payment_method'},
            {data: 'payment_status'},
            {data: 'total_store_qty'},
            {data: 'total_deliver_qty'},
            {data: 'total_qty'},
        ];

        if (is_branch === 'Seller') {
            column.splice(1, 1);
        }
        $('#data_table').DataTable().destroy();
        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.previous')}}"
                },
            },
            dom: 'lBfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    autoFilter: true,
                    className: 'btn btn-info pull-right',
                    filename: menu_name,
                    title: menu_name,
                    sheetName: menu_name,
                    footer:true,
                    header: true,
                    text: 'Save as Excel',
                },
            ],
            serverSide: true,
            ordering: false,
            searching: false,
            ajax: {
                url: "{{ route('report-wholesale') }}"+ '?' + $('.form_data').serialize(),
                data: {
                    isAjax:1,
                }
            },
            columns: column,

            "initComplete": function (settings, json) {

            }
        });
    }
</script>



