@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <?php
        $check = @$crm?route('report-sale-retail'):null;
        $report_type = [route('report-wholesale')=>__('administrator.wholesale_report')];
        if(ifMember()){
            $report_type[route('report-sale-retail')]=__('administrator.sale_retail_report');
        }
    ?>
    <div class="page box box-primary">
        <div class="container-fluid">
            <div class="top-content ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="pull-left">
                            <h3 class="report_name">{{__('administrator.report_sale')}}</h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-md-3 {{$check?'display-none':''}}">
                            <div class="col-sm-4 col-md-4">
                                {{__('administrator.report_type')}} :
                            </div>
                            <div class="form-group col-sm-8 col-md-8">
                                {!! Form::select('report_type',$report_type,null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                            </div>
                        </div>
                        <form class="form_data">
                            <div class="col-sm-3 col-md-3 " >
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.user')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('user_id',getAllSomeUser(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3 hide_wholesale" >
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.customer')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('customer_id',[],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_customer ']) !!}
                                </div>
                            </div>

                            <div class="col-sm-3 col-md-3 hide_wholesale">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.type_of_illness')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('type_illness',illness_type(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.payment_methods')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('payment_type',getPaymentType(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.payment_status')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('payment_status',getPaymentStatus(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.from_date')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']) !!}
                                </div>
                            </div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.to_date')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']) !!}
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-12 form-group text-right">
                                <button class="btn btn-md btn-danger btn-clear"
                                        type="button">{{ __('administrator.clear') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            {{-- <br> --}}
            <div class="wrapper-table table-responsive">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('select[name=report_type]').val('{{request('kk')}}').change();
            $('.form_data').on('change','select,input', function () {
                getTable();
            });
            $('.btn-clear').on('click', function () {
                $('.form_data').find('input,select').val(null).change();
                getTable();
            });
            $(document).on('click', '.page-item', function() {
                page = $('.page-item.active .page-link').text();
                getTable();
            });
            @if($check)
            $('select[name=report_type]').val('{{$check}}').change();
            @endif
        });

        $('select[name=report_type]').on('change', function () {
            let type = $(this).val();
            let text = $('select[name=report_type] option:selected').text();
            $('.wrapper-table').html('');
            if (type) {

                $.ajax({
                    url: type,
                    dataType: 'html',
                    method: 'get',
                    data: {
                        url: type
                    },
                    success: function (data) {
                        if (data) {
                            $('.wrapper-table').html(data);
                            $('.report_name').text(text);
                        }

                    },
                    error(xhr) {
                        console.log(1);
                    }
                });
            } else {
                $('.report_name').text('{{__('administrator.report_sale')}}');
            }

        });
    </script>
@stop



