@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="pull-left">
                            <h3>{{__('administrator.roles')}}</h3>
                        </div>
                        <div class="pull-right">
                            <a class=" button_info" href="{{ route('roles.create') }}"><span
                                        class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>
                        </div>
                        <div class="pull-right">
                            <a class=" button_danger add_permission"><span
                                        class="fa fa-plus"></span> {{__('administrator.permission')}}</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="datatable_roles" class="table table-bordered table-hover nowrap customize">
                    <thead>
                    <tr>
                        <th>{{__('administrator.no')}}</th>
                        <th>{{__('administrator.role_name')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($data as $key=>$value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$value->name}}</td>
                            <td>
                                <a class="btn bg-olive btn-flat margin"
                                   href="{{route('roles.edit',$value->id)}}">{{__('administrator.edit')}}</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $('.add_permission').on('click', function () {
                $.confirm({
                    title: '{{__('administrator.submit')}}',
                    theme: 'modern',
                    content: '',
                    buttons: {
                        cancel: {
                            btnClass: 'button_warning',
                            text: '{{__('administrator.cancel')}}',
                            action: function () {

                            },
                        },
                        submit: {
                            btnClass: 'btn bg-olive btn-flat margin',
                            text: '{{__('administrator.submit')}}',
                            action: function () {

                            },
                        },
                    },
                });
            });
        });
    </script>
@endsection



