@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <style>
        tfoot td:first-child {
            border: none !important;
            border-top: none !important;
        }
    </style>
    <?php
    $invoice = findPurchaseOrder($master->invoice_id);
    $amount = $master->payment_amount;
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <div class="container-fluid" style="background: white; padding:20px;border-radius: 5px">
                    <div class="row " style="line-height: 25px">
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                            <h3 style="margin-bottom: 5px">{{__('administrator.purchase_order_payment')}}</h3>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                            <div class="row">
                                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-left">
                                    <b>{{__('administrator.date')}}
                                        :</b> {{ date('d-m-Y',strtotime($master->payment_date))}}
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-left">
                                    <b>{{__('administrator.invoice')}}
                                        :</b> {{$invoice->invoice_number}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th width="6%">#</th>
                                <th col>{{__('administrator.date')}}</th>
                                <th col>{{__('administrator.amount')}}</th>
                                <th col>{{__('administrator.refund')}}</th>
                                <th col>{{__('administrator.owed')}}</th>
                                <th col>{{__('administrator.note')}}</th>
                                <th col>{{__('administrator.status')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php  $subtotal = 0; ?>
                            @if($detail->count()>0)
                                @foreach ($detail as  $key => $row)
                                    <tr role="row">
                                        <td>{{ $key+1 }}</td>
                                        <td>{{ date('d-m-Y',strtotime($row->payment_date)) }}</td>
                                        <td>${{ $amount }}</td>
                                        <td>${{ $row->paid_amount }}</td>
                                        <td>${{  $amount = number_format($amount-$row->paid_amount,2) }}</td>
                                        <td>{{  $row->note }}</td>
                                        @php
                                            if($amount==$master->payment_amount){
                                                $text =__('administrator.due');
                                                $color = 'danger';
                                            }else{
                                                if($amount>0){
                                                $text =__('administrator.partial');
                                                 $color = 'warning';
                                                }
                                                else{
                                                $text =__('administrator.paid');
                                                 $color = 'success';
                                                }
                                            }

                                        @endphp
                                        <td><span class="label label-{{$color}}">{{$text}}</span></td>

                                    </tr>
                                @endforeach
                            @else
                                <tr role="row">
                                    <td colspan="7" class="text-center">{{__('administrator.no_data_available')}}</td>
                                </tr>
                            @endif
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
@endsection