<?php Fun::lang() ?>
<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
    <fieldset>
        <legend>{{__('administrator.product')}}</legend>
        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8 col-lg-offset-2 col-md-offset-2">
            <div class="form-group row">
                <label class="col-sm-3 text-right">{{__('administrator.name')}}<span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    {!! Form::text('product_name',null, ['placeholder'=>__('administrator.product_name'),'class' => 'form-control']) !!}
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right">{{__('administrator.item_code')}}<span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    {!! Form::text('item_code',null, ['placeholder'=>__('administrator.code'),'class' => 'form-control']) !!}
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right">{{__('administrator.brands')}}<span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    <div class="input-group">
                        {!!  Form::select('brand_id', getProductBrand(), null, ['class' => 'brand form-control select2', 'placeholder' =>  __('administrator.please_select')  ]) !!}
                        <span class="input-group-addon getHtmlForm"
                              data-href="{{route('brand.create')}}?input_name=brand_id" data-name="Create Brand"><i
                                    class="fa fa-plus-circle text-blue"></i></span>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right">{{__('administrator.category')}}<span
                            class="text-danger">*</span></label>
                <div class="col-sm-9">
                    <div class="input-group">
                        {!!  Form::select('category_id', getCategory(), null, ['class' => 'form-control select2', 'placeholder' =>  __('administrator.please_select')  ]) !!}
                        <span class="input-group-addon getHtmlForm"
                              data-href="{{route('category.create')}}?input_name=category_id"
                              data-name="Create Category"><i class="fa fa-plus-circle text-blue"></i></span>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right">{{__('administrator.default')}} {{__('administrator.shelf')}}</label>
                <div class="col-sm-9">
                    <div class="input-group">
                        {!!  Form::select('shelf', getProductShelf(), null, ['class' => 'form-control select2', 'placeholder' =>  __('administrator.please_select')  ]) !!}
                        <span class="input-group-addon getHtmlForm"
                              data-href="{{route('shelf.create')}}?input_name=shelf"
                              data-name="Create Category"><i class="fa fa-plus-circle text-blue"></i></span>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right">{{__('administrator.description')}}</label>
                <div class="col-sm-9">
                    {!! Form::textarea('description',null, ['placeholder'=>__('administrator.description'),'class' => 'form-control','rows'=>2]) !!}

                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 text-right">{{__('administrator.image')}}</label>
                <div class="col-sm-9">
                    <div class="input-group">
                        <input type="file" name="image">
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group formName row">
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <table class="table table-bordered">
                    <thead class="table-success">
                    <tr>
                        <th class="required"> {{__('administrator.unit')}}</th>
                        <th class="required"> {{__('administrator.item_code')}}</th>
                        <th class="required"> {{__('administrator.barcode')}}</th>
                        <th class="required"> {{__('administrator.net_cost')}}</th>
                        <th class="required"> {{__('administrator.price')}}</th>
                        <th width="5%" class="text-center text-light-blue"><i
                                    class="fa fa-plus text-green btn btn-default" title="Add"></i></th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(@$product_unit)
                        @foreach($product_unit as $key=>$row)
                            <tr>
                                <td>
                                    <div class="input-group">
                                        {!! Form::select('unit_id[]', getUnit(), $row->unit_id, ['class' => 'unit form-control select2', 'placeholder' => __('administrator.please_select') ])  !!}
                                        <span class="input-group-addon getHtmlForm"
                                              data-href="{{route('unit.create')}}?input_name=unit_id[]"
                                              data-name="Create Unit"><i class="fa fa-plus-circle text-blue"></i></span>
                                    </div>
                                </td>
                                <td>
                                    <input name="code[]" type="text" maxlength="15" class="code form-control"
                                           placeholder=" {{ __('administrator.code') }}" value="{{$row->item_code}}"
                                           autocomplete="off"/>
                                    <input name="product_unit_id[]" value="{{$row->id}}" type="hidden"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input name="barcode[]" type="text" maxlength="50" class="barcode form-control"
                                               placeholder="Barcode" autocomplete="off" value="{{$row->barcode}}"/>
                                        <span class="input-group-addon">
                                    <i class="fa fa-code"></i>
                                </span>
                                    </div>
                                </td>
                                <td>
                                    <input name="cost[]" type="text" maxlength="15" class="cost form-control numeric"
                                           value="{{$row->cost}}"
                                           placeholder="{{ __('administrator.cost') }}" autocomplete="off"/>
                                </td>
                                <td>
                                    <input name="price[]" type="text" maxlength="15" class="price form-control numeric"
                                           value="{{$row->retail_price}}"
                                           placeholder="{{ __('administrator.price') }}" autocomplete="off"/>
                                </td>
                                <td>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8 col-lg-offset-2 col-md-offset-2 text-right">
            @include('component.form-btn')
        </div>
    </fieldset>
</div>
@section('script')
    <script>
        $(document).ready(function () {
            @if(!@$product_unit)
            appendTbody();
            @endif

        });

        $(document).on('click', '.fa.fa-plus', function () {
            appendTbody();
        });

        $(document).on('click', '.fa.fa-code', function () {
            let e = $(this);
            setTimeout(function () {
                e.closest('.input-group').find('input[name="barcode[]"]').val(dateToNiceString());
            }, 500);
        });


        function appendTbody() {
            $('.formName tbody').append(`<tr>
            <td>
                <div class="input-group">
                        {!! Form::select('unit_id[]', getUnit(), null, ['class' => 'unit form-control select2', 'placeholder' => __('administrator.please_select') ])  !!}
            <span class="input-group-addon getHtmlForm"  data-href="{{route('unit.create')}}?input_name=unit_id" data-name="Create Unit"><i class="fa fa-plus-circle text-blue"></i></span>
                    </div>
            </td>
            <td>
                <input name="code[]" type="text" maxlength="50" class="code form-control" placeholder=" {{ __('administrator.code') }}" autocomplete="off"/>
                <input name="product_unit_id[]" value="0" type="hidden" />
            </td>
            <td>
                <div class="input-group">
                    <input name="barcode[]" type="text" maxlength="15" class="barcode form-control" placeholder="Barcode" autocomplete="off" value="${dateToNiceString()}"/>
                    <span class="input-group-addon">
                        <i class="fa fa-code"></i>
                    </span>
                </div>
            </td>
            <td>
                <input name="cost[]" type="text" maxlength="15" class="cost form-control numeric" placeholder="{{ __('administrator.cost') }}" autocomplete="off"/>
            </td>
            <td>
                <input name="price[]" type="text" maxlength="15" class="price form-control numeric" placeholder="{{ __('administrator.price') }}" autocomplete="off"/>
            </td>
            <td>
                <i class="fa fa-times text-red btn btn-default" onclick="$(this).closest('tr').remove();" title=" {{__('administrator.remove')}}"></i>
            </td>
        </tr>`).find('tr:last .select2').select2();
        }
    </script>

@endsection
