@extends(branchMenu())

@section('content')

<?php Fun::lang()?>

<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3 class="set_menu_name"></h3>
                        </div>
                        <div class="pull-right">
                            @can('Category Create')
                                <a class="btn btn-primary getHtmlForm set_menu_name fa fa-plus" data-href="{{route('category.create')}}" data-name="{{__('administrator.create')}}"></a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body">
                <table id="my-table" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.parent')}}</th>
                        <th>{{__('administrator.category')}}</th>
                        <th>{{__('administrator.description')}}</th>
                        <th>{{__('administrator.created_at')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
    let tb = $('#my-table');
    $(document).ready(function() {
        getTable();
        tb.on('click','.btn_delete',function (){
            let t = $(this);
            let name = t.closest('tr').find('td:nth-child(3)').text();
            confirmForm(t.data('href'),'<?php echo e(__('administrator.are_you_sure')); ?>', 'Category : '+name, 'danger', '500px', 'fa fa-trash', 'red');
        });
    });
    function getTable() {
        tb.DataTable().destroy();
        tb.DataTable({
            serverSide: true,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('category.index') }}",
            },
            columns:
                [
                    {data: 'DT_RowIndex',searchable:false},
                    {data: 'parent'},
                    {data: 'name'},
                    {data: 'note'},
                    {data: 'created_at'},
                    {data: 'action'},
                ],

        });

    }
</script>

@endsection







