@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>

    <style>
        .canvasjs-chart-credit {
            display: none;
        }

        .text_left {
            text-align: left !important;
        }

        .text_left span {
            display: inline-block;
            width: 80px;
        }

        input, select, textarea {
            color: #000000;
        }

        .col-md-7 .col-md-12 {
            border: 1px solid #ddc7c7;
        }

        #data_table td {
            text-align: center !important;
        }

        #data_table th {
            text-align: center !important;
        }
    </style>

    <div class="page box box-primary">
        <div class="container-fluid">
            <div class="container-fluid container-fullw bg-white ">
                <div id="edit1_panel" class="panel panel-white">
                    <div class="panel-heading">
                        <h4 class="panel-title  text-primary"><span
                                id="lblheaderupdate_bank">{{__('administrator.customer_info')}}</span></h4>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6 col-sm-6">
                                <div id="panel_overview" class="tab-pane">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="user-left">
                                                @php
                                                    $branch = findBranch($customer->branch_id);
                                                    $agent = findUser($customer->agent_id);
                                                    $province = \App\Model\location\ProvinceModel::where('id',$customer->province)->first();
                                                    $ill_text = '';
                                                    if($customer->type_illness){
                                                        $ill = \App\Models\TypeOfIllness::whereIn('id',json_decode($customer->type_illness))->pluck(if_kh()?'name_km':'name_en');
                                                        $ill_text = $ill->implode(', ');
                                                    }
                                                @endphp
                                                <fieldset style="padding: 15px">
                                                    <ul style="line-height: 30px">
                                                        <li>{{__('administrator.register_date')}}
                                                            : {{$customer->register_date}}</li>
                                                        <li>{{__('administrator.register_by')}}
                                                            : {{$agent?$agent->name:''}}</li>
                                                        @if($branch)
                                                            <li>{{__('administrator.branch')}}
                                                                : {{$branch?$branch->name:''}}</li>
                                                        @endif
                                                        <li>{{__('administrator.customer_name')}}
                                                            : {{$customer->customer_name}}</li>

                                                        <li>{{__('administrator.date_of_birth')}}
                                                            : {{$customer->date_of_birth?myDate($customer->date_of_birth):''}}</li>
                                                        <li>{{__('administrator.age')}}
                                                            : {{$customer->age??0}}</li>
                                                        <li>{{__('administrator.address')}}
                                                            : {{$customer->customer_address}}</li>
                                                        <li>{{__('administrator.district_or_city')}}
                                                            : {{$customer->district_or_city}}</li>
                                                        <li>{{__('administrator.province')}}
                                                            : {{$province?$province->name_kh:''}}</li>
                                                        <li>{{__('administrator.contact_number')}}
                                                            : {{$customer->customer_phone}}</li>
                                                        <li>{{__('administrator.type_of_customer')}}
                                                            : {{$customer->type_of_customer?getTypeOfCustomer($customer->type_of_customer):''}}
                                                            @if (!$customer->deleted_at)
                                                            <button type="button" class="btn btn-warning btn-xs btn_change_type">{{__('administrator.change')}}</button>
                                                            @endif
                                                        </li>
                                                        <li>{{__('administrator.customer_type')}}
                                                            : {{$customer->customer_type?customerType($customer->customer_type):''}}</li>
                                                        <li>{{__('administrator.type_of_illness')}}
                                                            : {{$ill_text}}</li>
                                                        <li>{{__('administrator.point_balance')}}
                                                            : {{$customer->points}}</li>
                                                        <li>{{__('administrator.used_points')}}
                                                            : <span class="use_point"></span></li>
                                                    </ul>
                                                    <div class="col-md-12 col-sm-12 col-xs-12"
                                                         style="border: 1px solid rgba(1,1,1,0.5); padding: 10px;background: rgba(1,1,1,0.1)">
                                                        @foreach($cus_img as $key=>$row)
                                                            <div class="col-md-3 col-sm-3 col-xs-3 " style="">
                                                                <img src="{{asset($row->image)}}" alt="IMG" width="100%"
                                                                     class="cursor show_image">
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </fieldset>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div id="panel_overview2" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <hr>
                                                <div class="user-left">
                                                    <h4><b><u>{{__('administrator.order_history')}}</u></b></h4>
                                                    <table id="data_table" width="100%"
                                                           class="table table-striped table-hover ​​ customize">
                                                        <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>{{__('administrator.invoice_number')}}</th>
                                                            <th>{{__('administrator.date')}}</th>
                                                            <th>{{__('administrator.using_point')}}</th>
                                                            <th>{{__('administrator.point')}}</th>
                                                            <th>{{__('administrator.point_balance')}}</th>
                                                            <th>{{__('administrator.total')}}</th>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                            <td></td>
                                                            <td>
                                                                <input type="text" class="form-control date_picker"
                                                                       placeholder="{{__('administrator.from_date')}}"
                                                                       name="from_date" autocomplete="off"
                                                                       style="width: 40% !important;">
                                                                <span style="width:5% !important;">  To   </span>
                                                                <input type="text" class="form-control date_picker"
                                                                       placeholder="{{__('administrator.to_date')}}"
                                                                       name="to_date" autocomplete="off"
                                                                       style="width:40% !important;">
                                                            </td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <td>
                                                                <i class="fa fa-times btn btn-sm btn-default"
                                                                   title="Clear"></i>
                                                            </td>
                                                        </tr>
                                                        </thead>
                                                        <tbody class="order-body">
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-6">
                                <div class="row">
                                    <div class="col-md-12 col-sm-12 col-xs-12"
                                         style="border: 1px solid rgba(1,1,1,0.5); padding: 10px;background: rgba(1,1,1,0.1)">
                                        <h4>{{ __('administrator.pos_request') }} {{__('administrator.reference_file')}}</h4>
                                        @foreach($po_file as $key=>$pf)
                                            @if($pf->reference)
                                                <div class="col-md-2 col-sm-2 col-xs-2" style="">
                                                    <img src="{{asset($pf->reference)}}" alt="IMG" width="100%"
                                                         class="cursor show_image">
                                                    <p style="font-size: 12px">
                                                        {{date('d-m-Y',strtotime($pf->purchase_date))}}<br>
                                                        <a class="show_request cursor"
                                                           onclick="getHtmlFormShow('{{route('get-maho-request-invoice',$pf->id)}}','500px')"><u>{{$pf->reference_number??$pf->invoice_number}}</u></a>
                                                    </p>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-6">
                                <div class="row">
                                    <div class="col-md-12 col-sm-12 col-xs-12"
                                         style="border: 1px solid rgba(1,1,1,0.5); padding: 10px;background: rgba(1,1,1,0.1)">
                                        <h4>{{ __('administrator.pos') }} {{__('administrator.reference_file')}}</h4>
                                        @foreach($sale_file as $key=>$sf)
                                            @if($sf->image)
                                                <div class="col-md-2 col-sm-2 col-xs-2"
                                                     style="margin: 3px;padding: 3px;border: 1px solid rgba(1,1,1,0.4)">
                                                    <img src="{{asset($sf->image)}}" alt="IMG" height="100px"
                                                         width="100%"
                                                         class="cursor show_image">
                                                    <p style="font-size: 12px">
                                                        {{date('d-m-Y',strtotime($sf->sale_date))}}<br>
                                                        <a class="show_request cursor"
                                                           onclick="getHtmlFormShow('{{route('get-maho-invoice',$sf->id)}}','500px')"><u>{{$sf->reference_number??$sf->invoice_number}}</u></a>
                                                    </p>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-6">
                                <br>
                            </div>
                            <div class="col-md-6 col-sm-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        {!! Form::open(array('route' => ['customer.history', $id],  'method'=> 'get', 'enctype'=>'multipart/form-data')) !!}
                                        <div class="alert alert-info ">
                                    <span id=""
                                          style="display:inline-block;width:80px;"> {{__('administrator.date')}}
                                        :</span>
                                            <input type="test" name="date" class="yearpicker" value="{{ @$year }}"
                                                   placeholder="{{ date('Y') }}">
                                            <button type="submit"
                                                    class="btn btn-primary pull  margin-bottom-5  margin-top-5 ">
                                                {{__('administrator.generate')}} <i class="fa fa-bar-chart-o"></i>
                                            </button>
                                            <br> <br>
                                        </div>
                                        {!! Form::close() !!}
                                    </div>
                                    <div class="col-md-12">
                                        <div id="RadHtmlChart_bymb" class="RadHtmlChart RadHtmlChart_Silk k-chart"
                                             style="height: 350px; width: 100%; position: relative;" data-role="chart">
                                            <div id="chartContainer1" style="height: 370px; width: 100%;"></div>
                                        </div>
                                    </div>
                                    <div class="col-md-12" style=" margin-top: 5%;">
                                        <div id="RadHtmlChart1" class="RadHtmlChart RadHtmlChart_Silk k-chart"
                                             style="height: 350px; width: 100%; position: relative;" data-role="chart">
                                            <div id="chartContainer" style="height: 370px; width: 100%;"></div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-12">
                                <br>
                                <hr>
                                <br>
                            </div>
                            <div class="col-md-6">
                                <h4><b><u>{{__('administrator.product_history')}}</u></b></h4>
                                <table id="data_table_product" class="table table-bordered table-hover ​​ ">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.invoice_number')}}</th>
                                        <th>{{__('administrator.product_name')}}</th>
                                        <th>{{__('administrator.qty')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h4><b><u>{{__('administrator.consultant_history')}}</u></b></h4>
                                <table id="data_table_consultant" width="100%"
                                       class="table table-bordered table-hover ​​ customize">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.date')}}</th>
                                        <th>{{__('administrator.doctor')}}</th>
                                        <th>{{__('administrator.illness_status')}}</th>
                                        <th>{{__('administrator.treatment_history')}}</th>
                                        <th>{{__('administrator.next_date')}}</th>
                                        <th>{{__('administrator.note')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($customer_case as $key=>$row)
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td>{{date('d-m-Y',strtotime($row->date))}}</td>
                                            <td>{{$row->reviewed_by}}</td>
                                            <td>{{$row->disease_status}}</td>
                                            <td>{{$row->treatment_history}}</td>
                                            <td>{{date('d-m-Y',strtotime($row->next_meeting))}}</td>
                                            <td>{{$row->note_next_meeting}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endsection
            @section('script')
                <script src="{{asset('assets/canvasjs/canvasjs.min.js')}}"></script>
                <script>
                    var record = 15;
                    var page = 1;
                    $(document).ready(function () {
                        dataTable();
                        data_table_consultant();
                        data_table_product();
                        $('.btn_change_type').on('click', function () {
                            getHtmlForm('{{route('customer-change-type-of-customer',$customer->id)}}', '{{__('administrator.customer_name').'  :  '.$customer->customer_name}}');
                        });
                        $(document).on('change', 'input[name="to_date"],input[name="from_date"]', function () {
                            page = 1;
                            dataTable();
                        });
                        $(document).on('click', '.show_image', function () {
                            let img = `<div class="text-center print_this_form"><img src="${$(this).attr('src')}" alt="IMG" class="cursor show_image "></div>`;
                            jalert(img, '1000px');
                        });
                        $(document).on('click', '.fa.fa-times', function () {
                            page = 1;
                            $('.form-control').val(null);
                            $('[name="to_date"]').val('');
                            $('[name="from_date"]').val('');
                            dataTable();
                        });
                        $(document).on('change', '.form-control.input-sm', function () {
                            record = $(this).val();
                            page = 1;
                            dataTable();
                        });
                        $(document).on('click', '.page-item', function () {
                            page = $('.page-item.active .page-link').text();
                            dataTable();

                        });
                    });

                    function dataTable() {
                        let to_date = $('[name="to_date"]').val();
                        let from_date = $('[name="from_date"]').val();
                        $('#data_table').DataTable().destroy();

                        $('#data_table').DataTable({
                            "oLanguage": {
                                "sSearch": "{{__('administrator.search')}}:",
                                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                                "oPaginate": {
                                    "sFirst": "{{__('administrator.first')}}",
                                    "sLast": "{{__('administrator.last')}}",
                                    "sNext": "{{__('administrator.next')}}",
                                    "sPrevious": "{{__('administrator.previous')}}"
                                },
                            },
                            serverSide: true,
                            ordering: false,
                            searching: false,
                            pageLength: record,
                            lengthMenu: tbLength,
                            ajax: {
                                url: "{{ $url }}",
                                data: {
                                    from_date,
                                    to_date,
                                    record,
                                    page
                                }
                            },
                            columns:
                                [
                                    {data: 'DT_RowIndex'},
                                    {data: 'reference_number'},
                                    {data: 'date'},
                                    {data: 'using_point'},
                                    {data: 'points'},
                                    {data: 'balance_point'},
                                    {data: 'total'},
                                ],
                            "initComplete": function (settings, json) {
                                $('select[name="data_table_length"]').val(json.records);
                                $('.dataTables_paginate').empty();
                                $('#data_table_paginate').twbsPagination('destroy');
                                $('#data_table_paginate').twbsPagination({
                                    totalPages: json.totalPage,
                                    visiblePages: 5,
                                    startPage: parseInt(json.activePage),
                                    next: 'Next',
                                    prev: 'Prev',
                                    onPageClick: function (event, pageD) {
                                    }
                                });

                                let table = $('.order-body tr');
                                let use_point = 0;
                                $.each(table, function (ii, vv) {
                                    let point = $(this).find('td:nth-child(4)').text();
                                    point = point ? parseFloat(point) : 0;
                                    use_point += point;
                                });
                                $('.use_point').text(use_point);
                            }
                        });
                    }

                    $(document).ready(function () {
                        $(".yearpicker").datepicker({
                            format: "yyyy",
                            viewMode: "years",
                            minViewMode: "years"
                        });
                    });
                    window.onload = function () {
                        var chart1 = new CanvasJS.Chart("chartContainer1", {
                            title: {
                                text: "{{__('administrator.monthly_product')}}"
                            },
                            axisX: {
                                valueFormatString: "MMM YYYY"
                            },
                            axisY2: {
                                title: "",
                                prefix: "$",
                                suffix: "K"
                            },
                            toolTip: {
                                shared: true
                            },
                            legend: {
                                cursor: "pointer",
                                verticalAlign: "top",
                                horizontalAlign: "center",
                                dockInsidePlotArea: true,
                                itemclick: toogleDataSeries
                            },
                            data: [
                                    @foreach ($array1 as $key=>$item)
                                {
                                    type: "line",
                                    axisYType: "secondary",
                                    name: "{{ $key }}",
                                    showInLegend: true,
                                    markerSize: 0,
                                    yValueFormatString: "$#,###",
                                    dataPoints: [
                                            @foreach ($item as $data_key=>$data_item)
                                        {
                                            x: new Date({{  $data_item['date_x'] }}), y: {{ $data_item['date_Y'] }} },
                                        @endforeach
                                    ]
                                },
                                @endforeach


                            ]
                        });
                        chart1.render();

                        function toogleDataSeries(e) {
                            if (typeof (e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
                                e.dataSeries.visible = false;
                            } else {
                                e.dataSeries.visible = true;
                            }
                            chart1.render();
                        }

                        var chart = new CanvasJS.Chart("chartContainer", {
                            animationEnabled: true,
                            theme: "light2",
                            title: {
                                text: "{{__('administrator.monthly_price')}}"
                            },
                            axisY: {
                                includeZero: true
                            },
                            legend: {
                                cursor: "pointer",
                                verticalAlign: "center",
                                horizontalAlign: "right",
                                itemclick: toggleDataSeries
                            },
                            data: [
                                    @foreach ($array as $key=>$item)
                                {
                                    type: "column",
                                    name: "{{ $key }}",
                                    indexLabel: "{y}",
                                    yValueFormatString: "#0.##",
                                    showInLegend: true,
                                    dataPoints: <?php echo json_encode($item, JSON_NUMERIC_CHECK); ?>
                                },
                                @endforeach
                            ]
                        });
                        chart.render();

                        function toggleDataSeries(e) {
                            if (typeof (e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
                                e.dataSeries.visible = false;
                            } else {
                                e.dataSeries.visible = true;
                            }
                            chart.render();
                        }
                    }

                    function data_table_consultant() {
                        $('#data_table_consultant').DataTable().destroy();
                        $('#data_table_consultant').DataTable({
                            "oLanguage": {
                                "sSearch": "{{__('administrator.search')}}:",
                                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                                "oPaginate": {
                                    "sFirst": "{{__('administrator.first')}}",
                                    "sLast": "{{__('administrator.last')}}",
                                    "sNext": "{{__('administrator.next')}}",
                                    "sPrevious": "{{__('administrator.previous')}}"
                                },
                            },
                            searching: false,
                        });
                    }

                    function data_table_product() {
                        $('#data_table_product').DataTable().destroy();
                        $('#data_table_product').DataTable({
                            "oLanguage": {
                                "sSearch": "{{__('administrator.search')}}:",
                                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                                "oPaginate": {
                                    "sFirst": "{{__('administrator.first')}}",
                                    "sLast": "{{__('administrator.last')}}",
                                    "sNext": "{{__('administrator.next')}}",
                                    "sPrevious": "{{__('administrator.previous')}}"
                                },
                            },
                            serverSide: true,
                            ordering: false,
                            searching: false,
                            lengthMenu: tbLength,
                            ajax: {
                                url: "{{ $url_product }}",
                                data: {}
                            },
                            columns:
                                [
                                    {data: 'DT_RowIndex'},
                                    {data: 'reference_number'},
                                    {data: 'product_name'},
                                    {data: 'total_qty'},
                                ],
                            "initComplete": function (settings, json) {

                            }
                        });
                    }
                </script>
@endsection






