<?php Fun::lang() ?>
@csrf

<div class="master-form">
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label class="required" for="name">{{__('administrator.register_date')}} </label>
        </div>
        <div class="col-sm-9">
            {!! Form::text('register_date', @$customer?date('d-m-Y',strtotime($customer->register_date)):date('d-m-Y'), array('placeholder' => __('administrator.register_date'),'class' => 'form-control date date_picker ')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label class="required" for="name">{{__('administrator.customer_name')}} </label>
        </div>
        <div class="col-sm-9">
            {!! Form::text('customer_name', @$customer?$customer->customer_name:'', array('placeholder' => __('administrator.name'),'class' => 'form-control focus')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12 ">
        <div class="col-sm-3 col-xs-12 ">
            <label class="required" for="name">{{__('administrator.gender')}}</label>
        </div>
        <div class="col-sm-9">
            {!! Form::select('sex',getGender(),@$customer?$customer->sex:'', ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.date_of_birth')}} </label>
        </div>
        <div class="col-sm-9">
            {!! Form::text('date_of_birth', @$customer?date('d-m-Y',strtotime($customer->date_of_birth)):'', array('placeholder'=>__('administrator.date_of_birth'),'class' => 'form-control date date_picker','autocomplete'=>'off')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label for="name">{{__('administrator.age')}}</label>
        </div>
        <div class="col-sm-9 col-xs-12">
            {!! Form::text('age', @$customer?$customer->age:'', array('placeholder' => __('administrator.age'),'class' => 'form-control')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label for="name">{{__('administrator.customer_phone')}}</label>
        </div>
        <div class="col-sm-9 col-xs-12">
            {!! Form::text('customer_phone', @$customer?$customer->customer_phone:'', array('placeholder' => __('administrator.customer_phone'),'class' => 'form-control')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label class="" for="name">{{__('administrator.email')}}</label>
        </div>
        <div class="col-sm-9 col-xs-12">
            {!! Form::email('customer_email', @$customer?$customer->customer_email:'', array('placeholder' => __('administrator.email'),'class' => 'form-control','')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.address')}}</label>
        </div>
        <div class="col-sm-9 col-xs-12">
            {!! Form::text('address', @$customer?$customer->customer_address:'', array('placeholder' => __('administrator.address'),'class' => 'form-control no-resize','rows'=>'5','maxlength'=>'200')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.district_or_city')}}</label>
        </div>
        <div class="col-sm-9 col-xs-12">
            {!! Form::text('district_or_city', @$customer?$customer->district_or_city:'', array('placeholder' => __('administrator.district_or_city'),'class' => 'form-control no-resize','rows'=>'5','maxlength'=>'200')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.province')}}</label>
        </div>
        <div class="col-sm-9 col-xs-12">
            {!! Form::select('province',$province, @$customer?$customer->province:'',array('placeholder' => __('administrator.please_select'),'class' => 'form-control no-resize select2')) !!}
        </div>
    </div>
    {!! Form::hidden('member_type', request()->member_type) !!}


    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.known_this_from')}}</label>
        </div>
        <div class="col-sm-9">
            {!! Form::select('known_this_from', know_product_from(), @$customer?$customer->known_this_from:'', ['placeholder' =>  __('administrator.please_select') ,'class' => 'form-control select2']) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.known_product_by')}}</label>
        </div>
        <div class="col-sm-9">
            {!! Form::text('known_product_by',null, ['placeholder' =>  __('administrator.known_product_by') ,'class' => 'form-control']) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label for="name" class="required">{{__('administrator.contact_by')}}</label>
        </div>
        <div class="col-sm-9">
            {!! Form::select('contact_by', contact_by(), @$customer?$customer->contact_by:'', ['placeholder' =>  __('administrator.please_select') ,'class' => 'form-control select2']) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.type_of_illness')}}</label>
        </div>
        <div class="col-sm-9">
            {!! Form::select('type_of_illness[]', $illness_types,@$cust_ill?:null, ['class' => 'form-control select2','multiple']) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label>{{__('administrator.illness_status')}}</label>
        </div>
        <div class="col-sm-9">
            {!! Form::text('illness_status', @$customer->illness_status??null, ['class' => 'form-control']) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 ">
            <label class="" for="name">{{__('administrator.customer_note')}}</label>
        </div>
        <div class="col-sm-9 col-xs-12">
            {!! Form::textarea('customer_note',@$customer?$customer->customer_note:'', array('placeholder' => __('administrator.customer_note'),'class' => 'form-control no-resize','rows'=>'3','maxlength'=>'200')) !!}
        </div>
    </div>
    <div class="form-group col-sm-12 col-xs-12">
        <div class="col-sm-3 col-xs-12 text-right">
        </div>
        <div class="col-sm-9 col-xs-12 ">
            <table class="table table_image">
                @if(@$cus_image)
                    @foreach($cus_image as $key=>$row)
                        <tr>
                            <td>
                                <input type="hidden" value="{{$row->id}}" name="image_id[{{$key}}]">
                                <input type="file" name="image[{{$key}}]" class="onchange-image">
                                <input type="hidden" value="0" name="if_change[{{$key}}]" class="if-change">
                            </td>
                            <td><img class="show-image" alt="your image" width="100" height="100"
                                     src="{{asset($row->image)}}"/></td>
                            <td class="text-center" style="padding: 4px">
                                @if($key==0)
                                    <button type="button" class="btn_add_img btn btn-success"><i class="fa fa-plus"></i></button>
                                @else
                                    <button type="button" class=" btn btn-danger btn_remove "><i class="fa fa-times"></i></button>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                @endif
                @if(@!$cus_image || $cus_image->count()===0)
                    <tr>
                        <td>
                            <input type="hidden" value="0" name="image_id[0]">
                            <input type="hidden" value="0" name="if_change[0]" class="if-change">
                            <input type="file" name="image[0]" class="onchange-image" onchange=""></td>
                        <td><img class="show-image" alt="your image" width="100" height="100"/></td>
                        <td>
                            <button type="button" class="btn_add_img btn btn-success"><i class="fa fa-plus"></i>
                            </button>
                        </td>
                    </tr>
                @endif
            </table>
        </div>
    </div>
    {!! Form::hidden('input_name',request('input_name')) !!}
    {!! Form::submit($button_text, ['class' => 'form-control btn btn-primary submit_ display-none' ]) !!}
</div>

@section('jq')
    <script>
        var count_image = parseFloat({{@$cus_image?($cus_image->count()-1):0}});
        $(document).ready(function (e) {
            $('.table_image').on('change', '.onchange-image', function () {
                $(this).closest('tr').find('.show-image').attr('src', window.URL.createObjectURL(this.files[0]));
                $(this).closest('tr').find('.if-change').val(1);
                scroll_bottom();
            });
            $('.table_image').on('click', '.btn_remove', function () {
                $(this).closest('tr').remove();
                scroll_bottom();
            });
            $('.btn_add_img').on('click', function (e) {
                count_image++;
                $('.table_image').append(`
                <tr>
                    <td>
                    <input type="hidden" value="0" name="image_id[${count_image}]">
                    <input type="file" name="image[${count_image}]" class="onchange-image"></td>
                    <input type="hidden" value="0" name="if_change[${count_image}]" class="if-change">
                    <td><img class="show-image"  alt="your image" width="100" height="100"  /></td>
                    <td class="text-center" style="padding: 4px"><button type="button" class=" btn btn-danger btn_remove "><i class="fa fa-times"></i></button></td>
                </tr>`);
                scroll_bottom();
            });
        });

        $(document).on('change', 'input[name=date_of_birth]', function () {
            let dob = $(this).val().split('-');
            dob = dob[1]+'-'+dob[0]+'-'+dob[2];
            dob = new Date(dob);
            let today = new Date();
            let age = Math.floor((today - dob) / (365.25 * 24 * 60 * 60 * 1000));
            $('.master-form input[name=age]').val(age);
        });

        function scroll_bottom() {
            setTimeout(function () {
                $("div").scrollTop(1000);
            }, 100);
        }
    </script>

@endsection



