
<?php

?>
<!DOCTYPE HTML>
<html>
<head>
    <script>
    window.onload = function () {

        console.log( new Date(2020, 11, 23));
        console.log(   Date());
        var chart1 = new CanvasJS.Chart("chartContainer1", {
            title: {
                text: "Product Price"
            },
            axisX: {
                valueFormatString: "MMM YYYY"
            },
            axisY2: {
                title: "",
                prefix: "$",
                suffix: "K"
            },
            toolTip: {
                shared: true
            },
            legend: {
                cursor: "pointer",
                verticalAlign: "top",
                horizontalAlign: "center",
                dockInsidePlotArea: true,
                itemclick: toogleDataSeries
            },
            data: [
                @foreach ($array1 as $key=>$item)
                {
                    type:"line",
                    axisYType: "secondary",
                    name: "{{ $key }}",
                    showInLegend: true,
                    markerSize: 0,
                    yValueFormatString:  "$#,###",
                    dataPoints: [
                        @foreach ($item as $data_key=>$data_item)
                            { x: new Date({{  $data_item['date_x'] }}), y: {{ $data_item['date_Y'] }} },
                        @endforeach
                    ]
                },
                @endforeach


            ]
        });
        chart1.render();
        function toogleDataSeries(e){
            if (typeof(e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
                e.dataSeries.visible = false;
            } else{
                e.dataSeries.visible = true;
            }
            chart1.render();
        }
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            theme: "light2",
            title:{
                text: "Average Amount Spent on Real and Artificial X-Mas Trees in U.S."
            },
            axisY:{
                includeZero: true
            },
            legend:{
                cursor: "pointer",
                verticalAlign: "center",
                horizontalAlign: "right",
                itemclick: toggleDataSeries
            },
            data: [
            @foreach ($array as $key=>$item)
                {
                    type: "column",
                    name: "{{ $key }}",
                    indexLabel: "{y}",
                    yValueFormatString: "#0.##",
                    showInLegend: true,
                    dataPoints: <?php echo json_encode($item, JSON_NUMERIC_CHECK); ?>
                },
            @endforeach
            ]
        });
        chart.render();

        function toggleDataSeries(e){
            if (typeof(e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
                e.dataSeries.visible = false;
            }
            else{
                e.dataSeries.visible = true;
            }
            chart.render();
        }
        }

    </script>
    </head>
<body>

<div id="chartContainer1" style="height: 370px; width: 100%;"></div>
<br>
<br>
<br>
<div id="chartContainer" style="height: 370px; width: 100%;"></div>

<script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>

</body>
</html>
