<?php Fun::lang() ?>
@extends(branchMenu())
@section('content')
    <div class="page">

        <div class="top-content">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>Create Account Chart</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-xs-12">

                <div class="form-wrapper">
                    {!! Form::open(array('route' => 'account-chart.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'jform')) !!}

                    <div class="form-group row">
                        <div class="col-sm-4 col-12">
                            <label class="required">Account Type</label>
                            {!! Form::select('account_type', $account_type, null, ['class' => 'form-control select2']) !!}
                        </div>
                        <div class="col-sm-4 col-12">
                            <label class="required">Main Account</label>
                            <select class="form-control select2" name="main_account"></select>
                        </div>
                        <div class="col-sm-4 col-12">
                            <label><input type="checkbox" class="form-check-input acc-check" id="acc-check" name="check" value="sub">Sub Account Of </label>
{{--                            <label> <input type="radio" class="acc-check" name="check" value="payment"> Payment Method</label>--}}
                            <select class="form-control select2" name="sub_account" disabled="disabled"></select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-4 col-12">
                            <label>Account Number </label>
                            <input type="text" class="form-control number-only" name="acc_num" readonly>
                        </div>
                        <div class="col-sm-4 col-xs-12">
                            <label class="required">Sub Account Name Khmer</label>
                            {!! Form::text('acc_name_kh', null, array('placeholder' => 'Account Name Khmer','class' => 'form-control')) !!}
                        </div>
                        <div class="col-sm-4 col-xs-12 ">
                            <label class="required">Sub Account Name English</label>
                            {!! Form::text('acc_name_en', null, array('placeholder' => 'Account Name English','class' => 'form-control')) !!}
                        </div>

                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12 col-xs-12 ">
                            <label>Description</label>
                            {!! Form::textarea('acc_des', null, array('placeholder' => __('Description'),'class' => 'form-control','rows'=>'3')) !!}
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12 col-xs-12 text-right">
                            <div class="form-group">
                               @include('component.form-btn')
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).on('change', 'select[name=account_type],select[name=main_account],select[name=sub_account]', function () {
            let account_type = $('select[name=account_type]').val();
            let main_account = $('select[name=main_account]').val();
            let sub_account = $('select[name=sub_account]').val();
            let this_name = $(this).attr('name');
            if (this_name === 'account_type'){ // if select parent clear child
                main_account = '';
                sub_account = '';
            }else{
                if (this_name === 'main_account'){
                    sub_account = '';
                }
            }
            $.get('{{route('get-account-code')}}',{account_type,main_account,sub_account,no_branch:1},function (res) {
                let select = '<option value="">Please Select</option>';
                if(!main_account){
                    $.each(res['main_account'], function (i, val) {
                        select+='<option value="' + i + '">' + i + " | " + val + '</option>';
                    });
                    $('select[name=main_account]').html(select);
                }
                if(!sub_account){
                    $.each(res['sub_account'], function (i, val) {
                        select+='<option value="' + i + '">' + i + " | " + val + '</option>';
                    });
                    $('select[name=sub_account]').html(select);
                }
                $('input[name=acc_num]').val(res['number']);

            });
        });
        $('.acc-check').on('click', function () {
            let select = $('select[name=sub_account]');
            let ch = ($(this).prop('checked'));
            if (ch === true) {
                select.removeAttr('disabled');
                select.prop('required');
            } else {
                select.val(1).trigger('change.select2');
                select.prop('disabled', true);
            }
        });
    </script>
@endsection
