<?php


    namespace App\Model\stock_inventory;

    use Illuminate\Database\Eloquent\Model;

    class ItemRequestModel extends Model
    {
        protected $table = "nso007_item_request";

        protected $fillable = [
            'id',
            'member_id',
            'member_shelf',
            'delivery_to_member',
            'member_purchase_id',
            'branch_id',
            'request_to',
            'request_to_type',
            'approve_by',
            'reference_number',
            'request_date',
            'approve_date',
            'year',
            'note',
            'status',
            'confirm_status',
            'type',
            'created_at',
            'updated_at',
        ];

        public function detail()
        {
            return $this->hasMany(ItemRequestDetailModel::class,'request_id');
        }
    }
