<?php

    namespace App\Model\stock_inventory;

    use App\Model\product\ColorModel;
    use App\Model\product\SizeModel;
    use App\Model\product\UnitModel;
    use Illuminate\Database\Eloquent\Model;

    class ItemRequestDetailModel extends Model
    {
        protected $table = "nso007_item_request_detail";

        protected $fillable = [
            'id',
            'request_id',
            'product_unit_id',
            'unit_id',
            'shelf',
            'qty',
            'created_at',
            'updated_at',

        ];

        public function getItem()
        {
            return $this->belongsTo(ProductModel::class, 'product_id');
        }
        public function getUnit()
        {
            return $this->belongsTo(UnitModel::class, 'unit_id');
        }
    }
