<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class WarehouseModel extends Model
{
    protected $table = "nso007_warehouse";

    protected $fillable = [
        'main',
        'status',
        'warehouse_name',
        'location_name',
        'description',
        'branch_id',
        'user_id',
    ];

    public function getFullNameAttribute()
    {
        return $this->warehouse_name . ' ( ' . $this->location_name.' )';
    }

    public function branch()
    {
        return $this->belongsTo('App\Model\Hr\HrBranch', 'branch_id');
    }
}
