<?php


    namespace App\Model;


    use App\Model\production\cutting\CuttingDetailModel;
    use App\Model\production\cutting\CuttingReturnDetailModel;
    use App\Model\production\ProductionDoneDetailModel;
    use App\Model\production\ProductionDoneModel;
    use App\Model\production\ProductionRequestDetailModel;
    use App\Model\production\ProductionRequestMaterialModel;
    use App\Model\production\ProductionRequestProductModel;
    use App\Model\purchase_order\PurchaseOrderDetailModel;
    use Illuminate\Database\Eloquent\Model;

    use App\Model\WarehouseModel;

    use App\Model\Pro;

    use App\Model\SaleDetailsModel;

    use App\Model\ProductUnitModel;

    use App\Model\PurchaseDetailsModel;


    class StockModel extends Model

    {
        protected $table = "nso007_stocks";

        protected $fillable = [
            'id',
            'branch_id',
            'product_id',
            'product_unit_id',
            'item_code',
            'member_id',
            'shelf',
            'expire_date',
            'stock_qty',
            'type',
            'created_at',
            'updated_at'
        ];

        public function warehouse_name()

        {
            $data = WarehouseModel::find($this->warehouse_id);
            return $data ? $data->warehouse_name : 'NAN';
        }

        public function production_qty()
        {
            $product = ProductionDoneDetailModel::selectRaw('SUM(nso007_production_done_detail.qty) as production_qty')
                ->join('nso007_production_done', 'nso007_production_done.id', 'nso007_production_done_detail.production_done_id')
                ->where([
                    'nso007_production_done.warehouse_id' => $this->warehouse_id,
                    'nso007_production_done_detail.barcode' => $this->barcode,
                ])->first();
            $unit = findProductUnitByCode($this->barcode, 'product');
            if ($unit) {
                $unit = findUnit($unit->unit_id);
            }
            $product = ($product ? $product->production_qty : 0);
            return $product . ' ' . ($product > 0 ? ($unit ? $unit->unit : '') : '');
        }

        public function production_out()
        {
            $qty = 0;
            $material = ProductionRequestDetailModel::select(
                'nso007_production_request_detail.qty',
                'nso007_production_request_detail.unit_id',
                'nso007_production_request_detail.material_id'
            )
                ->join('nso007_production_request', 'nso007_production_request.id', 'nso007_production_request_detail.production_id')
                ->where([
                    'nso007_production_request.warehouse_id' => $this->warehouse_id,
                    'nso007_production_request_detail.material_id' => $this->product_id,
                    'nso007_production_request_detail.type' => 'material',
                    'nso007_production_request.status' => 1,
                ])
                ->get();
            $store = '';
            foreach ($material as $row) {
                $material_unit = ProductUnitModel::where(['product_id' => $row->material_id, 'unit_id' => $row->unit_id])->first();
                $qty_per_unit = 1;
                if ($material_unit->type == 'parent') {
                    $qty_per_unit = findChildProductUnit($row->material_id);
                    if ($qty_per_unit) {
                        $qty_per_unit = $qty_per_unit->qty_per_unit;
                    }
                }
                $qty += $row->qty * $qty_per_unit;
            }
            $child_unit = findChildProductUnit($this->product_id);
            $child_unit = $child_unit ? $child_unit->qty_per_unit : 1;
            $parent = $qty % $child_unit;
            $child = intval($qty / $child_unit);

            $unit_p = findParentProductUnit($this->product_id);
            $unit_c = findChildProductUnit($this->product_id);
            if ($unit_p) {
                $parent = ($parent > 0 ? ($parent . ' ' . findUnit($unit_p->unit_id)->unit) : '');
            }
            if ($unit_c) {
                $child = ($child > 0 ? ($child . ' ' . findUnit($unit_c->unit_id)->unit) : '');
            }
            if ($parent > 0 && $child > 0) {
                $store = ' , ';
            }
            return $parent . $store . ($child ? $child : '');
        }

        public function return_stock()
        {
            $sale = \DB::table('nso007_sales')
                ->join('nso007_sale_details', 'nso007_sales.id', 'nso007_sale_details.sale_id')
                ->join('nso007_products', 'nso007_sale_details.product_id', 'nso007_products.id')
                ->where('nso007_sales.warehouse_id', $this->warehouse_id)
                ->Where('nso007_sale_details.product_id', $this->product_id)
                ->Where('nso007_sales.return_status', 1)
                ->selectRaw('sum(nso007_sale_details.qty) as out_qty, nso007_sale_details.unit_id, nso007_products.id as pro_id')
                ->groupBy('nso007_sale_details.unit_id')
                ->get();
            $parent_qty = 0;
            $child_qty = 0;
            $store = '';
            foreach ($sale as $row) {
                $unit = ProductUnitModel::where('unit_id', $row->unit_id)->where('product_id', $row->pro_id)->first();
                if ($unit != null) {
                    if ($unit->parent == 1) {
                        $parent_qty = $row->out_qty . ' ' . $unit->unit_name;
                    } else {
                        $child_qty = $row->out_qty . ' ' . $unit->unit_name;
                    }
                }
                if ($parent_qty > 0 && $child_qty > 0) {
                    $store = ' , ';
                }
            }
            return ($parent_qty != 0 ? $parent_qty : '') . $store . ($child_qty != 0 ? $child_qty : '');
        }

        public function out_stock()

        {
            $sale = \DB::table('nso007_sales')
                ->join('nso007_sale_details', 'nso007_sales.id', 'nso007_sale_details.sale_id')
                ->where('nso007_sales.status', 1)
                ->where('nso007_sales.warehouse_id', $this->warehouse_id)
                ->where('nso007_sale_details.product_id', $this->product_id)
                ->where('nso007_sale_details.color_id', $this->color_id)
                ->where('nso007_sale_details.size_id', $this->size_id)
                ->selectRaw('sum(nso007_sale_details.qty) as out_qty, nso007_sale_details.unit_id, nso007_sale_details.product_id as pro_id')
                ->groupBy('nso007_sale_details.unit_id')
                ->get();
            $parent_qty = 0;
            $child_qty = 0;
            $store = '';
            foreach ($sale as $row) {
                $unit = ProductUnitModel::where('unit_id', $row->unit_id)->where('product_id', $row->pro_id)->first();
                if ($unit != null) {
                    $parent_qty = $row->out_qty . ' ' . findUnit($unit->unit_id)->unit;
                }
                if ($parent_qty > 0 && $child_qty > 0) {

                    $store = ' , ';
                }
            }
            return ($parent_qty != 0 ? $parent_qty : '') . $store . ($child_qty != 0 ? $child_qty : '');
        }

        public function in_stock()
        {
            if ($this->type != 'cut_piece') {
                $code = $this->barcode;
                $product_id = $this->product_id;
                $qty_per_unit = 1;
                $qty = 0;
                $purchase_child = PurchaseDetailsModel::selectRaw('nso007_purchase_details.*')
                    ->join('nso007_purchases', 'nso007_purchase_details.purchase_id', 'nso007_purchases.id')
                    ->where('nso007_purchases.warehouse_id', $this->warehouse_id)
                    ->where('nso007_purchase_details.barcode', $this->barcode)
                    ->get();
                foreach ($purchase_child as $row) {
                    $product_unit = findProductUnitByCode($this->barcode);
                    if ($product_unit) {
                        if ($product_unit->type == 'parent') {
                            $child = findChildProductUnit($product_unit->product_id);
                            if ($this->type == 'fabric') {
                                $child = findProductUnitByCode($code);
                            }
                            $qty_per_unit = $child ? $child->qty_per_unit : 1;
                            $qty += $row->qty * $qty_per_unit;
                        } else {
                            if ($this->type == 'fabric') {
                                $child = findProductUnitByCode($code);
                                $qty_per_unit = $child ? $child->qty_per_unit : 1;
                                $qty += $row->qty * $qty_per_unit;
                            } else {
                                $qty += $row->qty;
                            }
                        }
                    }
                }
                if ($this->type == 'product') {
                    $product_unit_parent = findProductUnitByCode($code);
                    $product_unit_child = $product_unit_parent;
                    $qty_per_unit = 1;
                }
                if ($this->type == 'fabric') {
                    $product_unit_parent = ProductModel::find($product_id);
                    $product_unit_child = $product_unit_parent;
                    $child_unit_tb = findProductUnitByCode($code);
                    $qty_per_unit = ($child_unit_tb != null ? $child_unit_tb->qty_per_unit : 1);
                    $child_unit = ($product_unit_child != null ? findUnit($product_unit_child->child_unit)->unit : '');
                } else {
                    $child_unit = ($product_unit_child != null ? findUnit($product_unit_child->unit_id)->unit : '');
                }

                $parent_unit = ($product_unit_parent != null ? findUnit($product_unit_parent->unit_id)->unit : '');

                $child_qty = $qty_per_unit ? ($qty % $qty_per_unit) : ($qty);

                $parent_qty = intval($qty_per_unit > 0 ? ($qty / $qty_per_unit) : ($qty));

                $child_qty = $child_qty > 0 ? $child_qty : 0;
                $child = ($child_qty > 0 ? $child_qty . ' ' . $child_unit : '');
                return ($parent_qty > 0 ? ($parent_qty . ' ' . $parent_unit) : '') . ($parent_qty > 0 && $child_qty > 0 ? ' , ' : '') . $child . ($parent_qty == 0 && $child_qty == 0 ? '0' : '');
            } else {
                return '';
            }

        }

        public function in_stock_material()
        {
            $purchase_child = PurchaseDetailsModel::selectRaw('nso007_purchase_details.*')
                ->join('nso007_purchases', 'nso007_purchase_details.purchase_id', 'nso007_purchases.id')
                ->where('nso007_purchases.warehouse_id', $this->warehouse_id)
                ->where('nso007_purchase_details.product_id', $this->product_id)
                ->where('nso007_purchases.type', 'material')
                ->get();
            $qty = 0;

            foreach ($purchase_child as $row) {
                $product_unit = ProductUnitModel::where('product_id', $row->product_id)
                    ->where('unit_id', $row->unit_id)
                    ->first();
                if ($product_unit) {
                    if ($product_unit->type == 'parent') {
                        $child = findChildProductUnit($row->product_id);
                        $qty_per_unit = $child ? $child->qty_per_unit : 1;
                        $qty += $row->qty * $qty_per_unit;
                    } else {
                        $qty += $row->qty;
                    }
                } else {
                    $qty += $row->qty;
                }
            }
            $qty_per_unit = findChildProductUnit($this->product_id);
            $parent_unit = findParentProductUnit($this->product_id);

            $c_unit = $qty_per_unit ? $qty_per_unit->unit_id : 0;
            $p_unit = $parent_unit ? $parent_unit->unit_id : 0;
            $c_unit = findUnit($c_unit) ? findUnit($c_unit)->unit : '';
            $p_unit = findUnit($p_unit) ? findUnit($p_unit)->unit : '';
            $qty_per_unit = $qty_per_unit ? $qty_per_unit->qty_per_unit : 1;
            $child_qty = $qty_per_unit > 0 ? ($qty % $qty_per_unit) : ($qty);
            $parent_qty = intval($qty_per_unit > 0 ? ($qty / $qty_per_unit) : ($qty));

            return ($parent_qty > 0 ? ($parent_qty . ' ' . $p_unit) : '') . ($parent_qty > 0 && $child_qty > 0 ? ' , ' : '') . ($child_qty > 0 ? ($child_qty . ' ' . $c_unit) : '');

        }

        public function balance_qty()

        {
            if ($this->type != 'cut_piece') {
                $code = $this->barcode;
                $product_id = $this->product_id;
                $qty_per_unit = 1;
                if ($this->type == 'material') {
                    $product_unit_child = findChildProductUnit($this->product_id);
                    $product_unit_parent = findParentProductUnit($this->product_id);
                    $qty_per_unit = ($product_unit_child != null ? $product_unit_child->qty_per_unit : 1);
                }
                if ($this->type == 'product') {
                    $product_unit_parent = findProductUnitByCode($code);
                    $product_unit_child = $product_unit_parent;
                    $qty_per_unit = 1;
                }
                if ($this->type == 'fabric') {
                    $product_unit_parent = ProductModel::find($product_id);
                    $product_unit_child = $product_unit_parent;
                    $child_unit_tb = findProductUnitByCode($code);
                    $qty_per_unit = ($child_unit_tb != null ? $child_unit_tb->qty_per_unit : 1);
                    $child_unit = ($product_unit_child != null ? findUnit($product_unit_child->child_unit)->unit : '');
                } else {
                    $child_unit = ($product_unit_child != null ? findUnit($product_unit_child->unit_id)->unit : '');
                }

                $parent_unit = ($product_unit_parent != null ? findUnit($product_unit_parent->unit_id)->unit : '');

                $child_qty = $qty_per_unit ? ($this->stock_qty % $qty_per_unit) : ($this->stock_qty);

                $parent_qty = intval($qty_per_unit > 0 ? ($this->stock_qty / $qty_per_unit) : ($this->stock_qty));

                $child_qty = $child_qty > 0 ? $child_qty : 0;
                $child = ($child_qty > 0 ? $child_qty . ' ' . $child_unit : '');
                return ($parent_qty > 0 ? ($parent_qty . ' ' . $parent_unit) : '') . ($parent_qty > 0 && $child_qty > 0 ? ' , ' : '') . $child . ($parent_qty == 0 && $child_qty == 0 ? '0' : '');
            } else {
                return $this->stock_qty . ' Piece';
            }
        }

        public function cutting()
        {
            $detail = CuttingDetailModel::selectRaw('SUM(qty) as cutting_qty')
                ->join('nso007_production_cutting', 'nso007_production_cutting.id', 'nso007_production_cutting_detail.cutting_id')
                ->where('nso007_production_cutting.status', 1)
                ->where('nso007_production_cutting.from_warehouse', $this->warehouse_id)
                ->where('nso007_production_cutting_detail.barcode', $this->barcode)
                ->where('nso007_production_cutting_detail.fabric_id', $this->product_id)
                ->where('nso007_production_cutting_detail.type', 'fabric')->first();
            $unit = getProductById($this->product_id);
            $unit = findUnit($unit->unit_id);
            if ($detail->cutting_qty > 0) {
                return $detail->cutting_qty . ' ' . ($unit ? $unit->unit : '');
            }
        }

        public function cutting_qty()
        {
            $cut_qty = CuttingReturnDetailModel::selectRaw('SUM(nso007_production_cutting_return_item_detail.qty) as cut_qty')
                ->join('nso007_production_cutting_return_item', 'nso007_production_cutting_return_item.id', 'nso007_production_cutting_return_item_detail.cutting_return_id')
                ->where('nso007_production_cutting_return_item_detail.barcode', $this->barcode)
                ->where('nso007_production_cutting_return_item.warehouse_id', $this->warehouse_id)
                ->first();
            return $cut_qty->cut_qty ? $cut_qty->cut_qty : '';
        }

        public function use_cut_piece()
        {
            $qty = ProductionRequestDetailModel::selectRaw(
                'SUM(nso007_production_request_detail.qty) as use_qty'
            )
                ->join('nso007_production_request', 'nso007_production_request.id', 'nso007_production_request_detail.production_id')
                ->where([
                    'nso007_production_request.warehouse_id' => $this->warehouse_id,
                    'nso007_production_request_detail.barcode' => $this->barcode,
                    'nso007_production_request_detail.type' => 'cut_piece',
                    'nso007_production_request.status' => 1,
                ])
                ->first();
            return $qty->use_qty;
        }

    }

