<?php

    namespace App\Model;

    use App\Model\Hr\HrBranch;
    use Illuminate\Database\Eloquent\Model;

    class SaleModel extends Model
    {
        /**
         * The attributes that are mass assignable.
         *
         * @var array
         */
        protected $table = "nso007_sales";

        protected $fillable = [
            'id',
            'return_id',
            'purchase_request_id',
            'request_id',
            'branch_id',
            'member_type_id',
            'member_id',
            'member_shelf',
            'customer_type',
            'customer_id',
            'using_voucher_customer',
            'user_id',
            'request_by',
            'request_to',
            'approve_by',
            'rate',
            'bach_number',
            'receipt_number',
            'invoice_number',
            'reference_number',
            'year',
            'sale_date',
            'paid_amount_kh',
            'paid_amount_usd',
            'discount',
            'payment_status',
            'status',
            'confirm_receive',
            'return_status',
            'is_role',
            'sale_type',
            'request_type',
            'payment_method',
            'payment_type',
            'note',
            'type',
            'using_point',
            'points',
            'balance_point',
            'get_point',
            'delete_at',
            'delete_reason',
            'created_at',
            'updated_at',
        ];

        public function detail()
        {
            return $this->hasMany(SaleDetailsModel::class, 'sale_id', 'id');
        }

        public function seller()
        {
            return $this->belongsTo('App\User', 'user_id');
        }
    }
