<?php

    namespace App\Model;

    use Illuminate\Database\Eloquent\Model;

    class SaleDetailsModel extends Model
    {

        protected $table = "nso007_sale_details";

        protected $fillable = [
            'id',
            'sale_id',
            'product_unit_id',
            'currency_id',
            'qty',
            'deliver_qty',
            'store_qty',
            'sale_price',
            'dis',
            'barcode',
            'unit_id',
            'total',
            'status',
            'shelf',
            'date',
            'type',
            'last_stock',
            'created_at',
            'updated_at',
        ];

        public function product_unit()
        {
            return $this->hasOne(ProductUnitModel::class,'id','product_unit_id');
        }
        public function product()
        {
            return getProductById($this->product_unit->product_id);
        }

    }
