<?php

namespace App\Model;

use App\Model\setup\CustomerStatusModel;
use App\Models\TypeOfIllness;
use App\User;
use Illuminate\Database\Eloquent\Model;

class CustomerModel extends Model
{
    protected $table = "nso007_customers";

    protected $dates = ['register_date', 'date_of_birth'];
    protected $fillable = [
        'id',
        'branch_id',
        'lead_id',
        'agent_id',
        'reason',
        'customer_name',
        'sex',
        'customer_email',
        'customer_phone',
        'acc_related_party',
        'acc_marketing_promotion',
        'customer_address',
        'note',
        'status',
        'register_date',
        'type_illness',
        'illness_status',
        'date_of_birth',
        'age',
        'known_this_from',
        'known_product_by',
        'contact_by',
        'lead_source',
        'district_or_city',
        'province',
        'user_id',
        'type_of_customer',
        'customer_type',
        'member_type_id',
        'points',
        'customer_note',
        'reason_id',
        'customer_status_id',
        'user_insert_last_customer_case',
        'bach_number',
        'delete_reason',
        'deleted_by',
        'deleted_at',
        'created_at',
        'updated_at',
    ];

    public function user_province()
    {
        return $this->belongsTo(ProvinceModel::class, 'province', 'province_id');
    }

    public function typeIllness()
    {
        return $this->belongsTo(TypeOfIllness::class, 'type_illness_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function CustomerStatus()
    {
        return $this->hasOne(CustomerStatusModel::class, 'id','customer_status_id');
    }
    public function user_insert_last()
    {
        return $this->hasOne(User::class, 'id','user_insert_last_customer_case');
    }



}

