<?php


namespace App\Http\Controllers\setup;


use App\Fun\Fun;
use App\Http\Controllers\Controller;
use App\Model\setup\ReasonModel;
use Auth;
use Illuminate\Http\Request;

class ReasonController extends Controller

{

    function __construct()

    {
        $this->middleware('permission:Reason Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Reason List', ['only' => ['index']]);
        $this->middleware('permission:Reason Edit', ['only' => ['update', 'edit']]);
    }

    public function index()
    {
        $reason = ReasonModel::paginate(20);
        return view('setup.reason.index', compact('reason'));
    }

    public function create(Request $request)
    {
        return view('setup.reason.create');
    }

    public function store(Request $request)

    {
        return $this->update($request,null);
    }
    public function edit($id)
    {
        $reason = ReasonModel::find($id);
        return view('setup.reason.edit', compact('reason'));

    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'reason' => 'required|unique:nso007_reason,reason,'.$id,
        ]);
        ReasonModel::updateOrCreate(['id'=>$id],$request->all());
        return response()->json(['status'=>'ok','reload'=>1]);
    }
    public function destroy($id)

    {
        ReasonModel::find($id)->delete();
        return response()->json(['status'=>'ok','reload'=>1]);
    }
}
