<?php

namespace App\Http\Controllers\Branch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\CustomerModel;
use App\Model\MemberModel;
use App\Model\ProductModel;
use App\Model\ProductUnitModel;
use App\Model\SaleDetailsModel;
use App\Model\SaleModel;
use App\Model\StockModel;
use App\Model\TransferStockDetailModel;
use App\Model\TransferStockModel;
use App\Model\WarehouseModel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\DataTables;

class TranferStockController extends Controller
{
    public function index(Request $request)
    {
        $tranfer_stock = \DB::table('nso007_transfer_stock')
                            ->leftJoin('nso007_hr_branch as branch', 'nso007_transfer_stock.branch_id', 'branch.id')
                            ->join('users', 'nso007_transfer_stock.user_id', 'users.id')
                            ->leftJoin('nso007_warehouse as from_warehouse', 'nso007_transfer_stock.from_warehouse_id', 'from_warehouse.id')
                            ->leftJoin('nso007_warehouse as to_warehouse', 'nso007_transfer_stock.to_warehouse_id', 'to_warehouse.id')
                            ->selectRaw(
                                'nso007_transfer_stock.id,
                                nso007_transfer_stock.date,
                                nso007_transfer_stock.invoice_number,
                                nso007_transfer_stock.status,
                                branch.name as branch_name,
                                from_warehouse.warehouse_name as from_warehouse_name,
                                to_warehouse.warehouse_name as to_warehouse_name,
                                users.name as user_name
                            ');

        // if (isset($request->status))
        //     $tranfer_stock = $tranfer_stock->where('nso007_transfer_stock.status', $request->status);

        if (isset($request->date))
            $tranfer_stock = $tranfer_stock->where('nso007_transfer_stock.date', $request->date);

        if (isset($request->invoice_number))
            $tranfer_stock = $tranfer_stock->where('nso007_transfer_stock.invoice_number', 'LIKE', '%' . $request->invoice_number . '%');

        $tranfer_stock->orderBy('id', 'DESC')->get();

        if ($request->ajax()) {
            return DataTables::of($tranfer_stock)
                    ->editColumn('status', function ($tranfer_stock) {
                        return checkRequestStatus($tranfer_stock->status);
                    })
                    ->addColumn('action', function ($tranfer_stock) {
                        return  '<i href="javascript:;" data-href="'.route('tranfer-stock.show', $tranfer_stock->id).'" data-id="'. $tranfer_stock->id.'" class="fa fa-eye btn btn-sm btn-primary showDetail" title="View Detail"></i>';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'status'])
                    ->make('true');
        }
        return view('branch.tranfer_stock.index');

    }

    public function create(Request $request)
    {
        $own = WarehouseModel::where('branch_id', \Auth::id())
                                    ->where('user_id', \Auth::id())
                                    ->first();

        $warehouse = WarehouseModel::where('branch_id', \Auth::id())
                                    ->where('user_id', '!=',\Auth::id())
                                    ->first();

        $stock_item = StockModel::where('warehouse_id', $warehouse->id)
                            ->join('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
                            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                            ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                            ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                            ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                            ->groupBy('product_unit_id')
                            ->paginate(1);

        if ($request->ajax()) {
            $html = view('branch.tranfer_stock.result_create', compact('stock_item'))->render();
            return response()->json(['html' => $html]);
        }
        return view('branch.tranfer_stock.create', compact('stock_item', 'warehouse', 'own'));
    }

    public function edit(Request $request, $id)
    {
        // if($request->ajax()){
        //     $saleProduct = session()->forget('saleProduct');
        //     $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
        //                     ->leftJoin('nso007_member', 'nso007_sales.customer_id', 'nso007_member.id')
        //                     ->leftJoin('users', 'nso007_member.user_id', 'users.id')
        //                     ->leftJoin('nso007_hr_branch', 'users.branch_id', 'nso007_hr_branch.id')
        //                     ->leftJoin('users as seller', 'nso007_sales.user_id', 'seller.id')
        //                     ->join('nso007_sale_details', 'nso007_sale_details.sale_id', 'nso007_sales.id')
        //                     ->orderBy('id', 'desc')
        //                     ->selectRaw('nso007_sale_details.id as sale_detail_id, nso007_sale_details.qty, nso007_sale_details.dis, nso007_sale_details.sale_price, nso007_sales.discount, invoice_number, product_id, warehouse_name, nso007_hr_branch.name as branch_name, users.name as member, seller.name as seller, nso007_sales.id, nso007_sales.status, payment_status, paid_amount_kh, paid_amount_usd')
        //                     ->get();


        //     foreach($data as $item){
        //         $product_unit = \DB::table('nso007_product_unit')
        //                                 ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
        //                                 ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
        //                                 ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
        //                                 ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
        //                                 ->selectRaw('nso007_product_unit.cur, image, product_name, unit, name as color, size, nso007_product_unit.id, nso007_product_unit.barcode, wholesale_price')
        //                                 ->where('nso007_product_unit.id', $item['product_id'])
        //                                 ->first();

        //         $saleProduct[$item['product_id']] = [
        //             "id" => $item['product_id'],
        //             "unit" => $product_unit->unit,
        //             "name" => $product_unit->product_name.'(Size:'.$product_unit->size .' Color: '.$product_unit->color.')',
        //             "qty" => $item['qty'],
        //             "cur" => $product_unit->cur,
        //             "cost" => $item['sale_price'],
        //             "discount" => $item['dis'],
        //             "total" => 0,
        //             "ref" => "edit",
        //             "sale_detail_id" => $item['sale_detail_id']
        //         ];
        //         session()->put('saleProduct', $saleProduct);
        //     }
        //     return response()->json('');
        // }
    }
    public function show($id)
    {
        $tranfer_stock = \DB::table('nso007_transfer_stock')
        ->leftJoin('nso007_hr_branch as branch', 'nso007_transfer_stock.branch_id', 'branch.id')
        ->join('users', 'nso007_transfer_stock.user_id', 'users.id')
        ->leftJoin('nso007_warehouse as from_warehouse', 'nso007_transfer_stock.from_warehouse_id', 'from_warehouse.id')
        ->leftJoin('nso007_warehouse as to_warehouse', 'nso007_transfer_stock.to_warehouse_id', 'to_warehouse.id')
        ->selectRaw(
            'nso007_transfer_stock.id,
            nso007_transfer_stock.date,
            nso007_transfer_stock.invoice_number,
            nso007_transfer_stock.status,
            branch.name as branch_name,
            from_warehouse.warehouse_name as from_warehouse_name,
            to_warehouse.warehouse_name as to_warehouse_name,
            users.name as user_name
        ')->get();

        $transfer_datail = \DB::table('nso007_transfer_stock_detail')
                                    ->join('nso007_product_unit', 'nso007_transfer_stock_detail.barcode', 'nso007_product_unit.barcode')
                                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                                    ->leftJoin('nso007_unit', 'nso007_transfer_stock_detail.unit_id', 'nso007_unit.id')
                                    ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                                    ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                                    ->selectRaw(
                                        'nso007_transfer_stock_detail.qty,
                                        nso007_products.product_name,
                                        nso007_unit.unit,
                                        nso007_product_color.name as color_name,
                                        nso007_product_color.color as color,
                                        nso007_product_size.size as size_name
                                    ')
                                    ->where('nso007_transfer_stock_detail.transfer_id', $id)
                                    ->get();

        return response()->json(['tranfer_stock' => $tranfer_stock, 'transfer_detail' => $transfer_datail]);
    }

    public function store(Request $request)
    {
        // return dd($request->all());
        $this->validate($request, [
            // 'member' => 'required|numeric',
            'id' => 'required',
        ]);

            $tranfer_stock = new TransferStockModel();
            $tranfer_stock->from_warehouse_id = $request->tranfer_from;
            $tranfer_stock->to_warehouse_id = $request->tranfer_to;
            $tranfer_stock->user_id = auth()->user()->id;
            $tranfer_stock->branch_id =  auth()->user()->branch_id;
            $tranfer_stock->date =  Carbon::now();
            $tranfer_stock->invoice_number = 'T'.date("YmdhisA");
            $tranfer_stock->year =  date('Y');
            $tranfer_stock->note =  $request->note;
            $tranfer_stock->status =  0;
            $tranfer_stock->confirm_status = 0;
            $tranfer_stock->save();

            foreach($request->id as $key => $item)
            {
                $product_unit = ProductUnitModel::find($item);
                $tranfer_detail = new TransferStockDetailModel();

                $tranfer_detail->transfer_id = $tranfer_stock->id;
                $tranfer_detail->barcode = $product_unit->barcode;
                $tranfer_detail->qty = $request->qty[$key];
                $tranfer_detail->unit_id = $request->unit_id[$key];
                $tranfer_detail->save();

                $qty = $product_unit->unit_id == $request->unit_selected ?
                            $request->qty[$key] :
                            $request->qty[$key] * $product_unit->qty_per_unit;

                // $stock = StockModel::where('branch_id', auth()->user()->branch_id)->where('warehouse_id')
                $to_stock = StockModel::updateOrCreate([
                    'warehouse_id'      =>  $request->tranfer_to,
                    'product_unit_id'   =>  $item
                ]);

                $to_stock->stock_qty += $qty;
                $to_stock->color_id = $product_unit->color_id;
                $to_stock->size_id = $product_unit->size_id;
                $to_stock->save();

                $from_stock = StockModel::where('warehouse_id', $request->tranfer_from)->where('product_unit_id', $item)->first();
                if ($from_stock)
                    $from_stock->update([
                        'stock_qty' => $from_stock->stock_qty - $qty
                    ]);
            }

        session()->forget('tranferStock');
        return redirect()->route('tranfer-stock.index')->with('success', 'Wholesale created successfully.');

    }
    public static function generate_voucher_number($number_ref,$digit)
    {
        return str_pad($number_ref,$digit, "0", STR_PAD_LEFT);
    }

    // public function wholesale_autocomplete(Request $request)

    // {
    //     $value = $request->barcode;
    //     $stock_item = StockModel::select('nso007_stocks.*')
    //         ->join('nso007_products','nso007_products.id','nso007_stocks.product_id')
    //         ->where(['nso007_stocks.warehouse_id'=>(getMainWarehouse()?getMainWarehouse()->id:0),'nso007_stocks.type'=>'product'])
    //         ->where('nso007_stocks.stock_qty','>',0)
    //         ->where(function ($q) use ($value){
    //             $q->where('nso007_stocks.barcode', 'LIKE', '%' . $value . '%');
    //             $q->orwhere('nso007_products.product_name', 'LIKE', '%' . $value . '%');
    //         })
    //         ->paginate(20);
    //     $html = view('pos.clothes-pos.result-create', compact('stock_item'))->render();
    //     return response()->json(['html'=>$html]);

    // }
    // public function scan_code(Request $request)

    // {
    //     $std = new \stdClass();
    //     $value = $request->barcode;
    //     if ($value) {
    //         $stock_item = StockModel::select('nso007_stocks.*')
    //             ->where(['nso007_stocks.warehouse_id'=>(getMainWarehouse()?getMainWarehouse()->id:0),'nso007_stocks.type'=>'product'])
    //             ->where('nso007_stocks.stock_qty','>',0)
    //             ->where(function ($q) use ($value){
    //                 $q->where('nso007_stocks.barcode', $value );
    //             })
    //             ->first();
    //         if($stock_item){
    //             $std->id = ProductUnitModel::where('barcode',$value)->first()->id;
    //             $std->name = getProductById($stock_item->product_id)->product_name;
    //             $std->stock = $stock_item->stock_qty;
    //             $std->size = findSize($stock_item->size_id)->size;
    //             $std->code = $stock_item->barcode;
    //             $std->price = ProductUnitModel::where('barcode',$stock_item->barcode)->first()->retail_price;
    //             $std->symbol = findProductCurrency($stock_item->product_id);
    //         }
    //     } else {
    //         $stock_item = null;
    //     }
    //     return response()->json(['data'=>$std]);

    // }
    public function new_customer(Request $request){
        if ($request->ajax()){
            if($request->input('customer_name')){
                $customer = new CustomerModel();
                $customer->customer_name = $request->input('customer_name');
                $customer->customer_phone = $request->input('customer_phone');
                $customer->customer_address = $request->input('customer_address');
                $customer->agent_id =Auth::user()->id;
                $customer->branch_id = Auth::user()->id;;
                $customer->save();
                return response()->json(['customer'=>$customer]);
            }
        }
    }

    public function addProduct(Request $request, $id)
    {
        $product_unit = \DB::table('nso007_product_unit')
                            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                            ->leftJoin('nso007_unit', 'nso007_product_unit.sub_unit_id', 'nso007_unit.id')
                            ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                            ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                            ->selectRaw('nso007_product_unit.cur, nso007_product_unit.product_id, image, product_name, unit, name as color, size, nso007_product_unit.id, nso007_product_unit.barcode, retail_price')
                            ->where('nso007_product_unit.id', $id)
                            ->where(function($q) use ($request, $id){
                                if($request->type == 'id'){
                                    $q->where('nso007_product_unit.id', $id);
                                }else{
                                    $q->where('nso007_product_unit.barcode', $id);
                                }
                            })
                            ->first();

        $product = ProductModel::where('id', $product_unit->product_id)
            ->with('unit','unit_child')
            ->first(['unit_id', 'child_unit','product_name']);

        $units = [];
        if($product) { // append unit
            if ($product->unit)
                $units[$product->unit->id] = $product->unit->unit;

            if ($product->unit_child)
                $units[$product->unit_child->id] = $product->unit_child->unit;
        }

        $saleProduct = session()->get('tranferStock');
        if ($saleProduct) {
            if (@$saleProduct[$product_unit->id]) {
                return response()->json(['message' => 'warning', 'data' => 'Product adding is already exist! ' . $product_unit->id]);
            } else {
                $saleProduct[$product_unit->id] = [
                    "id" => $product_unit->id,
                    "units" => $$units,
                    "unit_selected" => $product_unit->unit,
                    "name" => $product_unit->product_name.'(Size:'.$product_unit->size .' Color: '.$product_unit->color.')',
                    "qty" => 1,
                ];
                session()->put('tranferStock', $saleProduct);
                return response()->json(['message' => 'success', 'data' => 'Product adding successfully.']);
            }
        } else {
            $saleProduct[$product_unit->id] = [
                "id" => $product_unit->id,
                "units" => $units,
                "unit_selected" => $product_unit->unit,
                "name" => $product_unit->product_name.'(Size '.$product_unit->size .', Color '.$product_unit->color.')',
                "qty" => 1,
            ];
            session()->put('tranferStock', $saleProduct);
            return response()->json(['message' => 'success', 'data' => 'Product added successfully.']);
        };
    }

    public function getProduct()
    {
        $saleProduct = session()->get('tranferStock');
        $view = view('branch.tranfer_stock.product', compact('saleProduct'))->render();
        return response()->json(['html' =>$view]);
    }

    public function updateProduct(Request $request, $id)
    {
        $saleProduct = session()->get('tranferStock');
        $warehouse = WarehouseModel::where('branch_id', auth()->user()->branch_id)
                    ->where('user_id', 1)
                    ->first();

        $stock = StockModel::where([
            'warehouse_id'      =>  $warehouse->id,
            'product_unit_id'   =>  $id
        ])->first();

        $product_unit = ProductUnitModel::find($id);
        $product_unit_qty = $product_unit->unit_id == $request->unit_selected ?
                            $request->qty :
                            $request->qty[$key] *
                            $product_unit->qty_per_unit;

        $qty = $stock->stock_qty - $product_unit_qty;

        if ($qty <= 0)
            return response()->json([
                'message' => 'fail',
                'data' => 'Product is out of stock.',
                'qty'   => $stock->stock_qty
            ]);


        $saleProduct[$id]['qty'] = $request->qty;
        $saleProduct[$id]['unit_selected'] = $request->unit_selected;
        session()->put('tranferStock', $saleProduct);

        return response()->json(['message' => 'success', 'data' => $qty == 'gg'? '':'Product updated successfully.']);
    }

    public function deleteProduct($id)
    {
        session()->forget('tranferStock.' . $id);
        return response()->json(['message' => 'success', 'data' => 'Product deleted successfully.']);
    }
}
