<?php

namespace App\Http\Controllers\Branch;

use App\Fun\Fun;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\SaleModel;
use App\Model\WarehouseModel;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;

class Stock_BranchController extends Controller
{
    function __construct()
    {
        Fun::lang();
    }


    public function stock_in(Request $request)
    {
        if ($request->ajax()) {
            $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
                        ->leftJoin('users', 'nso007_warehouse.branch_id', 'users.id')
                        ->join('users as seller', 'nso007_sales.user_id', 'seller.id')
                        // ->where('nso007_sales.user_id', \Auth::id())
                        ->where('nso007_sales.customer_id', \Auth::id())
                        ->leftJoin('nso007_payment', 'nso007_sales.id', 'nso007_payment.invoice_id')
                        ->where('nso007_sales.sale_type', 'wholesale')
                        ->where('nso007_payment.type', '!=','purchase')
                        // ->where('nso007_sales.payment_status', $request->type)
                        ->selectRaw('
                            nso007_sales.sale_date,
                            invoice_number,
                            warehouse_name,
                            users.name as branch_name,
                            seller.name as seller,
                            nso007_sales.id,
                            nso007_sales.status,
                            nso007_sales.payment_status,
                            paid_amount_kh, payment_amount, paid_amount, users.phone, seller.created_at,
                            nso007_payment.id as payment_id')
                        ->where(function ($query) use ($request) {
                                if ($request->invoice_number) {
                                    $query->where('nso007_sales.invoice_number', 'LIKE', '%'. $request->invoice_number . '%');
                                }

                                if ($request->bay_date) {
                                    $query->where('nso007_sales.sale_date','LIKE',date('Y-m-d',strtotime($request->bay_date)));
                                }
                                if ($request->payment_status) {
                                    $query->where('nso007_sales.payment_status',  $request->payment_status );
                                }
                            })
                        ->orderBy('id', 'desc')
                        ->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));

            return DataTables::of($data->items())
                    ->with([
                        "activePage" => $request->page,
                        "records" => $request->record,
                        "recordsTotal" => $data->total(),
                        "recordsFiltered" => $data->total(),
                        'totalPage' => $data->lastPage()
                    ])
                    ->addColumn('action', function($action){
                        if(!$action->status == 1 || !$action->status == 0){
                            return  '<i href="javascript:;"
                            data-seller="'.$action->seller.'"
                            data-member="'.$action->member.'"
                            data-branch_name="'.$action->branch_name.'"
                            data-warehouse_name="'.$action->warehouse_name.'" class="fa fa-eye btn btn-sm btn-primary showDetail"
                            data-created_at="'.date('d-m-Y', strtotime($action->sale_date)).'"
                            data-warehouse_name="'.$action->warehouse_name.'"
                            data-invoice="'.$action->invoice_number.'"
                            data-id="'.$action->id.'"
                            data-payment_status = "'.($action->payment_status == "paid" ? __("administrator.paid") : __("administrator.paid")   ).'"
                            data-url = "' . route("wholesale.show", $action->id) . '"
                            title="View Detail"></i>';
                        }

                    })
                    ->editColumn('payment_status', function($action){
                        return '<span class="label '.($action->payment_status == "owe" ?"label-warning":"label-success").'">'.ucfirst($action->payment_status).'</span>';
                    })
                    ->editColumn('status', function($action){
                        switch ($action->status) {
                            case '1':
                                return '<span class="label label-success">Approved</span>';
                                break;
                            case '2':
                                return '<span class="label label-default">Padding</span>';
                                break;
                            case '4':
                                return '<span class="label label-danger">Canceled</span>';
                                break;
                            case '3':
                                return '<span class="label label-warning">Returned</span>';
                                break;
                            default:
                                break;
                        }
                    })
                    ->addColumn('paid_amount', function($action){
                        return number_format($action->paid_amount, 2).'$';
                    })
                    ->addColumn('sale_date', function($action){
                        return date('d-m-Y', strtotime($action->sale_date));;
                    })

                    ->addColumn('payment_amount', function($action){
                        return number_format($action->payment_amount, 2).'$';
                    })
                    ->addColumn('remain', function($action){
                        return number_format(($action->payment_amount - $action->paid_amount), 2).'$';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'payment_status', 'status'])
                    ->make(true);
        }

        return view('branch.stock.stockin');
    }

    public function stock_out(Request $request){
        // dd( $request);

        if ($request->ajax()) {
            $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
                        ->leftJoin('nso007_member', 'nso007_sales.customer_id', 'nso007_member.id')
                        ->leftJoin('users', 'nso007_member.user_id', 'users.id')
                        ->leftJoin('nso007_customers', 'nso007_sales.customer_id', 'nso007_customers.id')
                        ->leftJoin('users as seller', 'nso007_sales.user_id', 'seller.id')
                        ->leftJoin('nso007_payment as payment', 'nso007_sales.id', 'payment.invoice_id')
                        // ->where('nso007_sales.sale_type', 'retail')
                        ->where('nso007_sales.user_id', \Auth::id())
                        ->where('payment.type', '!=','purchase')
                        ->selectRaw('nso007_sales.discount,
                            nso007_sales.created_at,
                            invoice_number,
                            warehouse_name,
                            nso007_customers.customer_name,
                            nso007_customers.customer_phone AS customer_phone_,
                            customer_address,
                            users.name as member,
                            seller.name as seller,
                            nso007_sales.id,
                            nso007_sales.status,
                            payment.payment_status,
                            paid_amount_kh,
                            paid_amount_usd,
                            customer_phone,
                            payment.id as payment_id,
                            payment.payment_amount,
                            payment.paid_amount as paid_payment_amount,
                            sale_type
                        ')

                        ->where(function ($query) use ($request) {
                            if ($request->invoice_number) {
                                $query->where('nso007_sales.invoice_number', 'LIKE', '%'. $request->invoice_number . '%');
                            }
                            if ($request->create_at) {
                                $query->whereDate('nso007_sales.sale_date','LIKE',date('Y-m-d',strtotime($request->create_at)));
                            }
                            if ($request->payment_status) {
                                $query->where('nso007_sales.payment_status',  $request->payment_status );
                            }
                            if ($request->sale_type) {
                                if($request->sale_type == 'retail'){
                                    $query->where('nso007_sales.sale_type',  $request->sale_type );
                                }
                                if($request->sale_type == 'not_retail'){
                                    $query->where('nso007_sales.sale_type','!=' , 'retail' );
                                }

                            }
                            if ($request->customer_name) {
                                $query->Orwhere('nso007_customers.customer_name', 'LIKE', '%'. $request->customer_name . '%');
                                $query->Orwhere('nso007_customers.customer_phone', 'LIKE', '%'. $request->customer_name . '%');

                            }
                        })

                        ->orderBy('id', 'desc')->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));
                        // dd($data);

            return DataTables::of($data->items())
                    ->with([
                        "activePage" => $request->page,
                        "records" => $request->record,
                        "recordsTotal" => $data->total(),
                        "recordsFiltered" => $data->total(),
                        'totalPage' => $data->lastPage()
                    ])
                    ->addColumn('action', function($action){

                        if($action->sale_type ==  'retail'){
                            return  '<i href="javascript:;" data-status="'.$action->payment_status.'" data-date="'.Carbon::parse($action->create_at)->format('d-m-Y g:i A').'" data-seller="'.$action->seller.'" data-phone="'.$action->customer_phone.'" data-customer_name="'.$action->customer_name.'" data-customer_address="'.$action->customer_address.'" class="fa fa-eye btn btn-sm btn-primary showDetail" data-created_at="'.$action->created_at.'" data-invoice="'.$action->invoice_number.'"  data-id="'.$action->id.'"  data-url = "' . route("wholesale.show", $action->id) . '"  data-payment_url = "' . url("retail-pos-payment", $action->id) . '" data-payment_id= "'.$action->payment_id.'" title="View Detail"></i>';
                        }else{
                            return  '<i href="javascript:;" data-status="'.$action->payment_status.'" data-date="'.Carbon::parse($action->create_at)->format('d-m-Y g:i A').'" data-seller="'.$action->seller.'" data-phone="'.$action->customer_phone.'" data-customer_name="'.$action->customer_name.'" data-customer_address="'.$action->customer_address.'" class="fa fa-eye btn btn-sm btn-primary showDetail" data-created_at="'.$action->created_at.'" data-invoice="'.$action->invoice_number.'"  data-id="'.$action->id.'"  data-url = "' . route("wholesale.show", $action->id) . '"  data-payment_url = "' . url("retail-pos-payment", $action->id) . '" data-payment_id= "'.$action->payment_id.'" title="View Detail"></i>';
                        }
                    })
                    ->editColumn('payment_status', function($action){
                        if($action->sale_type ==  'retail'){
                        return '<span class="label '.($action->payment_status == "owe" ?"label-warning":"label-success").'">'.ucfirst($action->payment_status).'</span>';
                        }else{
                            return '<span class="label '.($action->payment_status == "owe" ?"label-warning":"label-success").'">'.ucfirst($action->payment_status).'</span>';
                        }
                    })
                    ->addColumn('paid', function($action){
                        if($action->sale_type ==  'retail')
                            return number_format($action->paid_amount_kh/currencyExchange() + $action->paid_amount_usd, 2).'$';
                        else
                            return number_format($action->paid_amount_kh/currencyExchange() + $action->paid_amount_usd, 2).'$';
                        })
                    ->addColumn('total', function($action){
                        if($action->sale_type ==  'retail'){
                            $total = 0;
                            $sale_details = \DB::table('nso007_sale_details')
                                                ->where('sale_id', $action->id)
                                                ->selectRaw('sale_price, dis, currency_id, qty, status')
                                                ->get();
                            foreach($sale_details as $sale_detail){
                                if($sale_detail->status != 0){
                                    $grand_total = ($sale_detail->sale_price * $sale_detail->qty) - (($sale_detail->sale_price * $sale_detail->qty)*($sale_detail->dis/100));
                                    $grand_total = $sale_detail->currency_id == 1 ? $grand_total/currencyExchange() : $grand_total;
                                    $total += $grand_total;
                                }
                            }
                            $total = $total - ($total * $action->discount/100);
                            return number_format($total, 2).'$';
                        }else{
                            $total = 0;
                            $sale_details = \DB::table('nso007_sale_details')
                                                ->where('sale_id', $action->id)
                                                ->selectRaw('sale_price, dis, currency_id, qty, status')
                                                ->get();
                            foreach($sale_details as $sale_detail){
                                if($sale_detail->status != 0){
                                    $grand_total = ($sale_detail->sale_price * $sale_detail->qty) - (($sale_detail->sale_price * $sale_detail->qty)*($sale_detail->dis/100));
                                    $grand_total = $sale_detail->currency_id == 1 ? $grand_total/currencyExchange() : $grand_total;
                                    $total += $grand_total;
                                }
                            }
                            $total = $total - ($total * $action->discount/100);
                            return number_format($total, 2).'$';
                        }

                    })
                    ->addColumn('remain', function($action){
                        $total = ($action->payment_amount - $action->paid_payment_amount) > 0 ? ($action->payment_amount - $action->paid_payment_amount) : 0;
                        return $total .'$';
                    })
                    ->editColumn('sale_type', function($action){
                        if($action->sale_type ==  'retail')
                            return  __('administrator.retail') ;
                        else
                            return  __('administrator.pos_seller') ;
                    })
                    ->editColumn('customer_phone_', function($action){
                        return  ($action->customer_name) .' / '.$action->customer_phone_  ;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'payment_status', 'status'])
                    ->make(true);
        }
        return view('branch.stock.stock_out');
    }

    public function stock_balance(Request $request){
        if ($request->ajax())
        {
            $warehouse = WarehouseModel::where('branch_id', \Auth::id())->pluck('id');
            $stocks = \DB::table('nso007_product_unit')
                        ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                        ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                        // ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                        // ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                        ->leftJoin('nso007_unit as sub', 'nso007_product_unit.sub_unit_id', 'sub.id')
                        ->join('nso007_category', 'nso007_products.category_id', 'nso007_category.id')
                        ->where(function ($query) use ($request) {
                            if ($request->name) {
                                $query->where('nso007_products.product_name', 'LIKE', '%'. $request->name . '%');
                            }

                            if ($request->code) {
                                $query->where('nso007_product_unit.barcode', 'LIKE', '%'. $request->code . '%');
                            }
                        })
                        ->selectRaw('nso007_product_unit.id,  product_name, nso007_product_unit.barcode, image,product_id, category_name, nso007_unit.unit, sub.unit as sub_unit')
                        ->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));
            return DataTables::of($stocks->items())
            ->with([
                "activePage" => $request->page,
                "records" => $request->record,
                "recordsTotal" => $stocks->total(),
                "recordsFiltered" => $stocks->total(),
                'totalPage' => $stocks->lastPage()
            ])
            ->addColumn('image', function ($stock){
                return '<img src="' . asset($stock->image) . '" width="60" height="60" alt="product image">' ;
            })
            ->editColumn('product_name', function($stock){
                return $stock->product_name ;//. ' (Color : ' . $stock->color .', Size : '. $stock->size .')';
            })
            ->addColumn('stock_in', function ($stock) use ($warehouse){
                $stock_in = collect([]);
                $unit = '';

                $purchases = \DB::table('nso007_purchases')
                        ->join('nso007_purchase_details', 'nso007_purchases.id', 'nso007_purchase_details.purchase_id')
                        ->leftJoin('nso007_product_unit', 'nso007_purchase_details.product_unit_id', 'nso007_product_unit.id')
                        ->leftJoin('nso007_unit', 'nso007_purchase_details.unit_id', 'nso007_unit.id')
                        ->where('product_unit_id', $stock->id)
                        ->whereIn('warehouse_id', $warehouse)
                        ->groupBy('nso007_purchase_details.unit_id')
                        ->selectRaw('sum(qty) as qty, nso007_unit.unit')
                        ->get();

                foreach($purchases as $key => $item){
                    $add_stock = $stock_in->where('unit', $item->unit);
                    if(!$add_stock->isEmpty()){
                        $key = array_key_first($add_stock->toArray());
                        $stock_in[$key]->qty = $item[$key]->qty + $item->qty;
                    }else{
                        $stock_in[] = $item;
                    }
                }

                // role seller or branch
                if(\Auth::user()->is_role == 'Branch' || \Auth::user()->is_role == 'Seller'){
                    $sales = \DB::table('nso007_sales')
                        ->join('nso007_sale_details', 'nso007_sales.id', 'nso007_sale_details.sale_id')
                        ->leftJoin('nso007_product_unit', 'nso007_sale_details.product_id', 'nso007_product_unit.id')
                        ->leftJoin('nso007_unit', 'nso007_sale_details.unit_id', 'nso007_unit.id')
                        ->where('nso007_sale_details.product_id', $stock->id)
                        ->whereIn('warehouse_id', $warehouse)
                        ->groupBy('nso007_sale_details.unit_id')
                        ->selectRaw('sum(qty) as qty, nso007_unit.unit')
                        ->get();

                    foreach($sales as $item1){
                        $add_stock = $stock_in->where('unit', $item1->unit);
                        if(!$add_stock->isEmpty()){
                            $key = array_key_first($add_stock->toArray());
                            $stock_in[$key]->qty = $item1[$key]->qty + $item1->qty;
                        }else{
                            $stock_in[] = $item1;
                        }
                    }
                }
                foreach ($stock_in as $key => $unitl){
                    $unit .= ($key != 0 ?', ':'').$unitl->qty.$unitl->unit;
                }
                return $unit;
            })
            ->addColumn('balance', function ($stock) use ($warehouse){
                $stock = \DB::table('nso007_stocks')
                            ->leftJoin('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
                            ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                            ->leftJoin('nso007_unit as sub', 'nso007_product_unit.sub_unit_id', 'sub.id')
                            ->whereIn('warehouse_id', $warehouse)
                            ->where('product_unit_id', $stock->id)
                            ->selectRaw('sum(stock_qty) as qty, nso007_unit.unit, nso007_product_unit.qty_per_unit, sub.unit as sub')
                            ->first();
                if(@$stock->qty_per_unit){
                   return intval($stock->qty/$stock->qty_per_unit).$stock->unit.', '.$stock->qty%$stock->qty_per_unit.$stock->sub;
                }
                return '';

            })
            ->addColumn('stock_out', function ($stock){
                $sales = \DB::table('nso007_sales')
                        ->join('nso007_sale_details', 'nso007_sales.id', 'nso007_sale_details.sale_id')
                        ->leftJoin('nso007_product_unit', 'nso007_sale_details.product_id', 'nso007_product_unit.id')
                        ->leftJoin('nso007_unit', 'nso007_sale_details.unit_id', 'nso007_unit.id')
                        ->where('nso007_sale_details.product_id', $stock->id)
                        ->where('user_id', \Auth::id())
                        ->groupBy('nso007_sale_details.unit_id')
                        ->selectRaw('sum(qty) as qty, nso007_unit.unit')
                        ->get();

                $unit = '';
                foreach($sales as $key => $item){
                    $unit .= ($key != 0 ?', ':'').$item->qty.$item->unit;
                }
                return $unit;
            })
            ->addIndexColumn()
            ->rawColumns(['image'])
            ->make(true);
        }
        return view('branch.stock.stock-balance');

    }

    public function manage_stock_areas(Request $request){
        if ($request->ajax())
        {
            $warehouse = WarehouseModel::where('branch_id', \Auth::id())->pluck('id');
            $stocks = \DB::table('nso007_product_unit')
                        ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                        ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                        // ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                        ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                        ->leftJoin('nso007_unit as sub', 'nso007_product_unit.sub_unit_id', 'sub.id')
                        ->join('nso007_category', 'nso007_products.category_id', 'nso007_category.id')
                        ->where(function ($query) use ($request) {
                            if ($request->name) {
                                $query->where('nso007_products.product_name', 'LIKE', '%'. $request->name . '%');
                            }

                            if ($request->code) {
                                $query->where('nso007_product_unit.barcode', 'LIKE', '%'. $request->code . '%');
                            }
                        })
                        ->selectRaw('nso007_product_unit.id, product_name, nso007_product_unit.barcode, image,product_id, category_name, nso007_unit.unit, sub.unit as sub_unit,nso007_products.description')
                        ->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));
            return DataTables::of($stocks->items())
            ->with([
                "activePage" => $request->page,
                "records" => $request->record,
                "recordsTotal" => $stocks->total(),
                "recordsFiltered" => $stocks->total(),
                'totalPage' => $stocks->lastPage()
            ])
            ->addColumn('image', function ($stock){
                return '<img src="' . asset($stock->image) . '" width="60" height="60" alt="product image">' ;
            })
            ->editColumn('product_name', function($stock){
                return $stock->product_name  ;
            })
             ->editColumn('branch_name', function($action){
                return  1   ;  //User::find($action->branch_id)->name            ;
            })
            ->addColumn('balance', function ($stock) use ($warehouse){
                $stock = \DB::table('nso007_stocks')
                            ->leftJoin('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
                            ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                            ->leftJoin('nso007_unit as sub', 'nso007_product_unit.sub_unit_id', 'sub.id')
                            ->whereIn('warehouse_id', $warehouse)
                            ->where('product_unit_id', $stock->id)
                            ->selectRaw('sum(stock_qty) as qty, nso007_unit.unit, nso007_product_unit.qty_per_unit, sub.unit as sub')
                            ->first();
                if(@$stock->qty_per_unit){
                   return intval($stock->qty/$stock->qty_per_unit).$stock->unit.', '.$stock->qty%$stock->qty_per_unit.$stock->sub;
                }
                return '';

            })

            ->addIndexColumn()
            ->rawColumns(['image'])
            ->make(true);
        }
        return view('branch.stock.manage-stock-areas');
    }


    public function stock_request(Request $request)
    {
        if($request->ajax()){

        }
        return view('branch.stock.stock_request');
    }


}
