<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\Model\Accounting\JournalModel;
use App\Model\CustomerModel;
use App\Model\MemberModel;
use App\Model\PaymentDetailModel;
use App\Model\PaymentModel;
use App\Model\ProductModel;
use App\Model\ProductUnitModel;
use App\Model\purchase_order\PurchaseOrderDetailModel;
use App\Model\purchase_order\PurchaseOrderModel;
use App\Model\SaleDetailsModel;
use App\Model\SaleModel;
use App\Model\StockModel;
use App\Model\WarehouseModel;
use App\User;
use Carbon\Carbon;
use Fun;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Yajra\DataTables\DataTables;

class SellerPOSController extends Controller
{
    function __construct()
    {
        Fun::lang();
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
                ->leftJoin('nso007_member', 'nso007_sales.customer_id', 'nso007_member.id')
                ->leftJoin('users', 'nso007_member.user_id', 'users.id')
                ->leftJoin('nso007_customers', 'nso007_sales.customer_id', 'nso007_customers.id')
                ->leftJoin('users as seller', 'nso007_sales.user_id', 'seller.id')
                ->leftJoin('nso007_payment as payment', 'nso007_sales.id', 'payment.invoice_id')
                ->where('nso007_sales.sale_type', 'branch-pos')
                ->where('nso007_sales.user_id', \Auth::id())
                ->where('payment.type', '!=', 'purchase')
                ->selectRaw('nso007_sales.discount,
                            nso007_sales.created_at,
                            invoice_number,
                            warehouse_name,
                            nso007_customers.customer_name,
                            customer_address,
                            users.name as member,
                            seller.name as seller,
                            nso007_sales.id,
                            nso007_sales.status,
                            payment.payment_status,
                            paid_amount_kh,
                            paid_amount_usd,
                            customer_phone,
                            payment.id as payment_id,
                            payment.payment_amount,
                            payment.paid_amount as paid_payment_amount
                        ')
                ->orderBy('id', 'desc')->paginate($request->record, ['*'], 'page', str_replace(',', '', $request->page));
            return DataTables::of($data->items())
                ->with([
                    "activePage" => $request->page,
                    "records" => $request->record,
                    "recordsTotal" => $data->total(),
                    "recordsFiltered" => $data->total(),
                    'totalPage' => $data->lastPage()
                ])
                ->addColumn('action', function ($action) {
                    return '<i href="javascript:;" data-status="' . $action->payment_status . '" data-date="' . Carbon::parse($action->create_at)->format('d-m-Y g:i A') . '" data-seller="' . $action->seller . '" data-phone="' . $action->customer_phone . '" data-customer_name="' . $action->customer_name . '" data-customer_address="' . $action->customer_address . '" class="fa fa-eye btn btn-sm btn-primary showDetail" data-created_at="' . $action->created_at . '" data-invoice="' . $action->invoice_number . '"  data-id="' . $action->id . '"  data-url = "' . route("wholesale.show", $action->id) . '"  data-payment_url = "' . url("retail-pos-payment", $action->id) . '" data-payment_id= "' . $action->payment_id . '" title="View Detail"></i>';
                })
                ->editColumn('payment_status', function ($action) {
                    return '<span class="label ' . ($action->payment_status == "owe" ? "label-warning" : "label-success") . '">' . ucfirst($action->payment_status) . '</span>';
                })
                ->addColumn('paid', function ($action) {
                    return number_format($action->paid_amount_kh / currencyExchange() + $action->paid_amount_usd, 2) . '$';
                })
                ->addColumn('total', function ($action) {

                    $total = 0;
                    $sale_details = \DB::table('nso007_sale_details')
                        ->where('sale_id', $action->id)
                        ->selectRaw('sale_price, dis, currency_id, qty, status')
                        ->get();
                    foreach ($sale_details as $sale_detail) {
                        if ($sale_detail->status != 0) {
                            $grand_total = ($sale_detail->sale_price * $sale_detail->qty) - (($sale_detail->sale_price * $sale_detail->qty) * ($sale_detail->dis / 100));
                            $grand_total = $sale_detail->currency_id == 1 ? $grand_total / currencyExchange() : $grand_total;
                            $total += $grand_total;
                        }
                    }
                    $total = $total - ($total * $action->discount / 100);
                    return number_format($total, 2) . '$';
                })
                ->addColumn('remain', function ($action) {
                    $total = ($action->payment_amount - $action->paid_payment_amount) > 0 ? ($action->payment_amount - $action->paid_payment_amount) : 0;
                    return $total . '$';
                })
                ->addIndexColumn()
                ->rawColumns(['action', 'payment_status', 'status'])
                ->make(true);

        }

        return view('branch.seller_pos.index');
    }

    public function invoice_list()
    {
        return view('branch.seller_pos.invoice');
    }

    public function reciept_list()
    {
        return view('branch.seller_pos.reciept');
    }

    public function create(Request $request)
    {
        if ($request->ajax()) {
            $warehouse = $request->warehouse;
            $stock_item = StockModel::where('warehouse_id', $warehouse)
                ->join('nso007_product_unit', 'nso007_stocks.product_unit_id', 'nso007_product_unit.id')
                ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                ->leftJoin('nso007_unit as sub', 'nso007_product_unit.sub_unit_id', 'sub.id')
                ->groupBy('product_unit_id')
                ->selectRaw('sum(stock_qty) as qty,
                        sub.unit as sub,
                        qty_per_unit,
                        nso007_unit.unit as unit,
                        image,
                        product_name,
                        nso007_product_unit.id,
                        nso007_product_unit.barcode,
                        stock_qty')
                ->paginate(20);
            session()->forget('showSellerProduct');

            $html = view('branch.seller_pos.result_create', compact( 'stock_item'))->render();
            return response()->json(['html'=>$html]);
        }
        $customers = CustomerModel::where('member_type_id', 2)->pluck('customer_name', 'id');
        $dealers = CustomerModel::where('member_type_id', 3)->pluck('customer_name', 'id');
        $partners = CustomerModel::where('member_type_id', 4)->pluck('customer_name', 'id');
        $warehouse = WarehouseModel::pluck('warehouse_name','id');
        return view('branch.seller_pos.create', compact( 'customers', 'dealers', 'partners','warehouse'));
    }


    public function findProductPackageByQty(Request $request)
    {
        $saleProduct = session()->get('showSellerProduct');
        $qty = $request['qty'];
        $id = $request['id'];
        $re_unit = $request['package_unit_selected'];
        $first = MemberModel::where(['product_id' => $id])
//            ->whereNotIn('member_type', getVIP())
            ->where('qty', '<=', $qty)->OrderBy('qty', 'desc')->first();
        $last = MemberModel::where(['product_id' => $id])
//            ->whereNotIn('member_type', getVIP())
            ->where('qty', '>', $qty)->OrderBy('qty', 'asc')->first();
        if ($first && $last) {
            $first = $first->qty;
            $last = $last->qty;
            $packages = MemberModel::where(['product_id' => $id])->where('qty', '>=', $first)->where('qty', '<', $last)->first();
        } else {
            if($first){
                $packages = $first;
            }else{
                $packages = $last;
            }
        }
        $member_type = $packages ? $packages->id : '';
        $unit = $packages ? $packages->unit_id : '';
        $qtyStock = StockModel::where('warehouse_id', $request->warehouse_id)->where('product_unit_id', $id)->sum('stock_qty');
        $ownQty = ProductUnitModel::find($id);
        $ownQty ? ($ownQty->unit_id == $unit ? ($qty = $ownQty->qty_per_unit * $qty) : $qty) : null;
        $qty > $qtyStock ? $qty = 'gg' : $qty;

        $saleProduct[$id]['qty'] = ($qty === 'gg' ? 0 : $request['qty']);
        $saleProduct[$id]['package_unit_selected'] = $unit ? $unit : $re_unit;
        $saleProduct[$id]['member_package_selected'] = $member_type;
        $saleProduct[$id]['total'] = $request['qty']==$packages->qty?$packages->price:0;
        session()->put('showSellerProduct', $saleProduct);
        return response()->json(['message' => 'success', 'data' => $member_type]);
    }

    public function show($id)
    {
        $sale = SaleModel::where('nso007_sales.id', $id)
            ->leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
            ->leftJoin('nso007_customers', 'nso007_sales.customer_id', 'nso007_customers.id')
            ->leftJoin('users as dealer', 'nso007_sales.dealer_id', 'dealer.id')
            ->leftJoin('users', 'nso007_sales.user_id', 'users.id')
            ->leftJoin('nso007_hr_branch', 'users.branch_id', 'nso007_hr_branch.id')
            ->select(
                'nso007_sales.id',
                'nso007_sales.discount',
                'nso007_sales.created_at',
                'nso007_sales.invoice_number',
                'nso007_warehouse.warehouse_name',
                'nso007_customers.customer_name',
                'dealer.name as dealer_name',
                'users.name as sell_by',
                'nso007_hr_branch.name as branch_name'
            )->first();

        $sale_datail = SaleDetailsModel::where('nso007_sale_details.sale_id', $id)
            ->leftJoin('nso007_member as package', 'nso007_sale_details.package_id', 'package.id')
            ->leftJoin('nso007_unit as p_unit', 'nso007_sale_details.unit_id', 'p_unit.id')
            ->join('nso007_product_unit', 'nso007_sale_details.product_id', 'nso007_product_unit.id')
            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
            ->leftJoin('nso007_unit', 'nso007_product_unit.sub_unit_id', 'nso007_unit.id')
            ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
            ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
            ->selectRaw(
                'nso007_sale_details.qty,
                                nso007_sale_details.currency_id,
                                nso007_sale_details.sale_price,
                                nso007_sale_details.dis,
                                package.name as package_name,
                                p_unit.unit as package_unit_name,
                                nso007_products.product_name,
                                nso007_unit.unit,
                                nso007_product_color.name as color_name,
                                nso007_product_color.color as color,
                                nso007_product_size.size as size_name
                            ')
            ->get();
        return response()->json(['sale' => $sale, 'sale_detail' => $sale_datail]);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'id' => 'required',
            'warehouse_id' => 'required',
            'payment_type' => 'required|numeric',
            'reference' => $request['payment_type'] == 1 ? 'nullable' : ''
        ]);
        $warehouse = WarehouseModel::where('branch_id', Auth::user()->id)->orderBy('main', 'DESC')->first();
        $warehouse = $warehouse?$warehouse->id:'';
        $warehouse_id = $request->warehouse_id;
        $reference = null;
        if (@$request['reference']) {
            $files = $request['reference'];
            $original_name = date('ymdhis') . $request['reference']->getClientOriginalName();
            $destinationPath = 'images/purchase';
            $files->move($destinationPath, $original_name);
            $reference = $destinationPath . '/' . $original_name;
        }
        $customer = User::where('customer_id', $request->customer ? $request->customer : ($request->dealer ? $request->dealer : $request->partner))->first();
        $inv = getPrefixSale(). date("YmdhisA");
        if($warehouse_id==$warehouse){
            $discount = $request['discount'];
            $grand_total = $request['g_total_usd_hidden'];
            $paid_kh = $request['paid_kh'];
            $paid_usd = $request['paid_usd'];
            $paid_total_us = ($paid_kh / currencyExchange()) + $paid_usd;
            // customer warehouse
            $warehouse_cus = WarehouseModel::where('branch_id', $customer?$customer->id:'')->first();
            if (!$warehouse) {
                throw ValidationException::withMessages(['field_name' => 'You have not yet assign to any warehouse']);
            }

            $pos = new SaleModel;
            $pos->user_id = Auth::id();
            $pos->branch_id = Auth::user()->id;

            $pos->customer_id = $customer?$customer->id:'';
            $pos->dealer_id = $request->dealer ? $request->dealer : null;
            $pos->payment_status = $grand_total > $paid_total_us ? 'owe' : 'paid';
            $pos->invoice_number = $inv;
            $pos->year = date('Y');
            $pos->rate = getProductRate();
            // check if user role then set by it type
            $pos->sale_type = auth()->user()->is_role === 'Seller' ? 'seller-pos' : 'branch-pos';

            $pos->paid_amount_kh = $paid_kh;
            $pos->paid_amount_usd = $paid_usd;
            $pos->invoice_reference = $reference;
            $pos->discount = $discount;
            $pos->sale_date = Carbon::parse($request->date)->format('Y-m-d');
            $pos->warehouse_id = $warehouse_cus->id;
            $pos->status = 1;
            $pos->type = 'customer';
            $pos->save();
            $saleProduct = session()->get('showSellerProduct');
            if ($saleProduct) {
                foreach ($saleProduct as $item) {
                    $stock = StockModel::where('product_unit_id', $item['id'])->where('warehouse_id', $warehouse)->first();
                    $product_unit = ProductUnitModel::find($item['id']);
                    if ($product_unit->unit_id == $item['package_unit_selected']) {
                        $product_unit = $product_unit->qty_per_unit * $item['qty'];
                    } else {
                        $product_unit = $item['qty'];
                    }
                    if ($stock && $product_unit) {
                        $stock->update(['stock_qty' => $stock->stock_qty - $product_unit]);
                    }
                    // add stock customer
                    $stock = StockModel::where('product_unit_id', $item['id'])->where('warehouse_id', $warehouse_cus->id)->first();
                    $product_unit = ProductUnitModel::find($item['id']);
                    if ($product_unit->unit_id == $item['package_unit_selected']) {
                        $product_unit = $product_unit->qty_per_unit * $item['qty'];
                    } else {
                        $product_unit = $item['qty'];
                    }
                    if ($stock) {
                        $stock->update(['stock_qty' => $stock->stock_qty + $product_unit]);
                    } else {
                        $new = new StockModel;
                        $new->warehouse_id = $warehouse_cus->id;
                        $new->product_unit_id = $item['id'];
                        $new->stock_qty = $product_unit;
                        $new->save();
                    }

                    $pos_detail = new SaleDetailsModel();
                    $pos_detail->sale_id = $pos->id;
                    $pos_detail->shelf = $stock ? $stock->shelf : null;
                    $pos_detail->product_id = $item['id'];
                    $pos_detail->qty = $item['qty'];
                    $pos_detail->package_id = $item['member_package_selected'];
                    $pos_detail->unit_id = $item['package_unit_selected'];
                    $pos_detail->currency_id = $item['cur'];
                    $pos_detail->sale_price = $item['cost'];
                    $pos_detail->dis = $item['discount'];
                    $pos_detail->save();
                }
            }

            $payment = new PaymentModel();
            $payment->invoice_id = $pos->id;
            $payment->customer_id = $pos->customer_id;
            $payment->user_id = auth()->user()->id;
            $payment->payment_invoice = $pos->invoice_number;
            $payment->payment_date = Carbon::now();
            $payment->payment_amount = $grand_total;
            $payment->paid_amount = $paid_total_us;
            $payment->payment_status = $paid_total_us <= 0 ? 'owe' : 'paid';
            $payment->type = 'seller-pos';
            $payment->year = date('Y');
            $payment->status = 1;
            $payment->save();

            $payment_datail = new PaymentDetailModel();
            $payment_datail->payment_id = $payment->id;
            $payment_datail->paid_amount = $paid_total_us;
            $payment_datail->payment_date = Carbon::now();
            $payment_datail->note = 'seller-pos';
            $payment_datail->status = 1;
            $payment_datail->save();

            /* ====== Accounting ====== */
            $last_id_pos_clothes = $pos->id;
            $paid = $paid_total_us;
            $total = $grand_total;
            if ($paid >= $total) {
                $payment_status = 'paid';
            } else {
                if ($paid > 0) {
                    $payment_status = 'partial';
                } else {
                    $payment_status = 'due';
                }
            }
            if ($paid >= $total) {
                $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                $journal = new JournalModel;
                $journal->branch_id = Auth::user()->id;
                $journal->journal_parentid = 0;
                $journal->journal_type = 1;
                $journal->journal_acccode = 11001;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                $journal->journal_debit = $total;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 2;
                $journal->transaction_type = 'POS Retail';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_reference_number = $inv;
                $journal->journal_by = \Auth::id();
                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal = new JournalModel;
                $journal->branch_id = Auth::user()->id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 1;
                $journal->journal_acccode = 11006;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $total;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 2;
                $journal->transaction_type = 'POS Retail';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_reference_number = $inv;
                $journal->journal_by = \Auth::id();
                $journal->save();

            }
            else {
                if ($payment_status == 'partial') {
                    $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = Auth::user()->id;
                    $journal->journal_parentid = 0;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = 11001;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                    $journal->journal_debit = $paid;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = 'POS Retail';
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = \Auth::id();
                    $journal->save();

                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal = new JournalModel;
                    $journal->branch_id = Auth::user()->id;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = 11006;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                    $journal->journal_debit = 0;
                    $journal->journal_credit = $total;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = 'POS Retail';
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = \Auth::id();
                    $journal->save();

                    $jj1 = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal = new JournalModel;
                    $journal->branch_id = Auth::user()->id;
                    $journal->journal_parentid = $jj1->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = 11003;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                    $journal->journal_debit = $total-$paid;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = 'POS Retail';
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = \Auth::id();
                    $journal->save();
                } else {
                    $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = Auth::user()->id;
                    $journal->journal_parentid = 0;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = 11006;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                    $journal->journal_debit = 0;
                    $journal->journal_credit = $total;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = 'POS Retail';
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = \Auth::id();
                    $journal->save();

                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal = new JournalModel;
                    $journal->branch_id = Auth::user()->id;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = 11003;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'POS Retail ' . '(' . $inv . ')';
                    $journal->journal_debit = $total;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = 'POS Retail';
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $inv;
                    $journal->journal_by = \Auth::id();
                    $journal->save();
                }

            }

            /* ====== End Account ====== */
            session()->forget('showSellerProduct');
            session()->put('success', 'Wholesale created successfully.');
            return response()->json(['route'=>route('seller-pos.index'),'status'=>'ok']);
        }
        else{
            $purchaseOrderModel = new PurchaseOrderModel;

            $purchaseOrderModel->warehouse_id = $warehouse_id;
            $purchaseOrderModel->discount = $request['discount'];
            $purchaseOrderModel->paid_amount_kh =  $request['paid_kh'];
            $purchaseOrderModel->paid_amount_usd =  $request['paid_usd'];
            $purchaseOrderModel->customer_id = $customer?$customer->id:'';
            $purchaseOrderModel->payment_type = $request['payment_type'];
            $purchaseOrderModel->invoice_number = $inv;
            $purchaseOrderModel->reference = $reference;
            $purchaseOrderModel->purchase_date = date('Y-m-d',strtotime($request['date']));
            $purchaseOrderModel->comment = $request['note'];
            $purchaseOrderModel->purchase_type = 'wholesale';
            $purchaseOrderModel->request_type = 'sale-request';
            $purchaseOrderModel->year = date('Y');
            $purchaseOrderModel->user_id = \Auth::id();
            $purchaseOrderModel->transaction_code = 'TR'.date("YmdhisA");
            $purchaseOrderModel->request_by =  \Auth::id();
            $purchaseOrderModel->rate = getProductRate();
            $purchaseOrderModel->is_role = Auth::user()->is_role;
            $purchaseOrderModel->status = 0;
            $purchaseOrderModel->payment_status = 'owe';
            $purchaseOrderModel->save();
            foreach($request['id'] as $key=> $item){
                $purchaseOrderDetailModel = new PurchaseOrderDetailModel;
                $purchaseOrderDetailModel->product_unit_id = $item;
                $purchaseOrderDetailModel->purchase_order_id = $purchaseOrderModel->id;
                $purchaseOrderDetailModel->qty = $request['qty'][$key];
                $purchaseOrderDetailModel->member_package = $request['member_package'][$key];
                $purchaseOrderDetailModel->sale_price = $request['cost'][$key];
                $purchaseOrderDetailModel->dis = $request['item_discount'][$key];
                $purchaseOrderDetailModel->unit_id = $request['unit_id'][$key];
                $purchaseOrderDetailModel->date = date('Y-m-d',strtotime($request['date']));
                $purchaseOrderDetailModel->save();
            }
            session()->forget('showSellerProduct');
            session()->put('success', 'Wholesale request product created successfully.');
            return response()->json(['route' => route('seller-request-product.index'), 'status' => 'ok']);
        }
    }

    public static function generate_voucher_number($number_ref, $digit)
    {
        return str_pad($number_ref, $digit, "0", STR_PAD_LEFT);
    }

    public function new_customer(Request $request)
    {
        if ($request->ajax()) {
            if ($request->input('customer_name')) {
                $customer = new CustomerModel();
                $customer->customer_name = $request->input('customer_name');
                $customer->customer_phone = $request->input('customer_phone');
                $customer->customer_address = $request->input('customer_address');
                $customer->agent_id = Auth::user()->id;
                $customer->branch_id = Auth::user()->id;;
                $customer->save();
                return response()->json(['customer' => $customer]);
            }
        }
    }

    public function addProduct(Request $request, $id)
    {
        // session()->forget('showSellerProduct');
        $product_unit = \DB::table('nso007_product_unit')
            ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
            ->leftJoin('nso007_unit', 'nso007_product_unit.sub_unit_id', 'nso007_unit.id')
            ->selectRaw('nso007_product_unit.product_id, product_id, nso007_product_unit.cur, image, product_name, unit, nso007_product_unit.id, nso007_product_unit.barcode, retail_price')
            ->where('nso007_product_unit.id', $id)
            ->where(function ($q) use ($request, $id) {
                if ($request->type == 'id') {
                    $q->where('nso007_product_unit.id', $id);
                } else {
                    $q->where('nso007_product_unit.barcode', $id);
                }
            })
            ->first();

        $product = ProductModel::where('id', $product_unit->product_id)
            ->with('unit', 'unit_child')
            ->first(['unit_id', 'child_unit']);
        $units = [];

        if ($product) {
            if ($product->unit)
                $units[$product->unit->id] = $product->unit->unit;

            if ($product->unit_child)
                $units[$product->unit_child->id] = $product->unit_child->unit;
        }


        $package = \DB::table('product_package_details')
            ->leftJoin('nso007_products', 'product_package_details.product_id', 'nso007_products.id')
            ->leftJoin('nso007_member', 'product_package_details.package_id', 'nso007_member.id')
            ->leftJoin('nso007_member_type', 'nso007_member.member_type', 'nso007_member_type.id')
            ->where('product_package_details.product_id', $product_unit->product_id)
//            ->whereNotIn('member_type', getVIP())
            ->select(\DB::raw("CONCAT(product_name, '(', nso007_member_type.name, ')') AS name"), "nso007_member.id")
            ->pluck('name', 'id');

        $saleProduct = session()->get('showSellerProduct');
        if ($saleProduct) {
            if (@$saleProduct[$product_unit->id]) {
                return response()->json(['message' => 'warning', 'data' => __('administrator.product_adding_is_already_exist')]);
            } else {
                $saleProduct[$product_unit->id] = [
                    "id" => $product_unit->id,
                    "unit" => $product_unit->unit,
                    "package_unit" => $units,
                    "package_unit_selected" => 0,
                    "name" => $product_unit->product_name, //.'(Size:'.$product_unit->size .' Color: '.$product_unit->color.')',
                    "packages" => $package,
                    "member_package_selected" => '',
                    "qty" => 1,
                    "cur" => $product_unit->cur,
                    "cost" => $product_unit->retail_price,
                    "discount" => 0,
                    "total" => 0,
                ];
                session()->put('showSellerProduct', $saleProduct);
                return response()->json(['message' => 'success', 'data' => __('administrator.product_adding_successfully')]);
            }
        } else {
            $saleProduct[$product_unit->id] = [
                "id" => $product_unit->id,
                "unit" => $product_unit->unit,
                "package_unit" => $units,
                "package_unit_selected" => 0,
                "name" => $product_unit->product_name,//.'(Size '.$product_unit->size .', Color '.$product_unit->color.')',
                "packages" => $package,
                "member_package_selected" => '',
                "qty" => 1,
                "cur" => $product_unit->cur,
                "cost" => $product_unit->retail_price,
                "discount" => 0,
                "total" => 0,
            ];
            session()->put('showSellerProduct', $saleProduct);
            return $saleProduct[$product_unit->id];
            return response()->json(['message' => 'success', 'data' => __('administrator.product_added_successfully')]);
        };
    }

    public function getProduct()
    {
        $saleProduct = session()->get('showSellerProduct');
        $view = view('branch.seller_pos.product', compact('saleProduct'))->render();
        return response()->json(['html' => $view]);
    }

    public function updateProductPackage(Request $request, $id)
    {
        $package = MemberModel::find(@$request['package']);
        $cost = $request['cost'];
        $unit = $request['unit'];
        $qty = 0;
        if ($package) {
            $cost = $package->price;
            $unit = $package->unit_id;
            $qty = $package->qty;
        }
        // check stock
        $warehouse = $request->warehouse_id;
        $qtyStock = StockModel::where('warehouse_id', $warehouse)
            ->where('product_unit_id', $id)
            ->sum('stock_qty');
        $ownQty = ProductUnitModel::find($id);

        $ownQty ? ($ownQty->unit_id == $unit ? ($qty = $ownQty->qty_per_unit * $qty) : $qty) : null;
        $qty > $qtyStock ? $qty = 'gg' : $qty;

        $saleProduct = session()->get('showSellerProduct');
        $cost ? ($saleProduct[$id]['cost'] = $cost) : null;
        $saleProduct[$id]['qty'] = $qty == 'gg' ? 0 : $package->qty;
        $saleProduct[$id]['package_unit_selected'] = $unit;
        $saleProduct[$id]['member_package_selected'] = $request['package'];
        session()->put('showSellerProduct', $saleProduct);
        return response()->json(['message' => 'success', 'data' => $qty == 'gg' ? '' : 'Product updated successfully.']);
    }

    public function updateProduct(Request $request, $id)
    {
        $saleProduct = session()->get('showSellerProduct');
        $qty = $request['qty'];
        $cost = $request['cost'];
        $unit = $request['unit_id'];
        $package = $request['memeber_package'];

        $warehouse = $request->warehouse_id;
        $qtyStock = StockModel::where('warehouse_id', $warehouse)->where('product_unit_id', $id)->sum('stock_qty');
        $ownQty = ProductUnitModel::find($id);
        $ownQty ? ($ownQty->unit_id == $unit ? ($qty = $ownQty->qty_per_unit * $qty) : $qty) : null;
        $qty > $qtyStock ? $qty = 'gg' : $qty;

        $saleProduct[$id]['cost'] = $cost;
        $saleProduct[$id]['qty'] = $qty == 'gg' ? 0 : $request['qty'];
        $saleProduct[$id]['discount'] = $request['discount'];
        $saleProduct[$id]['package_unit_selected'] = $unit;
        $saleProduct[$id]['member_package_selected'] = $package;

        session()->put('showSellerProduct', $saleProduct);
        return response()->json(['message' => 'success', 'data' => $qty == 'gg' ? '' : 'Product updated successfully.']);
    }

    public function deleteProduct($id)
    {
        session()->forget('showSellerProduct.' . $id);
        return response()->json(['message' => 'success', 'data' => 'Product deleted successfully.']);
    }

    public function payment($id, Request $request)
    {
        $payment = PaymentModel::find($id);

        $payment->payment_date = $request->date;
        $payment->paid_amount = $payment->paid_amount + $request->amount;
        $payment->payment_status = ($payment->payment_amount - $payment->paid_amount) <= 0 ? 'paid' : 'owe';
        $payment->update();

        $payment_datail = new PaymentDetailModel();
        $payment_datail->payment_id = $payment->id;
        $payment_datail->paid_amount = $request->amount;
        $payment_datail->payment_date = $request->date;
        $payment_datail->note = 'seller-pos';
        $payment_datail->status = 1;
        $payment_datail->save();

        $sale = SaleModel::find($payment->invoice_id);
        $sale->update([
            'paid_amount_usd' => $sale->paid_amount_usd + $request->amount,
            'payment_status' => $payment->payment_status,
        ]);

        return response()->json(['status' => true, 'message' => 'Payment Update Successfully!']);
    }

    public function getSelectType($type)
    {
        $data = [];
        if ($type === 'customer') {
            $data = CustomerModel::where('user_id', auth()->user()->id)->pluck('customer_name', 'id');
        } else {
            $data = User::where('branch_id', auth()->user()->branch_id)->pluck('name', 'id');
        }

        return response()->json(['status' => 200, 'data' => $data]);
    }
}
