<?php

namespace App\Http\Controllers\Branch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\SaleModel;
use App\Model\WarehouseModel;
use App\Model\ProductUnitModel;
use App\Model\StockModel;
use App\Model\PaymentModel;
use App\Model\PaymentDetailModel;
use App\Model\SaleDetailsModel;
use DataTables;

class ProductAssignController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        return view('branch.product-assign.index');
    }

    public function reciept(Request $request)
    {
        return view('branch.product-assign.reciept');
    }

    public function datatables(Request $request)
    {
        if($request->ajax()){
            $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
                        ->join('users', 'nso007_warehouse.branch_id', 'users.id')
                        ->join('users as seller', 'nso007_sales.user_id', 'seller.id')
                        ->where('nso007_warehouse.branch_id', \Auth::id())
                        // ->leftJoin('nso007_member', 'nso007_sales.customer_id', 'nso007_member.id')
                        // ->leftJoin('users', 'nso007_member.user_id', 'users.id')
                        // ->leftJoin('nso007_hr_branch', 'users.branch_id', 'nso007_hr_branch.id')
                        
                        // ->leftJoin('nso007_payment as payment', 'nso007_sales.id', 'payment.invoice_id')
                        // ->where(function($q) use ($request){
                        //     if($request->brand){
                        //         $q->whereHas('brand', function($qa) use ($request){
                        //             $qa->where('brand', 'like', '%' . $request->brand . '%');
                        //         });
                        //     }
                        //     if($request->category){
                        //         $q->whereHas('category', function($qa) use ($request){
                        //             $qa->where('category_name', 'like', '%' . $request->category . '%');
                        //         });
                        //     }
                        //     if($request->product_name){
                        //         $q->where('product_name', 'like', '%' . $request->product_name . '%');
                        //     }
                        //     if($request->description){
                        //         $q->where('description', 'like', '%' . $request->description . '%');
                        //     }
                        //     if($request->commission){
                        //         $q->where('commission', 'like', '%' . $request->commission . '%');
                        //     }
                        //     if($request->created_at){
                        //         $q->whereDate('created_at', $request->created_at);
                        //     }
                        //     $q->where('status', 1);
                        // })
                        // ->where('nso007_sales.status', '!=' , 0)
                        // ->where('nso007_sales.sale_type', 'wholesale')
                        // ->where('nso007_sales.payment_status', $request->type)
                        ->selectRaw('
                            invoice_number,
                            warehouse_name,
                            users.name as branch_name,
                            seller.name as seller,
                            nso007_sales.id,
                            nso007_sales.status,
                            nso007_sales.payment_status,
                            paid_amount_kh')
                        ->orderBy('id', 'desc')
                        ->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));
                            // dd($data);
            return DataTables::of($data->items())
                    ->with([
                        "activePage" => $request->page,
                        "records" => $request->record,
                        "recordsTotal" => $data->total(),
                        "recordsFiltered" => $data->total(),
                        'totalPage' => $data->lastPage()
                    ])
                    ->addColumn('action', function($action){
                        if(!$action->status == 1 || !$action->status == 0){
                            // $unit = $action->product_units[0]->unit_id;
                            // $sub_unit = $action->product_units[0]->sub_unit_id;
                            // $brand_name = $action->brand?$action->brand->brand:'';
                            // $category_name = $action->category?$action->category->category_name:'';
                            // return  '<i href="javascript:;" class="fa fa-eye btn btn-sm btn-primary" data-id="'.$action->id.'" data-brand_name="'.$brand_name.'"  data-category_name="'.$category_name.'" data-product_name="'.$action->product_name.'" data-description="'.$action->description.'" data-commission="'.$action->commission.'" data-url = "' . route("products.show", $action->id) . '"  title="View Detail"></i>'.' '.
                            //         '<i href="javascript:;" data-sub_unit = "'.$sub_unit.'" data-unit_id = "'.$unit.'" data-brand_id = "'.$action->brand_id.'" data-currency = "'.$action->currency.'" data-category_id = "'.$action->category_id.'" data-url = "' . route("products.update", $action->id) . '" data-id="'.$action->id.'" data-product_name="'.$action->product_name.'" data-description="'.$action->description.'" data-commission="'.$action->commission.'"  class="fa fa-pencil btn btn-sm btn-warning" title="Edit"></i>'.' '.
                            //         '<i href="javascript:;" data-url = "' . route("products.destroy", $action->id) . '" class="fa fa-trash btn btn-sm btn-danger" title="Delete"></i>';
                            // return '<i href="javascript:;" data-url = "' . route("products.destroy", $action->id) . '" class="fa fa-trash btn btn-sm btn-danger" title="Delete"></i>';
                            // '<a href="' . route("wholesale.edit", $action->id) . '" ><i class="fa fa-pencil btn btn-sm btn-warning" title="Edit"></i></a>

                            $html = '<i href="javascript:;" data-seller="'.$action->seller.'" data-member="'.$action->member.'" data-branch_name="'.$action->branch_name.'" data-warehouse_name="'.$action->warehouse_name.'" class="fa fa-eye btn btn-sm btn-primary showDetail" data-created_at="'.$action->created_at.'" data-warehouse_name="'.$action->warehouse_name.'"  data-invoice="'.$action->invoice_number.'"  data-id="'.$action->id.'"  data-url = "' . route("product-assign.show", $action->id) . '"  title="View Detail"></i>';


                            if ($action->payment_status == 'owe')
                            {
                                $html .= '&nbsp;<a href="javascript:;"  class=" btn btn-sm btn-success payment" data-id="'.$action->payment_id.'" data-invoice_number="'.$action->invoice_number.'"  data-paid="'.$action->paid_payment_amount.'" data-amount="'.$action->payment_amount.'" data-url = "' . route("product-assgin.payment", $action->payment_id) . '"  title="View Detail">Payment</a>';
                            }

                            return $html;
                        }

                    })
                    ->editColumn('payment_status', function($action){
                        return '<span class="label '.($action->payment_status == "owe" ?"label-warning":"label-success").'">'.ucfirst($action->payment_status).'</span>';
                    })
                    ->editColumn('status', function($action){
                        switch ($action->status) {
                            case '1':
                                return '<span class="label label-success">Approved</span>';
                                break;
                            case '2':
                                return '<span class="label label-default">Padding</span>';
                                break;
                            case '4':
                                return '<span class="label label-danger">Canceled</span>';
                                break;
                            case '3':
                                return '<span class="label label-warning">Returned</span>';
                                break;
                            default:
                                break;
                        }
                    })
                    ->addColumn('paid', function($action){
                        return number_format($action->paid_amount_kh/currencyExchange() + $action->paid_amount_usd, 2).'$';
                    })
                    ->addColumn('total', function($action){
                        $total = 0;
                        $sale_details = \DB::table('nso007_sale_details')
                                            ->where('sale_id', $action->id)
                                            ->selectRaw('sale_price, dis, currency_id, qty, status')
                                            ->get();
                        foreach($sale_details as $sale_detail){
                            if($sale_detail->status != 0){
                                $grand_total = ($sale_detail->sale_price * $sale_detail->qty) - (($sale_detail->sale_price * $sale_detail->qty)*($sale_detail->dis/100));
                                $grand_total = $sale_detail->currency_id == 1 ? $grand_total/currencyExchange() : $grand_total;
                                $total += $grand_total;
                            }
                        }
                        $total = $total - ($total * $action->discount/100);
                        return number_format($total, 2).'$';
                    })
                    ->addColumn('remain', function($action){
                        $total = 0;
                        $sale_details = \DB::table('nso007_sale_details')
                                            ->where('sale_id', $action->id)
                                            ->selectRaw('sale_price, dis, currency_id, qty, status')
                                            ->get();
                        foreach($sale_details as $sale_detail){
                            if($sale_detail->status != 0){
                                $grand_total = ($sale_detail->sale_price * $sale_detail->qty) - (($sale_detail->sale_price * $sale_detail->qty)*($sale_detail->dis/100));
                                $grand_total = $sale_detail->currency_id == 1 ? $grand_total/currencyExchange() : $grand_total;
                                $total += $grand_total;
                            }

                        }
                        $total = $total - ($total * $action->discount/100);
                        return number_format($total -($action->paid_amount_kh/currencyExchange() + $action->paid_amount_usd), 2).'$';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'payment_status', 'status'])
                    ->make(true);
        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

        $saleProduct = session()->forget('showProduct');
        $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
                        ->leftJoin('nso007_member', 'nso007_sales.customer_id', 'nso007_member.id')
                        ->leftJoin('users', 'nso007_member.user_id', 'users.id')
                        ->leftJoin('nso007_hr_branch', 'users.branch_id', 'nso007_hr_branch.id')
                        ->leftJoin('users as seller', 'nso007_sales.user_id', 'seller.id')
                        ->join('nso007_sale_details', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                        ->orderBy('id', 'desc')
                        ->selectRaw('nso007_sale_details.status as sale_detail_status, nso007_sales.status as sale_status, nso007_sales.discount, nso007_sale_details.id as sale_detail_id, nso007_sale_details.qty, nso007_sale_details.dis, nso007_sale_details.sale_price, nso007_sales.discount, invoice_number, product_id, warehouse_name, nso007_hr_branch.name as branch_name, users.name as member, seller.name as seller, nso007_sales.id, nso007_sales.status, payment_status, paid_amount_kh, paid_amount_usd')
                        ->where('nso007_sales.id', $id)
                        ->get();
        foreach($data as $item){
            $product_unit = \DB::table('nso007_product_unit')
                                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                                    ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                                    ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                                    ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                                    ->selectRaw('nso007_product_unit.cur, image, product_name, unit, name as color, size, nso007_product_unit.id, nso007_product_unit.barcode, wholesale_price')
                                    ->where('nso007_product_unit.id', $item['product_id'])
                                    ->first();

            $saleProduct[$item['product_id']] = [
                "id" => $item['product_id'],
                "unit" => $product_unit->unit,
                "name" => $product_unit->product_name.'(Size:'.$product_unit->size .' Color: '.$product_unit->color.')',
                "qty" => $item['qty'],
                "paid_usd" => $item['paid_amount_usd'],
                "paid_kh" => $item['paid_amount_kh'],
                "cur" => $product_unit->cur,
                "cost" => $item['sale_price'],
                "discount" => $item['dis'],
                "total" => 0,
                "dis" => $item['discount'],
                "sale_detail_status" => $item['sale_detail_status'],
                "sale_status" => $item['sale_status'],
            ];
            session()->put('showProduct', $saleProduct);
        }
        $saleProduct = session()->get('showProduct');
        $view = view('branch.product-assign.show', compact('saleProduct'))->render();

        // status
        $status = $data[0]->status;
        $viewAction = view('branch.product-assign.button', compact('data', 'status'))->render();
        return response()->json(['html' =>$view, 'view' => $viewAction]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function updateProductAssign(Request $request, $type = '', $id = '')
    {
        $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
                        ->leftJoin('nso007_member', 'nso007_sales.customer_id', 'nso007_member.id')
                        ->leftJoin('users', 'nso007_member.user_id', 'users.id')
                        ->leftJoin('nso007_hr_branch', 'users.branch_id', 'nso007_hr_branch.id')
                        ->leftJoin('users as seller', 'nso007_sales.user_id', 'seller.id')
                        ->join('nso007_sale_details', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                        ->orderBy('id', 'desc')
                        ->selectRaw('nso007_sale_details.shelf, currency_id, nso007_sales.discount, nso007_sale_details.id as sale_detail_id, nso007_sale_details.qty, nso007_sale_details.dis, nso007_sale_details.sale_price, nso007_sales.discount, invoice_number, product_id, warehouse_name, nso007_hr_branch.name as branch_name, users.name as member, seller.name as seller, nso007_sales.id, nso007_sales.status, payment_status, paid_amount_kh, paid_amount_usd')
                        ->where('nso007_sales.id', $id)
                        ->get();

        $warehouse = WarehouseModel::whereRaw('branch_id = ? && user_id == ?', [\Auth::id(), \Auth::id()])
                                    ->first()->id;
        if($type == 'approve'){
            $total = 0;
            foreach($data as $item){
                // $product_unit = ProductUnitModel::find($item['product_id'])->qty_per_unit;
                // $qty = $product_unit*$item['qty'];
                $qty = $item['qty'];
                $total = ($item->sale_price*$item['qty']) - (($item->sale_price*$item['qty'])*($item->dis/100));
                $total += $item->currency_id == 1 ? $total/currencyExchange():$total;
                $stockModel = StockModel::whereRaw('warehouse_id = ? && product_unit_id = ?', [$warehouse, $item['product_id']])->first();
                if($stockModel){
                    $stockModel->stock_qty += $qty;
                    $stockModel->update();
                }else{
                    $stockModel = new StockModel;
                    $stockModel->product_unit_id = $item['product_id'];
                    $stockModel->warehouse_id = $warehouse;
                    $stockModel->stock_qty = $qty;
                    $stockModel->save();
                }
            }
            $total_paid = $data[0]['paid_amount_kh'] / currencyExchange() ? $data[0]['paid_amount_kh'] / currencyExchange() : (0 + $data[0]['paid_amount_usd'] ? $data[0]['paid_amount_usd'] : 0);
            $total = $total - ($total*($data[0]['discount']/100));

            // payment
            $payment = new PaymentModel;
            $payment->user_id = \Auth::id();
            $payment->payment_invoice = 'PI' . date('YmdHis');;
            $payment->invoice_id = $data[0]['id'];
            $payment->payment_date = date('Y-m-d');
            $payment->payment_amount = $total;
            $payment->paid_amount = $total_paid >= $total ? $total: $total_paid;
            $payment->payment_status = $total_paid >= $total ? 'paid' : 'owe';
            $payment->year = date('Y');
            $payment->status = 1;
            $payment->type = 'sale';
            $payment->save();

            // payment detail
            $payment_detail = new PaymentDetailModel;
            $payment_detail->payment_id = $payment->id;
            $payment_detail->paid_amount = $total_paid >= $total ? $total: $total_paid;
            $payment_detail->payment_date = date('Y-m-d');
            $payment_detail->status = 1;
            $payment_detail->save();

            SaleModel::find($id)->update([
                'status' => 1
            ]);

        }elseif($type == 'cancel'){
            foreach($data as $item){
                // $product_unit = ProductUnitModel::find($item['product_id'])->qty_per_unit;
                // $qty = $product_unit*$item['qty'];
                $qty = $item['qty'];
                $total = ($item->sale_price*$item['qty']) - (($item->sale_price*$item['qty'])*($item->dis/100));
                $total += $item->currency_id == 1 ? $total/currencyExchange():$total;
                $stockModel = StockModel::whereRaw('warehouse_id = ? && product_unit_id = ? && shelf = ?', [getMainWarehouse()?getMainWarehouse():0, $item['product_id'], $item['shelf']])->first();
                if($stockModel){
                    $stockModel->stock_qty += $qty;
                    $stockModel->update();
                }else{
                    $stockModel = new StockModel;
                    $stockModel->product_unit_id = $item['product_id'];
                    $stockModel->warehouse_id = $warehouse;
                    $stockModel->stock_qty = $qty;
                    $stockModel->save();
                }
            }
            SaleModel::find($id)->update([
                'status' => 4,
                'reason' => $request['reason']
            ]);
        }elseif($type == 'return'){
            $data_id = explode(',', $request->id);
            $data_cancel = $data->whereIn('product_id', $data_id);
            $data_approved = $data->whereNotIn('product_id', $data_id);
            if(count($data_approved) > 0){
                foreach($data_approved as $item){
                    // $product_unit = ProductUnitModel::find($item['product_id'])->qty_per_unit;
                    // $qty = $product_unit*$item['qty'];
                    $qty = $item['qty'];
                    $total = ($item->sale_price*$item['qty']) - (($item->sale_price*$item['qty'])*($item->dis/100));
                    $total += $item->currency_id == 1 ? $total/currencyExchange():$total;
                    $stockModel = StockModel::whereRaw('warehouse_id = ? && product_unit_id = ?', [$warehouse, $item['product_id']])->first();
                    if($stockModel){
                        $stockModel->stock_qty += $qty;
                        $stockModel->update();
                    }else{
                        $stockModel = new StockModel;
                        $stockModel->product_unit_id = $item['product_id'];
                        $stockModel->warehouse_id = $warehouse;
                        $stockModel->stock_qty = $qty;
                        $stockModel->save();
                    }
                }

                $total_paid = $data[0]['paid_amount_kh']/currencyExchange()?$data[0]['paid_amount_kh']/currencyExchange():(0 + $data[0]['paid_amount_usd']?$data[0]['paid_amount_usd']:0);
                $total = $total - ($total*($data[0]['discount']/100));

                // payment
                $payment = new PaymentModel;
                $payment->user_id = \Auth::id();
                $payment->payment_invoice = 'PI' . date('YmdHis');;
                $payment->invoice_id = $data[0]['id'];
                $payment->payment_date = date('Y-m-d');
                $payment->payment_amount = $total;
                $payment->paid_amount = $total_paid >= $total ? $total: $total_paid;
                $payment->payment_status = $total_paid >= $total ? 'paid' : 'owe';
                $payment->year = date('Y');
                $payment->status = 1;
                $payment->type = 'sale';
                $payment->save();

                // payment detail
                $payment_detail = new PaymentDetailModel;
                $payment_detail->payment_id = $payment->id;
                $payment_detail->paid_amount = $total_paid >= $total ? $total: $total_paid;
                $payment_detail->payment_date = date('Y-m-d');
                $payment_detail->status = 1;
                $payment_detail->save();
            }

            if(count($data_cancel) > 0){
                foreach($data_cancel as $item1){
                    // $product_unit = ProductUnitModel::find($item1['product_id'])->qty_per_unit;
                    // $qty = $product_unit*$item1['qty'];
                    $qty = $item1['qty'];
                    $total = ($item1->sale_price*$item1['qty']) - (($item1->sale_price*$item1['qty'])*($item1->dis/100));
                    $total += $item1->currency_id == 1 ? $total/currencyExchange():$total;
                    $stockModel = StockModel::whereRaw('warehouse_id = ? && product_unit_id = ? && shelf = ?', [getMainWarehouse()?getMainWarehouse():0, $item1['product_id'], $item1['shelf']])->first();
                    if($stockModel){
                        $stockModel->stock_qty += $qty;
                        $stockModel->update();
                    }else{
                        $stockModel = new StockModel;
                        $stockModel->product_unit_id = $item1['product_id'];
                        $stockModel->warehouse_id = $warehouse;
                        $stockModel->stock_qty = $qty;
                        $stockModel->save();
                    }
                    SaleDetailsModel::find($item1['sale_detail_id'])->update([
                        'status' => 0
                    ]);
                }
            }
            SaleModel::find($id)->update([
                'status' => 3,
                'reason' => $request['reason']
            ]);
        }
        return response()->json('');
    }

    public function payment($id, Request $request)
    {
        // return $request->all();
        $payment = PaymentModel::find($id);

        $payment->payment_date = $request->date;
        $payment->paid_amount = $payment->paid_amount + $request->amount;
        $payment->payment_status =  ($payment->payment_amount - $payment->paid_amount) <= 0 ? 'paid' : 'owe';
        $payment->update();

        $payment_datail = new PaymentDetailModel();
        $payment_datail->payment_id = $payment->id;
        $payment_datail->paid_amount = $request->amount;
        $payment_datail->payment_date = $request->date;
        $payment_datail->note = 'wholesale';
        $payment_datail->status = 1;
        $payment_datail->save();

        $sale = SaleModel::find($payment->invoice_id);
        $sale->update([
            'paid_amount_usd'   => $sale->paid_amount_usd + $request->amount,
            'payment_status'    => $payment->payment_status,
        ]);

        return response()->json(['status' => true, 'message' => 'Payment Update Successfully!']);
    }
}
